/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api;

import android.content.Context;
import com.chuckerteam.chucker.api.RetentionManager;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransaction;
import com.chuckerteam.chucker.api.internal.data.entity.RecordedThrowable;
import com.chuckerteam.chucker.api.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.api.internal.support.NotificationHelper;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0015\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/chuckerteam/chucker/api/ChuckerCollector;", "", "context", "Landroid/content/Context;", "showNotification", "", "retentionPeriod", "Lcom/chuckerteam/chucker/api/RetentionManager$Period;", "(Landroid/content/Context;ZLcom/chuckerteam/chucker/api/RetentionManager$Period;)V", "notificationHelper", "Lcom/chuckerteam/chucker/api/internal/support/NotificationHelper;", "retentionManager", "Lcom/chuckerteam/chucker/api/RetentionManager;", "getShowNotification", "()Z", "setShowNotification", "(Z)V", "onError", "", "tag", "", "throwable", "", "onRequestSent", "transaction", "Lcom/chuckerteam/chucker/api/internal/data/entity/HttpTransaction;", "onRequestSent$library_release", "onResponseReceived", "onResponseReceived$library_release", "library_release"})
public final class ChuckerCollector {
    private final RetentionManager retentionManager;
    private final NotificationHelper notificationHelper;
    private boolean showNotification;

    public final void onError(@NotNull String tag, @NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        RecordedThrowable recordedThrowable = new RecordedThrowable(tag, throwable);
        RepositoryProvider.throwable().saveThrowable(recordedThrowable);
        if (this.showNotification) {
            this.notificationHelper.show(recordedThrowable);
        }
        this.retentionManager.doMaintenance$library_release();
    }

    public final void onRequestSent$library_release(@NotNull HttpTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        RepositoryProvider.transaction().insertTransaction(transaction);
        if (this.showNotification) {
            this.notificationHelper.show(transaction);
        }
        this.retentionManager.doMaintenance$library_release();
    }

    public final void onResponseReceived$library_release(@NotNull HttpTransaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        int updated = RepositoryProvider.transaction().updateTransaction(transaction);
        if (this.showNotification && updated > 0) {
            this.notificationHelper.show(transaction);
        }
    }

    public final boolean getShowNotification() {
        return this.showNotification;
    }

    public final void setShowNotification(boolean bl) {
        this.showNotification = bl;
    }

    @JvmOverloads
    public ChuckerCollector(@NotNull Context context, boolean showNotification, @NotNull RetentionManager.Period retentionPeriod) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)retentionPeriod), (String)"retentionPeriod");
        this.showNotification = showNotification;
        this.retentionManager = new RetentionManager(context, retentionPeriod);
        this.notificationHelper = new NotificationHelper(context);
        RepositoryProvider.initialize(context);
    }

    public /* synthetic */ ChuckerCollector(Context context, boolean bl, RetentionManager.Period period, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            period = RetentionManager.Period.ONE_WEEK;
        }
        this(context, bl, period);
    }

    @JvmOverloads
    public ChuckerCollector(@NotNull Context context, boolean showNotification) {
        this(context, showNotification, null, 4, null);
    }

    @JvmOverloads
    public ChuckerCollector(@NotNull Context context) {
        this(context, false, null, 6, null);
    }
}

