/*
 * Decompiled with CFR 0.152.
 */
package com.chuckerteam.chucker.api.internal.ui.transaction;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.chuckerteam.chucker.R;
import com.chuckerteam.chucker.api.internal.data.entity.HttpTransactionTuple;
import com.chuckerteam.chucker.api.internal.data.repository.RepositoryProvider;
import com.chuckerteam.chucker.api.internal.support.NotificationHelper;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionActivity;
import com.chuckerteam.chucker.api.internal.ui.transaction.TransactionAdapter;
import java.util.List;

public class TransactionListFragment
extends Fragment
implements SearchView.OnQueryTextListener,
TransactionAdapter.TransactionClickListListener,
Observer<List<HttpTransactionTuple>> {
    private String currentFilter = "";
    private TransactionAdapter adapter;
    LiveData<List<HttpTransactionTuple>> dataSource;

    public static TransactionListFragment newInstance() {
        return new TransactionListFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chucker_fragment_transaction_list, container, false);
        if (view instanceof RecyclerView) {
            Context context = view.getContext();
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
            this.adapter = new TransactionAdapter(this.getContext(), this);
            recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        }
        return view;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.dataSource = this.getDataSource(this.currentFilter);
        this.dataSource.observe((LifecycleOwner)this, (Observer)this);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.chucker_transactions_list, menu2);
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)searchMenuItem.getActionView();
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.askForConfirmation();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void askForConfirmation() {
        new AlertDialog.Builder(this.getContext()).setTitle(R.string.chucker_clear).setMessage(R.string.chucker_clear_http_confirmation).setPositiveButton(R.string.chucker_clear, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RepositoryProvider.transaction().deleteAllTransactions();
                NotificationHelper.clearBuffer();
            }
        }).setNegativeButton(R.string.chucker_cancel, null).show();
    }

    public boolean onQueryTextSubmit(String query) {
        return true;
    }

    public boolean onQueryTextChange(String newText) {
        this.currentFilter = newText;
        this.dataSource.removeObservers((LifecycleOwner)this);
        this.dataSource = this.getDataSource(this.currentFilter);
        this.dataSource.observe((LifecycleOwner)this, (Observer)this);
        return true;
    }

    private LiveData<List<HttpTransactionTuple>> getDataSource(String currentFilter) {
        if (currentFilter.isEmpty()) {
            return RepositoryProvider.transaction().getSortedTransactionTuples();
        }
        if (TextUtils.isDigitsOnly((CharSequence)currentFilter)) {
            return RepositoryProvider.transaction().getFilteredTransactionTuples(currentFilter, "");
        }
        return RepositoryProvider.transaction().getFilteredTransactionTuples("", currentFilter);
    }

    public void onChanged(@Nullable List<HttpTransactionTuple> tuples) {
        this.adapter.setData(tuples);
    }

    @Override
    public void onTransactionClick(long transactionId, int position) {
        TransactionActivity.start((Context)this.getActivity(), transactionId);
    }
}

