/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.data;

import android.net.Uri;
import com.google.gson.reflect.TypeToken;
import com.readystatesoftware.chuck.internal.data.HttpHeader;
import com.readystatesoftware.chuck.internal.support.FormatUtils;
import com.readystatesoftware.chuck.internal.support.JsonConvertor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nl.qbusict.cupboard.annotation.Index;
import okhttp3.Headers;

public class HttpTransaction {
    public static final String[] PARTIAL_PROJECTION = new String[]{"_id", "requestDate", "tookMs", "method", "host", "path", "scheme", "requestContentLength", "responseCode", "error", "responseContentLength"};
    private Long _id;
    @Index
    private Date requestDate;
    private Date responseDate;
    private Long tookMs;
    private String protocol;
    private String method;
    private String url;
    private String host;
    private String path;
    private String scheme;
    private Long requestContentLength;
    private String requestContentType;
    private String requestHeaders;
    private String requestBody;
    private boolean requestBodyIsPlainText = true;
    private Integer responseCode;
    private String responseMessage;
    private String error;
    private Long responseContentLength;
    private String responseContentType;
    private String responseHeaders;
    private String responseBody;
    private boolean responseBodyIsPlainText = true;

    public Long getId() {
        return this._id;
    }

    public HttpTransaction setId(long id) {
        this._id = id;
        return this;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public HttpTransaction setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
        return this;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public HttpTransaction setResponseDate(Date responseDate) {
        this.responseDate = responseDate;
        return this;
    }

    public String getError() {
        return this.error;
    }

    public HttpTransaction setError(String error) {
        this.error = error;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpTransaction setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public HttpTransaction setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getFormattedRequestBody() {
        return this.formatBody(this.requestBody, this.requestContentType);
    }

    public HttpTransaction setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public boolean requestBodyIsPlainText() {
        return this.requestBodyIsPlainText;
    }

    public HttpTransaction setRequestBodyIsPlainText(boolean requestBodyIsPlainText) {
        this.requestBodyIsPlainText = requestBodyIsPlainText;
        return this;
    }

    public Long getRequestContentLength() {
        return this.requestContentLength;
    }

    public HttpTransaction setRequestContentLength(Long requestContentLength) {
        this.requestContentLength = requestContentLength;
        return this;
    }

    public String getRequestContentType() {
        return this.requestContentType;
    }

    public HttpTransaction setRequestContentType(String requestContentType) {
        this.requestContentType = requestContentType;
        return this;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getFormattedResponseBody() {
        return this.formatBody(this.responseBody, this.responseContentType);
    }

    public HttpTransaction setResponseBody(String responseBody) {
        this.responseBody = responseBody;
        return this;
    }

    public boolean responseBodyIsPlainText() {
        return this.responseBodyIsPlainText;
    }

    public HttpTransaction setResponseBodyIsPlainText(boolean responseBodyIsPlainText) {
        this.responseBodyIsPlainText = responseBodyIsPlainText;
        return this;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public HttpTransaction setResponseCode(Integer responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public Long getResponseContentLength() {
        return this.responseContentLength;
    }

    public HttpTransaction setResponseContentLength(Long responseContentLength) {
        this.responseContentLength = responseContentLength;
        return this;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public HttpTransaction setResponseContentType(String responseContentType) {
        this.responseContentType = responseContentType;
        return this;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public HttpTransaction setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    public Long getTookMs() {
        return this.tookMs;
    }

    public HttpTransaction setTookMs(Long tookMs) {
        this.tookMs = tookMs;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpTransaction setUrl(String url) {
        this.url = url;
        Uri uri = Uri.parse((String)url);
        this.host = uri.getHost();
        this.path = uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
        this.scheme = uri.getScheme();
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpTransaction setRequestHeaders(Headers headers) {
        this.setRequestHeaders(this.toHttpHeaderList(headers));
        return this;
    }

    public HttpTransaction setRequestHeaders(List<HttpHeader> headers) {
        this.requestHeaders = JsonConvertor.getInstance().toJson(headers);
        return this;
    }

    public List<HttpHeader> getRequestHeaders() {
        return (List)JsonConvertor.getInstance().fromJson(this.requestHeaders, new TypeToken<List<HttpHeader>>(){}.getType());
    }

    public String getRequestHeadersString(boolean withMarkup) {
        return FormatUtils.formatHeaders(this.getRequestHeaders(), withMarkup);
    }

    public HttpTransaction setResponseHeaders(Headers headers) {
        this.setResponseHeaders(this.toHttpHeaderList(headers));
        return this;
    }

    public HttpTransaction setResponseHeaders(List<HttpHeader> headers) {
        this.responseHeaders = JsonConvertor.getInstance().toJson(headers);
        return this;
    }

    public List<HttpHeader> getResponseHeaders() {
        return (List)JsonConvertor.getInstance().fromJson(this.responseHeaders, new TypeToken<List<HttpHeader>>(){}.getType());
    }

    public String getResponseHeadersString(boolean withMarkup) {
        return FormatUtils.formatHeaders(this.getResponseHeaders(), withMarkup);
    }

    public Status getStatus() {
        if (this.error != null) {
            return Status.Failed;
        }
        if (this.responseCode == null) {
            return Status.Requested;
        }
        return Status.Complete;
    }

    public String getRequestDateString() {
        return this.requestDate != null ? this.requestDate.toString() : null;
    }

    public String getResponseDateString() {
        return this.responseDate != null ? this.responseDate.toString() : null;
    }

    public String getDurationString() {
        return this.tookMs != null ? this.tookMs + " ms" : null;
    }

    public String getRequestSizeString() {
        return this.formatBytes(this.requestContentLength != null ? this.requestContentLength : 0L);
    }

    public String getResponseSizeString() {
        return this.responseContentLength != null ? this.formatBytes(this.responseContentLength) : null;
    }

    public String getTotalSizeString() {
        long reqBytes = this.requestContentLength != null ? this.requestContentLength : 0L;
        long resBytes = this.responseContentLength != null ? this.responseContentLength : 0L;
        return this.formatBytes(reqBytes + resBytes);
    }

    public String getResponseSummaryText() {
        switch (this.getStatus()) {
            case Failed: {
                return this.error;
            }
            case Requested: {
                return null;
            }
        }
        return String.valueOf(this.responseCode) + " " + this.responseMessage;
    }

    public String getNotificationText() {
        switch (this.getStatus()) {
            case Failed: {
                return " ! ! !  " + this.method + " " + this.path;
            }
            case Requested: {
                return " . . .  " + this.method + " " + this.path;
            }
        }
        return String.valueOf(this.responseCode) + " " + this.method + " " + this.path;
    }

    public boolean isSsl() {
        return this.scheme.toLowerCase().equals("https");
    }

    private List<HttpHeader> toHttpHeaderList(Headers headers) {
        ArrayList<HttpHeader> httpHeaders = new ArrayList<HttpHeader>();
        int count = headers.size();
        for (int i = 0; i < count; ++i) {
            httpHeaders.add(new HttpHeader(headers.name(i), headers.value(i)));
        }
        return httpHeaders;
    }

    private String formatBody(String body, String contentType) {
        if (contentType != null && contentType.toLowerCase().contains("json")) {
            return FormatUtils.formatJson(body);
        }
        if (contentType != null && contentType.toLowerCase().contains("xml")) {
            return FormatUtils.formatXml(body);
        }
        return body;
    }

    private String formatBytes(long bytes) {
        return FormatUtils.formatByteCount(bytes, true);
    }

    public static enum Status {
        Requested,
        Complete,
        Failed;

    }
}

