/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.data;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.readystatesoftware.chuck.api.Chuck;
import com.readystatesoftware.chuck.internal.data.ChuckDbOpenHelper;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.data.RecordedThrowable;

public class ChuckContentProvider
extends ContentProvider {
    public static Uri TRANSACTION_URI;
    public static Uri ERROR_URI;
    private static final int TRANSACTION = 0;
    private static final int TRANSACTIONS = 1;
    private static final int ERROR = 2;
    private static final int ERRORS = 3;
    public static final int LOADER_TRANSACTION_DETAIL = 0;
    public static final int LOADER_TRANSACTIONS = 1;
    public static final int LOADER_ERROR_DETAIL = 2;
    public static final int LOADER_ERRORS = 3;
    private static final UriMatcher matcher;
    private ChuckDbOpenHelper databaseHelper;

    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        Chuck.init(context);
        TRANSACTION_URI = Uri.parse((String)("content://" + info.authority + "/transaction"));
        ERROR_URI = Uri.parse((String)("content://" + info.authority + "/error"));
        matcher.addURI(info.authority, "transaction/#", 0);
        matcher.addURI(info.authority, "transaction", 1);
        matcher.addURI(info.authority, "error/#", 2);
        matcher.addURI(info.authority, "error", 3);
    }

    public boolean onCreate() {
        this.databaseHelper = new ChuckDbOpenHelper(this.getContext());
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = null;
        switch (matcher.match(uri)) {
            case 1: {
                cursor = LocalCupboard.getInstance().withDatabase(db).query(HttpTransaction.class).withProjection(projection).withSelection(selection, selectionArgs).orderBy(sortOrder).getCursor();
                break;
            }
            case 0: {
                cursor = LocalCupboard.getInstance().withDatabase(db).query(HttpTransaction.class).byId(ContentUris.parseId((Uri)uri)).getCursor();
                break;
            }
            case 3: {
                cursor = LocalCupboard.getInstance().withDatabase(db).query(RecordedThrowable.class).withProjection(projection).withSelection(selection, selectionArgs).orderBy(sortOrder).getCursor();
                break;
            }
            case 2: {
                cursor = LocalCupboard.getInstance().withDatabase(db).query(RecordedThrowable.class).byId(ContentUris.parseId((Uri)uri)).getCursor();
            }
        }
        if (cursor != null) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues contentValues) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        switch (matcher.match(uri)) {
            case 1: {
                long id = db.insert(LocalCupboard.getInstance().getTable(HttpTransaction.class), null, contentValues);
                if (id <= 0L) break;
                this.getContext().getContentResolver().notifyChange(uri, null);
                return ContentUris.withAppendedId((Uri)TRANSACTION_URI, (long)id);
            }
            case 3: {
                long errorId = db.insert(LocalCupboard.getInstance().getTable(RecordedThrowable.class), null, contentValues);
                if (errorId <= 0L) break;
                this.getContext().getContentResolver().notifyChange(uri, null);
                return ContentUris.withAppendedId((Uri)TRANSACTION_URI, (long)errorId);
            }
        }
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int result = 0;
        switch (matcher.match(uri)) {
            case 1: {
                result = db.delete(LocalCupboard.getInstance().getTable(HttpTransaction.class), selection, selectionArgs);
                break;
            }
            case 0: {
                result = db.delete(LocalCupboard.getInstance().getTable(HttpTransaction.class), "_id = ?", new String[]{(String)uri.getPathSegments().get(1)});
                break;
            }
            case 3: {
                result = db.delete(LocalCupboard.getInstance().getTable(RecordedThrowable.class), selection, selectionArgs);
                break;
            }
            case 2: {
                result = db.delete(LocalCupboard.getInstance().getTable(RecordedThrowable.class), "_id = ?", new String[]{(String)uri.getPathSegments().get(1)});
            }
        }
        if (result > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return result;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues contentValues, @Nullable String selection, @Nullable String[] selectionArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int result = 0;
        switch (matcher.match(uri)) {
            case 1: {
                result = db.update(LocalCupboard.getInstance().getTable(HttpTransaction.class), contentValues, selection, selectionArgs);
                break;
            }
            case 0: {
                result = db.update(LocalCupboard.getInstance().getTable(HttpTransaction.class), contentValues, "_id = ?", new String[]{(String)uri.getPathSegments().get(1)});
            }
        }
        if (result > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return result;
    }

    static {
        matcher = new UriMatcher(-1);
    }
}

