/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.api;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.readystatesoftware.chuck.api.ChuckCollector;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.support.IOUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public final class ChuckInterceptor
implements Interceptor {
    private static final String LOG_TAG = ChuckInterceptor.class.getSimpleName();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final ChuckCollector collector;
    private final IOUtils io;
    private long maxContentLength = 250000L;

    public ChuckInterceptor(Context context) {
        this.collector = new ChuckCollector(context);
        this.io = new IOUtils(context);
    }

    public ChuckInterceptor(Context context, ChuckCollector collector) {
        this.collector = collector;
        this.io = new IOUtils(context);
    }

    public ChuckInterceptor maxContentLength(long max) {
        this.maxContentLength = max;
        return this;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        HttpTransaction transaction = new HttpTransaction().setRequestDate(new Date()).setMethod(request.method()).setUrl(request.url().toString()).setRequestHeaders(request.headers());
        if (hasRequestBody) {
            if (requestBody.contentType() != null) {
                transaction.setRequestContentType(requestBody.contentType().toString());
            }
            if (requestBody.contentLength() != -1L) {
                transaction.setRequestContentLength(requestBody.contentLength());
            }
        }
        boolean encodingIsSupported = this.io.bodyHasSupportedEncoding(request.headers().get("Content-Encoding"));
        transaction.setRequestBodyIsPlainText(encodingIsSupported);
        if (hasRequestBody && encodingIsSupported) {
            BufferedSource source = this.io.getNativeSource((BufferedSource)new Buffer(), this.io.bodyIsGzipped(request.headers().get("Content-Encoding")));
            Buffer buffer = source.buffer();
            requestBody.writeTo((BufferedSink)buffer);
            Charset charset = UTF8;
            MediaType contentType = requestBody.contentType();
            if (contentType != null) {
                charset = contentType.charset(UTF8);
            }
            if (this.io.isPlaintext(buffer)) {
                String content = this.io.readFromBuffer(buffer, charset, this.maxContentLength);
                transaction.setRequestBody(content);
            } else {
                transaction.setResponseBodyIsPlainText(false);
            }
        }
        Uri transactionUri = this.collector.onRequestSent(transaction);
        long startNs = System.nanoTime();
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            transaction.setError(e.toString());
            this.collector.onResponseReceived(transaction, transactionUri);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        transaction.setRequestHeaders(response.request().headers()).setResponseDate(new Date()).setTookMs(tookMs).setProtocol(response.protocol().toString()).setResponseCode(response.code()).setResponseMessage(response.message());
        transaction.setResponseContentLength(responseBody.contentLength());
        if (responseBody.contentType() != null) {
            transaction.setResponseContentType(responseBody.contentType().toString());
        }
        transaction.setResponseHeaders(response.headers());
        boolean responseEncodingIsSupported = this.io.bodyHasSupportedEncoding(response.headers().get("Content-Encoding"));
        transaction.setResponseBodyIsPlainText(responseEncodingIsSupported);
        if (HttpHeaders.hasBody((Response)response) && responseEncodingIsSupported) {
            BufferedSource source = this.getNativeSource(response);
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = UTF8;
            MediaType contentType = responseBody.contentType();
            if (contentType != null) {
                try {
                    charset = contentType.charset(UTF8);
                }
                catch (UnsupportedCharsetException e) {
                    this.collector.onResponseReceived(transaction, transactionUri);
                    return response;
                }
            }
            if (this.io.isPlaintext(buffer)) {
                String content = this.io.readFromBuffer(buffer.clone(), charset, this.maxContentLength);
                transaction.setResponseBody(content);
            } else {
                transaction.setResponseBodyIsPlainText(false);
            }
            transaction.setResponseContentLength(buffer.size());
        }
        this.collector.onResponseReceived(transaction, transactionUri);
        return response;
    }

    private BufferedSource getNativeSource(Response response) throws IOException {
        if (this.io.bodyIsGzipped(response.headers().get("Content-Encoding"))) {
            BufferedSource source = response.peekBody(this.maxContentLength).source();
            if (source.buffer().size() < this.maxContentLength) {
                return this.io.getNativeSource(source, true);
            }
            Log.w((String)LOG_TAG, (String)"gzip encoded response was too long");
        }
        return response.body().source();
    }
}

