/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui.error;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.ChuckContentProvider;
import com.readystatesoftware.chuck.internal.data.RecordedThrowable;
import com.readystatesoftware.chuck.internal.support.NotificationHelper;
import com.readystatesoftware.chuck.internal.support.SQLiteUtils;
import com.readystatesoftware.chuck.internal.ui.error.ErrorAdapter;

public class ErrorListFragment
extends Fragment
implements LoaderManager.LoaderCallbacks<Cursor> {
    private ErrorAdapter adapter;
    private ErrorAdapter.ErrorListListener listener;

    public static Fragment newInstance() {
        return new ErrorListFragment();
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof ErrorAdapter.ErrorListListener)) {
            throw new IllegalArgumentException("Context must implement the listener.");
        }
        this.listener = (ErrorAdapter.ErrorListListener)context;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chuck_fragment_error_list, container, false);
        if (view instanceof RecyclerView) {
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
            this.adapter = new ErrorAdapter(this.getContext(), this.listener);
            recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        }
        return view;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.getLoaderManager().initLoader(3, null, (LoaderManager.LoaderCallbacks)this);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.chuck_errors_list, menu2);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.getContext().getContentResolver().delete(ChuckContentProvider.ERROR_URI, null, null);
            NotificationHelper.clearBuffer();
            return true;
        }
        if (item.getItemId() == R.id.browse_sql) {
            SQLiteUtils.browseDatabase(this.getContext());
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, @Nullable Bundle args) {
        CursorLoader loader = new CursorLoader(this.getContext());
        loader.setUri(ChuckContentProvider.ERROR_URI);
        loader.setProjection(RecordedThrowable.PARTIAL_PROJECTION);
        loader.setSortOrder("date DESC");
        return loader;
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor data) {
        this.adapter.swapCursor(data);
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
        this.adapter.swapCursor(null);
    }
}

