/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui.error;

import android.content.Context;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.v4.widget.CursorAdapter;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;
import com.readystatesoftware.chuck.internal.data.RecordedThrowable;
import java.text.DateFormat;

public class ErrorAdapter
extends RecyclerView.Adapter<ErrorViewHolder> {
    private final CursorAdapter cursorAdapter;
    private final ErrorListListener listener;
    private final Context context;

    public ErrorAdapter(@NonNull Context context, @NonNull ErrorListListener listener) {
        this.context = context;
        this.listener = listener;
        this.cursorAdapter = new CursorAdapter(context, null, 2){

            public View newView(Context context, Cursor cursor, ViewGroup parent) {
                View view = LayoutInflater.from((Context)context).inflate(R.layout.chuck_list_item_error, parent, false);
                view.setTag((Object)new ErrorViewHolder(view));
                return view;
            }

            public void bindView(View view, Context context, Cursor cursor) {
                RecordedThrowable throwable = (RecordedThrowable)LocalCupboard.getInstance().withCursor(cursor).get(RecordedThrowable.class);
                final ErrorViewHolder holder = (ErrorViewHolder)((Object)view.getTag());
                holder.bind(throwable);
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ErrorAdapter.this.listener.onClick(holder.throwable);
                    }
                });
            }
        };
    }

    @NonNull
    public ErrorViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View v = this.cursorAdapter.newView(this.context, this.cursorAdapter.getCursor(), parent);
        return new ErrorViewHolder(v);
    }

    public void onBindViewHolder(@NonNull ErrorViewHolder holder, int position) {
        this.cursorAdapter.getCursor().moveToPosition(position);
        this.cursorAdapter.bindView(holder.itemView, this.context, this.cursorAdapter.getCursor());
    }

    public int getItemCount() {
        return this.cursorAdapter.getCount();
    }

    public void swapCursor(Cursor data) {
        this.cursorAdapter.swapCursor(data);
        this.notifyDataSetChanged();
    }

    public static interface ErrorListListener {
        public void onClick(RecordedThrowable var1);
    }

    public static class ErrorViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView tag;
        private final TextView clazz;
        private final TextView message;
        private final TextView date;
        private RecordedThrowable throwable;

        public ErrorViewHolder(View itemView) {
            super(itemView);
            this.tag = (TextView)itemView.findViewById(R.id.tag);
            this.clazz = (TextView)itemView.findViewById(R.id.clazz);
            this.message = (TextView)itemView.findViewById(R.id.message);
            this.date = (TextView)itemView.findViewById(R.id.date);
        }

        public void bind(RecordedThrowable throwable) {
            this.throwable = throwable;
            this.tag.setText((CharSequence)throwable.getTag());
            this.clazz.setText((CharSequence)throwable.getClazz());
            this.message.setText((CharSequence)throwable.getMessage());
            this.date.setText((CharSequence)DateFormat.getDateTimeInstance(3, 2).format(throwable.getDate()));
        }
    }
}

