/*
 * Decompiled with CFR 0.152.
 */
package com.nareshchocha.filepickerlibrary.utilities;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.Keep;
import com.nareshchocha.filepickerlibrary.utilities.extentions.FilePathExtentionsKt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\u0014"}, d2={"Lcom/nareshchocha/filepickerlibrary/utilities/FileUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getExternalDocumentPath", "getFilePath", "getRealPath", "fileUri", "pathFromURI", "getDownloadsDocumentPath", "getMediaDocumentPath", "filepickerlibrary_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/nareshchocha/filepickerlibrary/utilities/FileUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,194:1\n731#2,9:195\n731#2,9:206\n37#3,2:204\n37#3,2:215\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/nareshchocha/filepickerlibrary/utilities/FileUtils\n*L\n76#1:195,9\n123#1:206,9\n76#1:204,2\n123#1:215,2\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @Keep
    @Nullable
    public final String getRealPath(@NotNull Context context, @NotNull Uri fileUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        return this.pathFromURI(context, fileUri);
    }

    @Keep
    private final String pathFromURI(Context context, Uri uri) {
        return DocumentsContract.isDocumentUri((Context)context, (Uri)uri) ? (FilePathExtentionsKt.isExternalStorageDocument(uri) ? this.getExternalDocumentPath(uri) : (FilePathExtentionsKt.isDownloadsDocument(uri) ? this.getDownloadsDocumentPath(context, uri) : (FilePathExtentionsKt.isMediaDocument(uri) ? this.getMediaDocumentPath(context, uri) : null))) : (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true) ? (FilePathExtentionsKt.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null)) : (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true) ? uri.getPath() : null));
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    private final String getMediaDocumentPath(Context $this$getMediaDocumentPath, Uri uri) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
        Object object = docId;
        Regex regex = new Regex(":");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        String thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        String type = split[0];
        Uri contentUri = null;
        switch (type) {
            case "image": {
                contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                break;
            }
            case "video": {
                contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                break;
            }
            case "audio": {
                contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
            }
        }
        String selection = "_id=?";
        String[] stringArray = new String[]{split[1]};
        String[] selectionArgs = stringArray;
        return this.getDataColumn($this$getMediaDocumentPath, contentUri, selection, selectionArgs);
    }

    @Keep
    private final String getDownloadsDocumentPath(Context $this$getDownloadsDocumentPath, Uri uri) {
        Regex regex;
        String id2;
        String fileName = this.getFilePath($this$getDownloadsDocumentPath, uri);
        if (fileName != null) {
            String cfr_ignored_0 = Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName;
        }
        String string2 = id2 = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
        if (StringsKt.startsWith$default((String)string2, (String)"raw:", (boolean)false, (int)2, null)) {
            String string3 = id2;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id");
            CharSequence charSequence = string3;
            regex = new Regex("raw:");
            String string4 = "";
            id2 = regex.replaceFirst(charSequence, string4);
            File file = new File(id2);
            if (file.exists()) {
                return id2;
            }
        }
        Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
        Long l = Long.valueOf(id2);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(id)");
        regex = ContentUris.withAppendedId((Uri)uri2, (long)((Number)l).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)regex, (String)"withAppendedId(\n        \u2026ng.valueOf(id),\n        )");
        Regex contentUri = regex;
        return this.getDataColumn($this$getDownloadsDocumentPath, (Uri)contentUri, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @Keep
    private final String getExternalDocumentPath(Uri uri) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String docId = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
        Object object = docId;
        Regex regex = new Regex(":");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] split = thisCollection$iv.toArray(new String[0]);
        String type = split[0];
        return StringsKt.equals((String)"primary", (String)type, (boolean)true) ? (split.length > 1 ? Environment.getExternalStorageDirectory().toString() + "/" + split[1] : Environment.getExternalStorageDirectory().toString() + "/") : "storage/" + StringsKt.replace$default((String)docId, (String)":", (String)"/", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String column = "_data";
            String[] stringArray = new String[]{column};
            String[] projection = stringArray;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    private final String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String[] stringArray = new String[]{"_display_name"};
            String[] projection = stringArray;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor = contentResolver.query(uri2, projection, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow("_display_name");
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }
}

