/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import com.core.util.R;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0003J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\u001b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010 \u001a\u00020\u0011H\u0007J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\"\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010#\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\bH\u0007J\u0018\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0011H\u0007J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0011H\u0007J\u0010\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006+"}, d2={"Lcom/core/util/StatusBarUtil;", "", "()V", "FLAG_FULLSCREEN", "", "activity", "Landroid/app/Activity;", "MIUISetStatusBarLightMode", "", "window", "Landroid/view/Window;", "dark", "checkDeviceHasNavigationBar", "context", "Landroid/content/Context;", "flymeSetStatusBarLightMode", "getActionBarHeight", "", "getNavigationBarHeight", "getStatusBarHeight", "hideNotificationBar", "hideStatusBar", "invokePanels", "methodName", "", "isStatusBarExists", "noTitle", "setHeightAndPadding", "view", "Landroid/view/View;", "setMargin", "setNavigationBarColor", "color", "setNoTitle", "setPadding", "setPaddingSmart", "setTransparentStatusBar", "showNotificationBar", "isSettingPanel", "statusBarDarkMode", "type", "statusBarLightMode", "transparencyBar", "XUtils_release"})
public final class StatusBarUtil {
    @NotNull
    public static final StatusBarUtil INSTANCE;

    @JvmStatic
    public static final void hideStatusBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        StatusBarUtil.noTitle(activity);
        StatusBarUtil.FLAG_FULLSCREEN(activity);
    }

    @JvmStatic
    public static final void setTransparentStatusBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().clearFlags(0x4000000);
            Window window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
            view.setSystemUiVisibility(0x400 | 0x100);
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            Window window2 = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"activity.window");
            window2.setStatusBarColor(0);
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
        }
    }

    @JvmStatic
    public static final void setNoTitle(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.requestWindowFeature(1);
    }

    @JvmStatic
    public static final void noTitle(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        StatusBarUtil.setNoTitle(activity);
    }

    @JvmStatic
    public static final void FLAG_FULLSCREEN(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getWindow().setFlags(1024, 1024);
    }

    @JvmStatic
    public static final int getStatusBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @JvmStatic
    public static final boolean isStatusBarExists(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        WindowManager.LayoutParams params = window.getAttributes();
        return (params.flags & 0x400) != 1024;
    }

    @JvmStatic
    public static final int getActionBarHeight(@NotNull Activity activity) {
        int n;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        TypedValue tv = new TypedValue();
        if (activity.getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
            int n2 = tv.data;
            Resources resources = activity.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"activity.resources");
            n = TypedValue.complexToDimensionPixelSize((int)n2, (DisplayMetrics)resources.getDisplayMetrics());
        } else {
            n = 0;
        }
        return n;
    }

    @JvmStatic
    public static final void showNotificationBar(@NotNull Context context, boolean isSettingPanel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String methodName = Build.VERSION.SDK_INT <= 16 ? "expand" : (isSettingPanel ? "expandSettingsPanel" : "expandNotificationsPanel");
        INSTANCE.invokePanels(context, methodName);
    }

    @JvmStatic
    public static final void hideNotificationBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String methodName = Build.VERSION.SDK_INT <= 16 ? "collapse" : "collapsePanels";
        INSTANCE.invokePanels(context, methodName);
    }

    @SuppressLint(value={"WrongConstant"})
    private final void invokePanels(Context context, String methodName) {
        try {
            Object service = context.getSystemService("statusbar");
            Class<?> statusBarManager = Class.forName("android.app.StatusBarManager");
            Method expand = statusBarManager.getMethod(methodName, new Class[0]);
            expand.invoke(service, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JvmStatic
    public static final void transparencyBar(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0xC000000);
            Window window2 = window;
            Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"window");
            View view = window2.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"window.decorView");
            view.setSystemUiVisibility(1792);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
            window.setNavigationBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    @JvmStatic
    public static final int statusBarLightMode(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        int result = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            if (StatusBarUtil.MIUISetStatusBarLightMode(activity.getWindow(), true)) {
                result = 1;
            } else if (StatusBarUtil.flymeSetStatusBarLightMode(activity.getWindow(), true)) {
                result = 2;
            } else if (Build.VERSION.SDK_INT >= 23) {
                Window window = activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                View view = window.getDecorView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
                view.setSystemUiVisibility(9216);
                result = 3;
            }
        }
        return result;
    }

    @JvmStatic
    public static final void statusBarLightMode(@NotNull Activity activity, int type) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (type == 1) {
            StatusBarUtil.MIUISetStatusBarLightMode(activity.getWindow(), true);
        } else if (type == 2) {
            StatusBarUtil.flymeSetStatusBarLightMode(activity.getWindow(), true);
        } else if (type == 3) {
            Window window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
            view.setSystemUiVisibility(9216);
        }
    }

    @JvmStatic
    public static final void statusBarDarkMode(@NotNull Activity activity, int type) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (type == 1) {
            StatusBarUtil.MIUISetStatusBarLightMode(activity.getWindow(), false);
        } else if (type == 2) {
            StatusBarUtil.flymeSetStatusBarLightMode(activity.getWindow(), false);
        } else if (type == 3) {
            Window window = activity.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
            View view = window.getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
            view.setSystemUiVisibility(0);
        }
    }

    @JvmStatic
    public static final boolean flymeSetStatusBarLightMode(@Nullable Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                Field field = darkFlag;
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"darkFlag");
                field.setAccessible(true);
                Field field2 = meizuFlags;
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"meizuFlags");
                field2.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? value | bit : value & ~bit;
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @JvmStatic
    public static final boolean MIUISetStatusBarLightMode(@Nullable Window window, boolean dark) {
        boolean result = false;
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                int darkModeFlag = 0;
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @JvmStatic
    public static final void setNavigationBarColor(@NotNull Window window, @ColorInt int color) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (Build.VERSION.SDK_INT >= 21) {
            window.setNavigationBarColor(color);
        }
    }

    @JvmStatic
    public static final boolean checkDeviceHasNavigationBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean hasNavigationBar = false;
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        Resources resources2 = resources;
        int id2 = resources2.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id2 > 0) {
            hasNavigationBar = resources2.getBoolean(id2);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method method = systemPropertiesClass.getMethod("get", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"systemPropertiesClass.ge\u2026get\", String::class.java)");
            Method m = method;
            Object object = m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String navBarOverride = (String)object;
            if (Intrinsics.areEqual((Object)"1", (Object)navBarOverride)) {
                hasNavigationBar = false;
            } else if (Intrinsics.areEqual((Object)"0", (Object)navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNavigationBar;
    }

    public final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        Resources resources2 = resources;
        int resourceId = resources2.getIdentifier("navigation_bar_height", "dimen", "android");
        return resources2.getDimensionPixelSize(resourceId);
    }

    public final void setPadding(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (Build.VERSION.SDK_INT >= 19) {
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public final void setPaddingSmart(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp != null && lp.height > 0) {
                lp.height += StatusBarUtil.getStatusBarHeight(context);
            }
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public final void setHeightAndPadding(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            lp.height += StatusBarUtil.getStatusBarHeight(context);
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public final void setMargin(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)lp).topMargin += StatusBarUtil.getStatusBarHeight(context);
            }
            view.setLayoutParams(lp);
        }
    }

    private StatusBarUtil() {
    }

    static {
        StatusBarUtil statusBarUtil;
        INSTANCE = statusBarUtil = new StatusBarUtil();
    }
}

