/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.core.util.FileUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\n\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0007J&\u0010\n\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u0016"}, d2={"Lcom/core/util/IntentUtil;", "", "()V", "getAppDetailsSettingsIntent", "Landroid/content/Intent;", "mContext", "Landroid/content/Context;", "packageName", "", "getAppInfoIntent", "getComponentNameIntent", "className", "bundle", "Landroid/os/Bundle;", "getInstallAppIntent", "context", "filePath", "getIntentByPackageName", "getLaunchAppIntent", "getShareInfoIntent", "info", "getUninstallAppIntent", "XUtils_release"})
public final class IntentUtil {
    @NotNull
    public static final IntentUtil INSTANCE;

    @JvmStatic
    @Nullable
    public static final Intent getInstallAppIntent(@Nullable Context context, @Nullable String filePath) {
        File apkfile = new File(filePath);
        if (!apkfile.exists()) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        Uri contentUri = FileUtil.getUriForFile(context2, apkfile);
        intent.setFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 24) {
            intent.addFlags(3);
        }
        intent.setDataAndType(contentUri, "application/vnd.android.package-archive");
        return intent;
    }

    @JvmStatic
    @NotNull
    public static final Intent getUninstallAppIntent(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = new Intent("android.intent.action.DELETE");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        Intent intent2 = intent.addFlags(0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)");
        return intent2;
    }

    @JvmStatic
    @Nullable
    public static final Intent getLaunchAppIntent(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return INSTANCE.getIntentByPackageName(context, packageName);
    }

    private final Intent getIntentByPackageName(Context context, String packageName) {
        return context.getPackageManager().getLaunchIntentForPackage(packageName);
    }

    @JvmStatic
    @NotNull
    public static final Intent getAppInfoIntent(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Intent intent2 = intent.setData(Uri.parse((String)("package:" + packageName)));
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent.setData(Uri.parse(\"package:$packageName\"))");
        return intent2;
    }

    @JvmStatic
    @NotNull
    public static final Intent getShareInfoIntent(@Nullable String info) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        Intent intent2 = intent.putExtra("android.intent.extra.TEXT", info);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent.putExtra(Intent.EXTRA_TEXT, info)");
        return intent2;
    }

    @JvmStatic
    @NotNull
    public static final Intent getComponentNameIntent(@Nullable String packageName, @Nullable String className) {
        return IntentUtil.getComponentNameIntent(packageName, className, null);
    }

    @JvmStatic
    @NotNull
    public static final Intent getComponentNameIntent(@Nullable String packageName, @Nullable String className, @Nullable Bundle bundle) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        String string = packageName;
        Intrinsics.checkNotNull((Object)string);
        String string2 = className;
        Intrinsics.checkNotNull((Object)string2);
        ComponentName cn = new ComponentName(string, string2);
        intent.setComponent(cn);
        Intent intent2 = intent.addFlags(0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)");
        return intent2;
    }

    @JvmStatic
    @NotNull
    public static final Intent getAppDetailsSettingsIntent(@NotNull Context mContext) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts((String)"package", (String)mContext.getPackageName(), null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction("android.intent.action.VIEW");
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", mContext.getPackageName());
        }
        return localIntent;
    }

    @JvmStatic
    @NotNull
    public static final Intent getAppDetailsSettingsIntent(@Nullable String packageName) {
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        if (Build.VERSION.SDK_INT >= 9) {
            localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            localIntent.setData(Uri.fromParts((String)"package", (String)packageName, null));
        } else if (Build.VERSION.SDK_INT <= 8) {
            localIntent.setAction("android.intent.action.VIEW");
            localIntent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            localIntent.putExtra("com.android.settings.ApplicationPkgName", packageName);
        }
        return localIntent;
    }

    private IntentUtil() {
    }

    static {
        IntentUtil intentUtil;
        INSTANCE = intentUtil = new IntentUtil();
    }
}

