/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import com.core.util.DataUtil;
import com.core.util.EncodeUtil;
import com.core.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010\u001d\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010 \u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010!\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010\"\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010#\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010$\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010%\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001e\u0010&\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010'\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010(\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010)\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010+\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010,\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010-\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010.\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010/\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u00100\u001a\u0004\u0018\u00010\u00132\u0006\u00101\u001a\u000202H\u0007J\u0014\u00100\u001a\u0004\u0018\u00010\u00132\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u00104\u001a\u00020\u00042\u0006\u00101\u001a\u000202H\u0007J\u0012\u00104\u001a\u00020\u00042\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013H\u0007J\u0012\u00105\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004H\u0007J\u0012\u00107\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u00108\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u00108\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u00109\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010:\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010;\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010<\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010=\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010>\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010>\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0012\u0010?\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u0010@\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\t\u00a8\u0006A"}, d2={"Lcom/core/util/EncryptUtil;", "", "()V", "AES_Algorithm", "", "AES_Transformation", "getAES_Transformation", "()Ljava/lang/String;", "setAES_Transformation", "(Ljava/lang/String;)V", "DES_Algorithm", "DES_Transformation", "getDES_Transformation", "setDES_Transformation", "TripleDES_Algorithm", "TripleDES_Transformation", "getTripleDES_Transformation", "setTripleDES_Transformation", "DESTemplet", "", "data", "key", "algorithm", "transformation", "isEncrypt", "", "decrypt3DES", "decryptAES", "decryptBase64AES", "decryptBase64DES", "decryptBase64_3DES", "decryptDES", "decryptHexString3DES", "decryptHexStringAES", "decryptHexStringDES", "encrypt3DES", "encrypt3DES2Base64", "encrypt3DES2HexString", "encryptAES", "encryptAES2Base64", "encryptAES2HexString", "encryptAlgorithm", "encryptDES", "encryptDES2Base64", "encryptDES2HexString", "encryptMD2", "encryptMD2ToString", "encryptMD5", "encryptMD5File", "file", "Ljava/io/File;", "filePath", "encryptMD5File2String", "encryptMD5ToString", "salt", "encryptSHA1", "encryptSHA1ToString", "encryptSHA224", "encryptSHA224ToString", "encryptSHA256", "encryptSHA256ToString", "encryptSHA384", "encryptSHA384ToString", "encryptSHA512", "encryptSHA512ToString", "XUtils_release"})
public final class EncryptUtil {
    private static final String DES_Algorithm = "DES";
    private static final String TripleDES_Algorithm = "DESede";
    private static final String AES_Algorithm = "AES";
    @NotNull
    private static String DES_Transformation;
    @NotNull
    private static String TripleDES_Transformation;
    @NotNull
    private static String AES_Transformation;
    @NotNull
    public static final EncryptUtil INSTANCE;

    @NotNull
    public final String getDES_Transformation() {
        return DES_Transformation;
    }

    public final void setDES_Transformation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        DES_Transformation = string;
    }

    @NotNull
    public final String getTripleDES_Transformation() {
        return TripleDES_Transformation;
    }

    public final void setTripleDES_Transformation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        TripleDES_Transformation = string;
    }

    @NotNull
    public final String getAES_Transformation() {
        return AES_Transformation;
    }

    public final void setAES_Transformation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        AES_Transformation = string;
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD2ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptMD2ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD2ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptMD2(data));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptMD2(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "MD2");
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD5ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptMD5ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD5ToString(@NotNull String data, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        String string = data + salt;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return DataUtil.bytes2HexString(EncryptUtil.encryptMD5(byArray));
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD5ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptMD5(data));
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD5ToString(@NotNull byte[] data, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        byte[] dataSalt = new byte[data.length + salt.length];
        System.arraycopy(data, 0, dataSalt, 0, data.length);
        System.arraycopy(salt, 0, dataSalt, data.length, salt.length);
        return DataUtil.bytes2HexString(EncryptUtil.encryptMD5(dataSalt));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptMD5(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "MD5");
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptMD5(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptMD5(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD5File2String(@Nullable String filePath) {
        return EncryptUtil.encryptMD5File2String(new File(filePath));
    }

    @JvmStatic
    @Nullable
    public static final byte[] encryptMD5File(@Nullable String filePath) {
        return EncryptUtil.encryptMD5File(new File(filePath));
    }

    @JvmStatic
    @NotNull
    public static final String encryptMD5File2String(@NotNull File file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (EncryptUtil.encryptMD5File(file) != null) {
            byte[] byArray = EncryptUtil.encryptMD5File(file);
            Intrinsics.checkNotNull((Object)byArray);
            string = DataUtil.bytes2HexString(byArray);
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    @JvmStatic
    @Nullable
    public static final byte[] encryptMD5File(@NotNull File file) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buffer);
            byArray = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            FileUtil.closeIO(fis);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    FileUtil.closeIO(fis);
                    throw throwable;
                }
            }
            FileUtil.closeIO(fis);
        }
        FileUtil.closeIO(fis);
        return byArray;
        return null;
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA1ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptSHA1ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA1ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptSHA1(data));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptSHA1(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "SHA-1");
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA224ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptSHA224ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA224ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptSHA224(data));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptSHA224(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "SHA-224");
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA256ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptSHA256ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA256ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptSHA256(data));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptSHA256(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "SHA-256");
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA384ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptSHA384ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA384ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptSHA384(data));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptSHA384(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "SHA-384");
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA512ToString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncryptUtil.encryptSHA512ToString(byArray);
    }

    @JvmStatic
    @NotNull
    public static final String encryptSHA512ToString(@Nullable byte[] data) {
        return DataUtil.bytes2HexString(EncryptUtil.encryptSHA512(data));
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptSHA512(@Nullable byte[] data) {
        return INSTANCE.encryptAlgorithm(data, "SHA-512");
    }

    private final byte[] encryptAlgorithm(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            byte[] byArray = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md.digest()");
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    @JvmStatic
    @Nullable
    public static final byte[] DESTemplet(@Nullable byte[] data, @Nullable byte[] key, @Nullable String algorithm, @Nullable String transformation, boolean isEncrypt) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(transformation);
            SecureRandom random = new SecureRandom();
            cipher.init(isEncrypt ? 1 : 2, (Key)keySpec, random);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptDES2Base64(@Nullable byte[] data, @Nullable byte[] key) {
        return EncodeUtil.base64Encode(EncryptUtil.encryptDES(data, key));
    }

    @JvmStatic
    @NotNull
    public static final String encryptDES2HexString(@Nullable byte[] data, @Nullable byte[] key) {
        byte[] byArray = EncryptUtil.encryptDES(data, key);
        Intrinsics.checkNotNull((Object)byArray);
        return DataUtil.bytes2HexString(byArray);
    }

    @JvmStatic
    @Nullable
    public static final byte[] encryptDES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.DESTemplet(data, key, DES_Algorithm, DES_Transformation, true);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptBase64DES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.decryptDES(EncodeUtil.base64Decode(data), key);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptHexStringDES(@Nullable String data, @Nullable byte[] key) {
        String string = data;
        Intrinsics.checkNotNull((Object)string);
        return EncryptUtil.decryptDES(DataUtil.hexString2Bytes(string), key);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptDES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.DESTemplet(data, key, DES_Algorithm, DES_Transformation, false);
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt3DES2Base64(@Nullable byte[] data, @Nullable byte[] key) {
        return EncodeUtil.base64Encode(EncryptUtil.encrypt3DES(data, key));
    }

    @JvmStatic
    @NotNull
    public static final String encrypt3DES2HexString(@Nullable byte[] data, @Nullable byte[] key) {
        byte[] byArray = EncryptUtil.encrypt3DES(data, key);
        Intrinsics.checkNotNull((Object)byArray);
        return DataUtil.bytes2HexString(byArray);
    }

    @JvmStatic
    @Nullable
    public static final byte[] encrypt3DES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.DESTemplet(data, key, TripleDES_Algorithm, TripleDES_Transformation, true);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptBase64_3DES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.decrypt3DES(EncodeUtil.base64Decode(data), key);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptHexString3DES(@Nullable String data, @Nullable byte[] key) {
        String string = data;
        Intrinsics.checkNotNull((Object)string);
        return EncryptUtil.decrypt3DES(DataUtil.hexString2Bytes(string), key);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decrypt3DES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.DESTemplet(data, key, TripleDES_Algorithm, TripleDES_Transformation, false);
    }

    @JvmStatic
    @NotNull
    public static final byte[] encryptAES2Base64(@Nullable byte[] data, @Nullable byte[] key) {
        return EncodeUtil.base64Encode(EncryptUtil.encryptAES(data, key));
    }

    @JvmStatic
    @NotNull
    public static final String encryptAES2HexString(@Nullable byte[] data, @Nullable byte[] key) {
        byte[] byArray = EncryptUtil.encryptAES(data, key);
        Intrinsics.checkNotNull((Object)byArray);
        return DataUtil.bytes2HexString(byArray);
    }

    @JvmStatic
    @Nullable
    public static final byte[] encryptAES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.DESTemplet(data, key, AES_Algorithm, AES_Transformation, true);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptBase64AES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.decryptAES(EncodeUtil.base64Decode(data), key);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptHexStringAES(@Nullable String data, @Nullable byte[] key) {
        String string = data;
        Intrinsics.checkNotNull((Object)string);
        return EncryptUtil.decryptAES(DataUtil.hexString2Bytes(string), key);
    }

    @JvmStatic
    @Nullable
    public static final byte[] decryptAES(@Nullable byte[] data, @Nullable byte[] key) {
        return EncryptUtil.DESTemplet(data, key, AES_Algorithm, AES_Transformation, false);
    }

    private EncryptUtil() {
    }

    static {
        EncryptUtil encryptUtil;
        INSTANCE = encryptUtil = new EncryptUtil();
        DES_Transformation = "DES/ECB/NoPadding";
        TripleDES_Transformation = "DESede/ECB/NoPadding";
        AES_Transformation = "AES/ECB/NoPadding";
    }
}

