/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import android.os.Build;
import android.text.Html;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\b\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/core/util/EncodeUtil;", "", "()V", "base64Decode", "", "input", "", "base64Encode", "base64Encode2String", "base64UrlSafeEncode", "htmlDecode", "htmlEncode", "urlDecode", "charset", "urlEncode", "XUtils_release"})
public final class EncodeUtil {
    @NotNull
    public static final EncodeUtil INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlEncode(@NotNull String input, @Nullable String charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            String string2 = URLEncoder.encode(input, charset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URLEncoder.encode(input, charset)");
            string = string2;
        }
        catch (UnsupportedEncodingException e) {
            string = input;
        }
        return string;
    }

    public static /* synthetic */ String urlEncode$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UTF-8";
        }
        return EncodeUtil.urlEncode(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlEncode(@NotNull String input) {
        return EncodeUtil.urlEncode$default(input, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlDecode(@NotNull String input, @Nullable String charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            String string2 = URLDecoder.decode(input, charset);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URLDecoder.decode(input, charset)");
            string = string2;
        }
        catch (UnsupportedEncodingException e) {
            string = input;
        }
        return string;
    }

    public static /* synthetic */ String urlDecode$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "UTF-8";
        }
        return EncodeUtil.urlDecode(string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String urlDecode(@NotNull String input) {
        return EncodeUtil.urlDecode$default(input, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Encode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return EncodeUtil.base64Encode(byArray);
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Encode(@Nullable byte[] input) {
        byte[] byArray = Base64.encode((byte[])input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.encode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final String base64Encode2String(@Nullable byte[] input) {
        String string = Base64.encodeToString((byte[])input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Base64.encodeToString(input, Base64.NO_WRAP)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Decode(@Nullable String input) {
        byte[] byArray = Base64.decode((String)input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64Decode(@Nullable byte[] input) {
        byte[] byArray = Base64.decode((byte[])input, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Base64.decode(input, Base64.NO_WRAP)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] base64UrlSafeEncode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = Base64.encode((byte[])byArray, (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Base64.encode(input.toBy\u2026Array(), Base64.URL_SAFE)");
        return byArray2;
    }

    @JvmStatic
    @NotNull
    public static final String htmlEncode(@NotNull String input) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (Build.VERSION.SDK_INT >= 16) {
            String string2 = Html.escapeHtml((CharSequence)input);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Html.escapeHtml(input)");
        } else {
            StringBuilder out = new StringBuilder();
            int len = input.length();
            for (int i = 0; i < len; ++i) {
                char c = input.charAt(i);
                if (c == '<') {
                    out.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    out.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    out.append("&amp;");
                    continue;
                }
                char c2 = c;
                if ('\ud800' <= c2 && '\udfff' >= c2) {
                    char d;
                    char c3;
                    if (c >= '\udc00' || i + 1 >= len || '\udc00' > (c3 = (d = input.charAt(i + 1))) || '\udfff' < c3) continue;
                    ++i;
                    int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                    out.append("&#").append(codepoint).append(";");
                    continue;
                }
                if (c > '~' || Intrinsics.compare((int)c, (int)32) < 0) {
                    out.append("&#").append((int)c).append(";");
                    continue;
                }
                if (c == ' ') {
                    while (i + 1 < len && input.charAt(i + 1) == ' ') {
                        out.append("&nbsp;");
                        ++i;
                    }
                    out.append(' ');
                    continue;
                }
                out.append(c);
            }
            String string3 = out.toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"out.toString()");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String htmlDecode(@Nullable String input) {
        return Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)input, (int)0).toString() : Html.fromHtml((String)input).toString();
    }

    private EncodeUtil() {
    }

    static {
        EncodeUtil encodeUtil;
        INSTANCE = encodeUtil = new EncodeUtil();
    }
}

