/*
 * Decompiled with CFR 0.152.
 */
package com.core.util;

import com.core.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/core/util/DataUtil;", "", "()V", "HEX_DIGITS", "", "byte2FitSize", "", "byteNum", "", "bytes2HexString", "bytes", "", "hex2Dec", "", "hexChar", "", "hexString2Bytes", "hexString", "input2OutputStream", "Ljava/io/ByteArrayOutputStream;", "is", "Ljava/io/InputStream;", "inputStream2Bytes", "stringToInt", "str", "XUtils_release"})
public final class DataUtil {
    private static final char[] HEX_DIGITS;
    @NotNull
    public static final DataUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final String bytes2HexString(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        char[] ret = new char[bytes.length << 1];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >>> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        boolean bl = false;
        return new String(ret);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hexString2Bytes(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        int len = hexString.length();
        boolean bl = len % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "\u957f\u5ea6\u4e0d\u662f\u5076\u6570";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = hexString;
        bl3 = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        string = string2;
        bl3 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] hexBytes = cArray;
        byte[] ret = new byte[len >>> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(INSTANCE.hex2Dec(hexBytes[i]) << 4 | INSTANCE.hex2Dec(hexBytes[i + 1]));
        }
        return ret;
    }

    private final int hex2Dec(char hexChar) {
        int n;
        char c = hexChar;
        char c2 = c;
        if ('0' <= c2 && '9' >= c2) {
            n = hexChar - 48;
        } else {
            c2 = c;
            if ('A' <= c2 && 'F' >= c2) {
                n = hexChar - 65 + 10;
            } else {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final String byte2FitSize(long byteNum) {
        String string;
        if (byteNum < 0L) {
            string = "shouldn't be less than zero!";
        } else if (byteNum < (long)1024) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            String string2 = "%.3fB";
            Object[] objectArray = new Object[]{(double)byteNum};
            boolean bl = false;
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        } else if (byteNum < (long)0x100000) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            String string4 = "%.3fKB";
            Object[] objectArray = new Object[]{(double)byteNum / (double)1024};
            boolean bl = false;
            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(locale, format, *args)");
        } else if (byteNum < (long)0x40000000) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            String string6 = "%.3fMB";
            Object[] objectArray = new Object[]{(double)byteNum / (double)0x100000};
            boolean bl = false;
            String string7 = String.format(locale, string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(locale, format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.getDefault();
            String string8 = "%.3fGB";
            Object[] objectArray = new Object[]{(double)byteNum / (double)0x40000000};
            boolean bl = false;
            String string9 = String.format(locale, string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"java.lang.String.format(locale, format, *args)");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final byte[] inputStream2Bytes(@Nullable InputStream is) {
        ByteArrayOutputStream byteArrayOutputStream = DataUtil.input2OutputStream(is);
        Intrinsics.checkNotNull((Object)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input2OutputStream(`is`)!!.toByteArray()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final ByteArrayOutputStream input2OutputStream(@Nullable InputStream is) {
        Object v0;
        block6: {
            Object var1_1;
            block5: {
                if (is != null) break block5;
                v0 = null;
                break block6;
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while (true) {
                    int n = is.read(b, 0, 1024);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    len = it;
                    if (n == -1) break;
                    os.write(b, 0, len);
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    var1_1 = null;
                }
                catch (Throwable throwable) {
                    FileUtil.closeIO(is);
                    throw throwable;
                }
                FileUtil.closeIO(is);
            }
            FileUtil.closeIO(is);
            v0 = var1_1;
        }
        return v0;
    }

    @JvmStatic
    public static final int stringToInt(@NotNull String str) {
        int n;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            n = 0;
        } else {
            int n2;
            try {
                charSequence = str;
                bl = false;
                n2 = Integer.parseInt((String)charSequence);
            }
            catch (NumberFormatException e) {
                n2 = 0;
            }
            n = n2;
        }
        return n;
    }

    private DataUtil() {
    }

    static {
        DataUtil dataUtil;
        INSTANCE = dataUtil = new DataUtil();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

