/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.util;

import android.os.Process;
import android.util.Log;
import com.chillingvan.canvasgl.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class FileLogger {
    private static final SimpleDateFormat LOG_DATE_TIME_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");
    private static ExecutorService sLogExecutor = Executors.newSingleThreadExecutor();
    private static boolean sLogEnable = false;
    private static LogLevel sLogLevel = LogLevel.VERBOSE;
    private static LogFileManager sLogFileManager;
    private static Map<String, Integer> limitLogMap;

    public static void setEnable(boolean enable) {
        sLogEnable = enable;
    }

    public static boolean isLogEnable() {
        return sLogEnable;
    }

    public static void setLogLevel(LogLevel level) {
        sLogLevel = level;
    }

    public static void init(String dirPath) {
        sLogEnable = true;
        File file = new File(dirPath);
        if (!file.exists() || !file.isDirectory()) {
            throw new InvalidParameterException();
        }
        sLogFileManager = new LogFileManager(dirPath);
    }

    public static void limitLog(String id, String tag, String message, int cntTimesAfterLogOnce) {
        if (!limitLogMap.containsKey(id)) {
            limitLogMap.put(id, 0);
        } else {
            Integer currentCnt = limitLogMap.get(id);
            if (currentCnt < cntTimesAfterLogOnce) {
                limitLogMap.put(id, currentCnt + 1);
                return;
            }
            limitLogMap.put(id, 0);
        }
        FileLogger.d(tag, message);
    }

    public static void d(String tag, String message) {
        if (sLogEnable) {
            String msg = message;
            Log.d((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.DEBUG);
        }
    }

    public static void d(String tag, String message, Throwable throwable) {
        if (sLogEnable) {
            String msg = message;
            Log.d((String)tag, (String)msg, (Throwable)throwable);
            FileLogger.writeToFileIfNeeded(tag, msg + "\n" + Log.getStackTraceString((Throwable)throwable), LogLevel.DEBUG);
        }
    }

    public static void d(String tag, String format, Object ... params) {
        if (sLogEnable) {
            String msg = String.format(format, params);
            Log.d((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.DEBUG);
        }
    }

    public static void w(String tag, String message) {
        if (sLogEnable) {
            String msg = message;
            Log.w((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.WARN);
        }
    }

    public static void w(String tag, Throwable throwable) {
        if (sLogEnable) {
            Log.w((String)tag, (Throwable)throwable);
            FileLogger.writeToFileIfNeeded(tag, Log.getStackTraceString((Throwable)throwable), LogLevel.WARN);
        }
    }

    public static void w(String tag, String message, Throwable throwable) {
        if (sLogEnable) {
            String msg = message;
            Log.w((String)tag, (String)msg, (Throwable)throwable);
            FileLogger.writeToFileIfNeeded(tag, msg + "\n" + Log.getStackTraceString((Throwable)throwable), LogLevel.WARN);
        }
    }

    public static void w(String tag, String format, Object ... params) {
        if (sLogEnable) {
            String msg = String.format(format, params);
            Log.w((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.WARN);
        }
    }

    public static void e(String tag, String message) {
        if (sLogEnable) {
            String msg = message;
            Log.e((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.ERROR);
        }
    }

    public static void e(String tag, String message, Throwable throwable) {
        if (sLogEnable) {
            String msg = message;
            Log.e((String)tag, (String)msg, (Throwable)throwable);
            FileLogger.writeToFileIfNeeded(tag, msg + "\n" + Log.getStackTraceString((Throwable)throwable), LogLevel.ERROR);
        }
    }

    public static void e(String tag, String format, Object ... params) {
        if (sLogEnable) {
            String msg = String.format(format, params);
            Log.e((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.ERROR);
        }
    }

    public static void i(String tag, String message) {
        if (sLogEnable) {
            String msg = message;
            Log.i((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.INFO);
        }
    }

    public static void i(String tag, String message, Throwable throwable) {
        if (sLogEnable) {
            String msg = message;
            Log.i((String)tag, (String)msg, (Throwable)throwable);
            FileLogger.writeToFileIfNeeded(tag, msg + "\n" + Log.getStackTraceString((Throwable)throwable), LogLevel.INFO);
        }
    }

    public static void i(String tag, String format, Object ... params) {
        if (sLogEnable) {
            String msg = String.format(format, params);
            Log.i((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.INFO);
        }
    }

    public static void v(String tag, String message) {
        if (sLogEnable) {
            String msg = message;
            Log.v((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.VERBOSE);
        }
    }

    public static void v(String tag, String message, Throwable throwable) {
        if (sLogEnable) {
            String msg = message;
            Log.v((String)tag, (String)msg, (Throwable)throwable);
            FileLogger.writeToFileIfNeeded(tag, msg + "\n" + Log.getStackTraceString((Throwable)throwable), LogLevel.VERBOSE);
        }
    }

    public static void v(String tag, String format, Object ... params) {
        if (sLogEnable) {
            String msg = String.format(format, params);
            Log.v((String)tag, (String)msg);
            FileLogger.writeToFileIfNeeded(tag, msg, LogLevel.VERBOSE);
        }
    }

    private static void writeToFileIfNeeded(final String tag, final String msg, LogLevel logLevel) {
        final StringBuilder strBuilder = new StringBuilder();
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int methodStackCnt = 2;
        strBuilder.append(" ").append(" tid=").append(Thread.currentThread().getId()).append(" ").append(stackTrace[methodStackCnt].getFileName()).append("[").append(stackTrace[methodStackCnt].getLineNumber()).append("] ").append("; ").append(stackTrace[methodStackCnt].getMethodName()).append(": ");
        if (logLevel.getValue() < sLogLevel.getValue() || sLogFileManager == null) {
            return;
        }
        sLogExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FileLogger.appendLog(strBuilder.toString() + tag, msg);
            }
        });
    }

    private static void appendLog(String tag, String msg) {
        String logMsg = FileLogger.formatLog(tag, msg);
        FileLogger.flushLogToFile(logMsg);
    }

    private static void flushLogToFile(String logMsg) {
        sLogFileManager.writeLogToFile(logMsg);
    }

    private static String formatLog(String tag, String msg) {
        return String.format(Locale.CHINA, "%s pid=%d %s; %s\n", LOG_DATE_TIME_FORMAT.format(new Date()), Process.myPid(), tag, msg);
    }

    static {
        limitLogMap = new HashMap<String, Integer>();
    }

    public static class LogFileManager {
        private static final int LOG_FILES_MAX_NUM = 5;
        private static final int LOG_FILE_MAX_SIZE = 20000000;
        private static final SimpleDateFormat LOG_FILE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        public static final String PREFIX = "Log";
        private File mCurrentLogFile;
        private String mLogFileDir;
        private FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String tmp = file.getName().toLowerCase();
                return tmp.startsWith("log") && tmp.endsWith(".txt");
            }
        };

        LogFileManager(String logFileDir) {
            this.mLogFileDir = logFileDir;
        }

        public void writeLogToFile(String logMessage) {
            if (this.mCurrentLogFile == null || this.mCurrentLogFile.length() >= 20000000L) {
                this.mCurrentLogFile = this.getNewLogFile();
            }
            FileUtil.writeToFile(logMessage, this.mCurrentLogFile.getPath());
        }

        private File getNewLogFile() {
            File dir = new File(this.mLogFileDir);
            File[] files = dir.listFiles(this.fileFilter);
            if (files == null || files.length == 0) {
                return this.createNewLogFileIfNeed();
            }
            List<File> sortedFiles = this.sortFiles(files);
            if (files.length > 5) {
                FileUtil.delete(sortedFiles.get(0));
            }
            return this.createNewLogFileIfNeed();
        }

        private File createNewLogFileIfNeed() {
            return FileUtil.createFile(this.mLogFileDir + File.separator + PREFIX + LOG_FILE_DATE_FORMAT.format(new Date()) + ".txt");
        }

        private List<File> sortFiles(File[] files) {
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList, new FileComparator());
            return fileList;
        }

        private class FileComparator
        implements Comparator<File> {
            private FileComparator() {
            }

            @Override
            public int compare(File file1, File file2) {
                if (file1.lastModified() < file2.lastModified()) {
                    return -1;
                }
                return 1;
            }
        }
    }

    public static enum LogLevel {
        VERBOSE(2),
        DEBUG(3),
        INFO(4),
        WARN(5),
        ERROR(6),
        ASSERT(7);

        private int mValue;

        private LogLevel(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

