/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import androidx.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public class GammaFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_GAMMA = "gamma";
    public static final String GAMMA_FRAGMENT_SHADER = "precision mediump float; \nvarying vec2 vTextureCoord;\n \n uniform sampler2D uTextureSampler;\n uniform lowp float gamma;\n uniform float uAlpha;\n \n void main() {\n      lowp vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n     \n     gl_FragColor = vec4(pow(textureColor.rgb, vec3(gamma)), textureColor.w);\n    gl_FragColor *= uAlpha;\n }";
    private float mGamma;
    private int mGammaLocation;

    public GammaFilter(@FloatRange(from=0.0, to=3.0) float mGamma) {
        this.mGamma = mGamma;
    }

    @Override
    public String getFragmentShader() {
        return GAMMA_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        this.mGammaLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_GAMMA);
        OpenGLUtil.setFloat(this.mGammaLocation, this.mGamma);
    }

    @Override
    public void setValue(@FloatRange(from=0.0, to=3.0) float gamma) {
        this.mGamma = gamma;
    }
}

