/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glcanvas.UploadedTexture;
import com.chillingvan.canvasgl.matrix.IBitmapMatrix;
import com.chillingvan.canvasgl.shapeFilter.BasicDrawShapeFilter;
import com.chillingvan.canvasgl.shapeFilter.DrawCircleFilter;
import com.chillingvan.canvasgl.shapeFilter.DrawShapeFilter;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.FilterGroup;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.util.Map;
import java.util.WeakHashMap;

public class CanvasGL
implements ICanvasGL {
    private Map<Bitmap, BasicTexture> bitmapTextureMap = new WeakHashMap<Bitmap, BasicTexture>();
    protected final GLCanvas glCanvas;
    protected final BasicTextureFilter defaultTextureFilter;
    private float[] canvasBackgroundColor;
    private float[] surfaceTextureMatrix = new float[16];
    private int width;
    private int height;
    private BasicDrawShapeFilter defaultDrawShapeFilter;
    private DrawCircleFilter drawCircleFilter = new DrawCircleFilter();
    private TextureFilter currentTextureFilter;

    public CanvasGL() {
        this(new GLES20Canvas());
    }

    public CanvasGL(GLCanvas glCanvas) {
        this.glCanvas = glCanvas;
        glCanvas.setOnPreDrawShapeListener(new GLCanvas.OnPreDrawShapeListener(){

            @Override
            public void onPreDraw(int program, DrawShapeFilter drawShapeFilter) {
                drawShapeFilter.onPreDraw(program, CanvasGL.this);
            }
        });
        glCanvas.setOnPreDrawTextureListener(new GLCanvas.OnPreDrawTextureListener(){

            @Override
            public void onPreDraw(int textureProgram, BasicTexture texture, TextureFilter textureFilter) {
                textureFilter.onPreDraw(textureProgram, texture, CanvasGL.this);
            }
        });
        this.defaultTextureFilter = new BasicTextureFilter();
        this.defaultDrawShapeFilter = new BasicDrawShapeFilter();
        this.canvasBackgroundColor = new float[4];
    }

    @Override
    public BitmapTexture bindBitmapToTexture(int whichTexture, Bitmap bitmap) {
        GLES20.glActiveTexture((int)whichTexture);
        GLES20Canvas.checkError();
        BitmapTexture texture = (BitmapTexture)this.getTexture(bitmap, null);
        texture.onBind(this.glCanvas);
        GLES20.glBindTexture((int)texture.getTarget(), (int)texture.getId());
        GLES20Canvas.checkError();
        return texture;
    }

    @Override
    public void bindRawTexture(int whichTexture, RawTexture texture) {
        GLES20.glActiveTexture((int)whichTexture);
        GLES20Canvas.checkError();
        if (!texture.isLoaded()) {
            texture.prepare(this.glCanvas);
        }
        GLES20.glBindTexture((int)texture.getTarget(), (int)texture.getId());
        GLES20Canvas.checkError();
    }

    @Override
    public void beginRenderTarget(RawTexture texture) {
        this.glCanvas.beginRenderTarget(texture);
    }

    @Override
    public void endRenderTarget() {
        this.glCanvas.endRenderTarget();
    }

    @Override
    public GLCanvas getGlCanvas() {
        return this.glCanvas;
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom) {
        this.drawSurfaceTexture(texture, surfaceTexture, left, top, right, bottom, this.defaultTextureFilter);
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom, TextureFilter basicTextureFilter) {
        this.drawSurfaceTexture(texture, surfaceTexture, left, top, right, bottom, null, basicTextureFilter);
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, @Nullable SurfaceTexture surfaceTexture, @NonNull IBitmapMatrix matrix) {
        this.drawSurfaceTexture(texture, surfaceTexture, matrix, this.defaultTextureFilter);
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, @Nullable SurfaceTexture surfaceTexture, @Nullable IBitmapMatrix matrix, @NonNull TextureFilter textureFilter) {
        this.drawSurfaceTexture(texture, surfaceTexture, 0, 0, texture.getWidth(), texture.getHeight(), matrix, textureFilter);
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom, final @Nullable IBitmapMatrix matrix, TextureFilter textureFilter) {
        GLCanvas.ICustomMVPMatrix customMVPMatrix;
        this.currentTextureFilter = textureFilter;
        BasicTexture filteredTexture = texture;
        if (textureFilter instanceof FilterGroup) {
            filteredTexture = this.getFilterGroupTexture(texture, surfaceTexture, (FilterGroup)textureFilter);
        }
        GLCanvas.ICustomMVPMatrix iCustomMVPMatrix = customMVPMatrix = matrix == null ? null : new GLCanvas.ICustomMVPMatrix(){

            @Override
            public float[] getMVPMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
                return matrix.obtainResultMatrix(viewportW, viewportH, x, y, drawW, drawH);
            }
        };
        if (surfaceTexture == null) {
            this.glCanvas.drawTexture(filteredTexture, left, top, right - left, bottom - top, textureFilter, customMVPMatrix);
        } else {
            surfaceTexture.getTransformMatrix(this.surfaceTextureMatrix);
            this.glCanvas.drawTexture(filteredTexture, this.surfaceTextureMatrix, left, top, right - left, bottom - top, textureFilter, customMVPMatrix);
        }
    }

    private BasicTexture getFilterGroupTexture(BasicTexture texture, final SurfaceTexture surfaceTexture, FilterGroup basicTextureFilter) {
        FilterGroup filterGroup = basicTextureFilter;
        texture = filterGroup.draw(texture, this.glCanvas, new FilterGroup.OnDrawListener(){

            @Override
            public void onDraw(BasicTexture drawTexture, TextureFilter textureFilter, boolean isFirst) {
                if (isFirst) {
                    surfaceTexture.getTransformMatrix(CanvasGL.this.surfaceTextureMatrix);
                    CanvasGL.this.glCanvas.drawTexture(drawTexture, CanvasGL.this.surfaceTextureMatrix, 0, 0, drawTexture.getWidth(), drawTexture.getHeight(), textureFilter, null);
                } else {
                    CanvasGL.this.glCanvas.drawTexture(drawTexture, 0, 0, drawTexture.getWidth(), drawTexture.getHeight(), textureFilter, null);
                }
            }
        });
        return texture;
    }

    @Override
    public void drawBitmap(Bitmap bitmap, @NonNull IBitmapMatrix matrix) {
        this.drawBitmap(bitmap, matrix, this.defaultTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, final IBitmapMatrix matrix, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.save();
        this.glCanvas.drawTexture(basicTexture, 0, 0, bitmap.getWidth(), bitmap.getHeight(), textureFilter, new GLCanvas.ICustomMVPMatrix(){

            @Override
            public float[] getMVPMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
                return matrix.obtainResultMatrix(viewportW, viewportH, x, y, drawW, drawH);
            }
        });
        this.restore();
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst) {
        this.drawBitmap(bitmap, new RectF(src), dst, (TextureFilter)this.defaultTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top) {
        this.drawBitmap(bitmap, left, top, (TextureFilter)this.defaultTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, left, top, bitmap.getWidth(), bitmap.getHeight(), textureFilter, null);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst) {
        this.drawBitmap(bitmap, src, new RectF(dst));
    }

    @Override
    public void drawBitmap(Bitmap bitmap, RectF src, RectF dst, TextureFilter textureFilter) {
        if (dst == null) {
            throw new NullPointerException();
        }
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, src, dst, textureFilter, null);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, int width, int height) {
        this.drawBitmap(bitmap, left, top, width, height, this.defaultTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, int width, int height, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, left, top, width, height, textureFilter, null);
    }

    protected BasicTexture getTexture(Bitmap bitmap, @Nullable TextureFilter textureFilter) {
        this.currentTextureFilter = textureFilter;
        this.throwIfCannotDraw(bitmap);
        BasicTexture resultTexture = this.getTextureFromMap(bitmap);
        if (textureFilter instanceof FilterGroup) {
            FilterGroup filterGroup = (FilterGroup)textureFilter;
            resultTexture = filterGroup.draw(resultTexture, this.glCanvas, new FilterGroup.OnDrawListener(){

                @Override
                public void onDraw(BasicTexture drawTexture, TextureFilter textureFilter, boolean isFirst) {
                    CanvasGL.this.glCanvas.drawTexture(drawTexture, 0, 0, drawTexture.getWidth(), drawTexture.getHeight(), textureFilter, null);
                }
            });
        }
        return resultTexture;
    }

    @Override
    public void invalidateTextureContent(Bitmap bitmap) {
        BasicTexture resultTexture = this.getTextureFromMap(bitmap);
        if (resultTexture instanceof UploadedTexture) {
            ((UploadedTexture)resultTexture).invalidateContent();
        }
    }

    private BasicTexture getTextureFromMap(Bitmap bitmap) {
        BasicTexture resultTexture;
        if (this.bitmapTextureMap.containsKey(bitmap)) {
            resultTexture = this.bitmapTextureMap.get(bitmap);
        } else {
            resultTexture = new BitmapTexture(bitmap);
            this.bitmapTextureMap.put(bitmap, resultTexture);
        }
        return resultTexture;
    }

    @Override
    public void drawCircle(float x, float y, float radius, GLPaint paint) {
        if (paint.getStyle() == Paint.Style.FILL) {
            this.drawCircleFilter.setLineWidth(0.5f);
        } else {
            this.drawCircleFilter.setLineWidth(paint.getLineWidth() / (2.0f * radius));
        }
        this.glCanvas.drawCircle(x - radius, y - radius, radius, paint, this.drawCircleFilter);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, GLPaint paint) {
        this.glCanvas.drawLine(startX, startY, stopX, stopY, paint, this.defaultDrawShapeFilter);
    }

    @Override
    public void drawRect(@NonNull RectF rect, GLPaint paint) {
        this.drawRect(rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    @Override
    public void drawRect(@NonNull Rect r, GLPaint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, GLPaint paint) {
        if (paint.getStyle() == Paint.Style.STROKE) {
            this.glCanvas.drawRect(left, top, right - left, bottom - top, paint, this.defaultDrawShapeFilter);
        } else {
            this.glCanvas.fillRect(left, top, right - left, bottom - top, paint.getColor(), this.defaultDrawShapeFilter);
        }
    }

    @Override
    public void save() {
        this.glCanvas.save();
    }

    @Override
    public void save(int saveFlags) {
        this.glCanvas.save(saveFlags);
    }

    @Override
    public void restore() {
        this.glCanvas.restore();
    }

    @Override
    public void rotate(float degrees) {
        this.glCanvas.rotate(degrees, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float degrees, float px, float py) {
        this.glCanvas.translate(px, py);
        this.rotate(degrees);
        this.glCanvas.translate(-px, -py);
    }

    @Override
    public void scale(float sx, float sy) {
        this.glCanvas.scale(sx, sy, 1.0f);
    }

    @Override
    public void scale(float sx, float sy, float px, float py) {
        this.glCanvas.translate(px, py);
        this.scale(sx, sy);
        this.glCanvas.translate(-px, -py);
    }

    @Override
    public void translate(float dx, float dy) {
        this.glCanvas.translate(dx, dy);
    }

    @Override
    public void clearBuffer() {
        this.glCanvas.clearBuffer();
    }

    @Override
    public void clearBuffer(int color) {
        this.canvasBackgroundColor[1] = (float)Color.red((int)color) / 255.0f;
        this.canvasBackgroundColor[2] = (float)Color.green((int)color) / 255.0f;
        this.canvasBackgroundColor[3] = (float)Color.blue((int)color) / 255.0f;
        this.canvasBackgroundColor[0] = (float)Color.alpha((int)color) / 255.0f;
        this.glCanvas.clearBuffer(this.canvasBackgroundColor);
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.glCanvas.setSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void resume() {
    }

    @Override
    public void pause() {
        if (this.currentTextureFilter != null) {
            this.currentTextureFilter.destroy();
        }
    }

    @Override
    public void clearBitmapCache() {
        for (BasicTexture bitmapTexture : this.bitmapTextureMap.values()) {
            bitmapTexture.recycle();
        }
        this.bitmapTextureMap.clear();
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.glCanvas.setAlpha((float)alpha / 255.0f);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clearBitmapCache();
    }

    protected void throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (Build.VERSION.SDK_INT >= 17 && !bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
    }
}

