/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;

public class CropFilter
extends BasicTextureFilter {
    private static final String UNIFORM_LEFT = "left";
    private static final String UNIFORM_TOP = "top";
    private static final String UNIFORM_RIGHT = "right";
    private static final String UNIFORM_BOTTOM = "bottom";
    private static final String CROP_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform sampler2D uTextureSampler;\n  uniform highp float left;\n  uniform highp float top;\n  uniform highp float right;\n  uniform highp float bottom;\nvoid main() {\nif( vTextureCoord.x > left &&  vTextureCoord.x < right &&  vTextureCoord.y > top &&  vTextureCoord.y < bottom) { gl_FragColor = texture2D(uTextureSampler, vTextureCoord);\n} else { gl_FragColor = vec4(0, 0, 0, 0);\n}}\n";
    private float left;
    private float right;
    private float top;
    private float bottom;

    public CropFilter(float left, float top, float right, float bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    @Override
    public String getFragmentShader() {
        return CROP_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_LEFT), this.left);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_TOP), this.top);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_RIGHT), this.right);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_BOTTOM), this.bottom);
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public void setRight(float right) {
        this.right = right;
    }

    public void setTop(float top) {
        this.top = top;
    }

    public void setBottom(float bottom) {
        this.bottom = bottom;
    }

    public static float calc(int wantCoord, int size) {
        return (float)wantCoord / (float)size;
    }
}

