/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.util.Log;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLId;

public class RawTexture
extends BasicTexture {
    private static final String TAG = "RawTexture";
    private final boolean mOpaque;
    private boolean mIsFlipped;
    private int target = 3553;
    protected boolean needInvalidate;

    public RawTexture(int width, int height, boolean opaque) {
        this(width, height, opaque, 3553);
    }

    public RawTexture(int width, int height, boolean opaque, int target) {
        this.mOpaque = opaque;
        this.setSize(width, height);
        this.target = target;
    }

    @Override
    public boolean isOpaque() {
        return this.mOpaque;
    }

    @Override
    public boolean isFlippedVertically() {
        return this.mIsFlipped;
    }

    public void setIsFlippedVertically(boolean isFlipped) {
        this.mIsFlipped = isFlipped;
    }

    public void prepare(GLCanvas canvas) {
        GLId glId = canvas.getGLId();
        this.mId = glId.generateTexture();
        if (this.target == 3553) {
            canvas.initializeTextureSize(this, 6408, 5121);
        }
        canvas.setTextureParameters(this);
        this.mState = 1;
        this.setAssociatedCanvas(canvas);
    }

    @Override
    protected boolean onBind(GLCanvas canvas) {
        if (this.isLoaded()) {
            return true;
        }
        Log.w((String)TAG, (String)"lost the content due to context change");
        return false;
    }

    @Override
    public void yield() {
    }

    @Override
    protected int getTarget() {
        return this.target;
    }

    public void setNeedInvalidate(boolean needInvalidate) {
        this.needInvalidate = needInvalidate;
    }

    public boolean isNeedInvalidate() {
        return this.needInvalidate;
    }
}

