/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.util.Log;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLCanvasUtils;
import com.chillingvan.canvasgl.glcanvas.Texture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import java.util.WeakHashMap;

public abstract class BasicTexture
implements Texture {
    private static final String TAG = "BasicTexture";
    protected static final int UNSPECIFIED = -1;
    protected static final int STATE_UNLOADED = 0;
    protected static final int STATE_LOADED = 1;
    protected static final int STATE_ERROR = -1;
    private static final int MAX_TEXTURE_SIZE = 4096;
    protected int mId = -1;
    protected int mState;
    protected int mWidth = -1;
    protected int mHeight = -1;
    protected int mTextureWidth;
    protected int mTextureHeight;
    private boolean mHasBorder;
    private boolean isRecycled;
    protected GLCanvas mCanvasRef = null;
    private static WeakHashMap<BasicTexture, Object> sAllTextures = new WeakHashMap();
    private static ThreadLocal sInFinalizer = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicTexture(GLCanvas canvas, int id, int state) {
        this.setAssociatedCanvas(canvas);
        this.mId = id;
        this.mState = state;
        WeakHashMap<BasicTexture, Object> weakHashMap = sAllTextures;
        synchronized (weakHashMap) {
            sAllTextures.put(this, null);
        }
    }

    protected BasicTexture() {
        this(null, 0, 0);
    }

    protected void setAssociatedCanvas(GLCanvas canvas) {
        this.mCanvasRef = canvas;
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTextureWidth = width > 0 ? GLCanvasUtils.nextPowerOf2(width) : 0;
        int n = this.mTextureHeight = height > 0 ? GLCanvasUtils.nextPowerOf2(height) : 0;
        if (this.mTextureWidth > 4096 || this.mTextureHeight > 4096) {
            Log.w((String)TAG, (String)String.format("secondBitmap is too large: %d x %d", this.mTextureWidth, this.mTextureHeight), (Throwable)new Exception());
        }
    }

    public boolean isFlippedVertically() {
        return false;
    }

    public int getId() {
        return this.mId;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public int getTextureWidth() {
        return this.mTextureWidth;
    }

    public int getTextureHeight() {
        return this.mTextureHeight;
    }

    public boolean hasBorder() {
        return this.mHasBorder;
    }

    protected void setBorder(boolean hasBorder) {
        this.mHasBorder = hasBorder;
    }

    @Override
    public void draw(GLCanvas canvas, int x, int y) {
        canvas.drawTexture(this, x, y, this.getWidth(), this.getHeight(), new BasicTextureFilter(), null);
    }

    @Override
    public void draw(GLCanvas canvas, int x, int y, int w, int h) {
        canvas.drawTexture(this, x, y, w, h, new BasicTextureFilter(), null);
    }

    protected abstract boolean onBind(GLCanvas var1);

    protected abstract int getTarget();

    public boolean isLoaded() {
        return this.mState == 1;
    }

    public void recycle() {
        this.isRecycled = true;
        this.freeResource();
    }

    public boolean isRecycled() {
        return this.isRecycled;
    }

    protected void setRecycled(boolean recycled) {
        this.isRecycled = recycled;
    }

    public void yield() {
        this.freeResource();
    }

    private void freeResource() {
        GLCanvas canvas = this.mCanvasRef;
        if (canvas != null && this.mId != -1) {
            canvas.unloadTexture(this);
            this.mId = -1;
        }
        this.mState = 0;
        this.setAssociatedCanvas(null);
    }

    protected void finalize() {
        sInFinalizer.set(BasicTexture.class);
        this.recycle();
        sInFinalizer.set(null);
    }

    public static boolean inFinalizer() {
        return sInFinalizer.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void yieldAllTextures() {
        WeakHashMap<BasicTexture, Object> weakHashMap = sAllTextures;
        synchronized (weakHashMap) {
            for (BasicTexture t : sAllTextures.keySet()) {
                t.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAllTextures() {
        WeakHashMap<BasicTexture, Object> weakHashMap = sAllTextures;
        synchronized (weakHashMap) {
            for (BasicTexture t : sAllTextures.keySet()) {
                t.mState = 0;
                t.setAssociatedCanvas(null);
            }
        }
    }
}

