/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.util.Arrays;

public interface ICanvasGL {
    public BitmapTexture bindBitmapToTexture(int var1, Bitmap var2);

    public void beginRenderTarget(RawTexture var1);

    public void endRenderTarget();

    public GLCanvas getGlCanvas();

    public void drawSurfaceTexture(BasicTexture var1, @Nullable SurfaceTexture var2, int var3, int var4, int var5, int var6);

    public void drawSurfaceTexture(BasicTexture var1, @Nullable SurfaceTexture var2, int var3, int var4, int var5, int var6, TextureFilter var7);

    public void drawBitmap(Bitmap var1, @NonNull BitmapMatrix var2);

    public void drawBitmap(Bitmap var1, BitmapMatrix var2, @NonNull TextureFilter var3);

    public void drawBitmap(Bitmap var1, Rect var2, RectF var3);

    public void drawBitmap(Bitmap var1, int var2, int var3);

    public void drawBitmap(Bitmap var1, int var2, int var3, @NonNull TextureFilter var4);

    public void drawBitmap(Bitmap var1, Rect var2, Rect var3);

    public void drawBitmap(Bitmap var1, RectF var2, RectF var3, @NonNull TextureFilter var4);

    public void drawBitmap(Bitmap var1, int var2, int var3, int var4, int var5);

    public void drawBitmap(Bitmap var1, int var2, int var3, int var4, int var5, @NonNull TextureFilter var6);

    public void invalidateTextureContent(Bitmap var1);

    public void drawCircle(float var1, float var2, float var3, GLPaint var4);

    public void drawLine(float var1, float var2, float var3, float var4, GLPaint var5);

    public void drawRect(@NonNull RectF var1, @NonNull GLPaint var2);

    public void drawRect(@NonNull Rect var1, @NonNull GLPaint var2);

    public void drawRect(float var1, float var2, float var3, float var4, GLPaint var5);

    public void save();

    public void save(int var1);

    public void restore();

    public void rotate(float var1);

    public void rotate(float var1, float var2, float var3);

    public void scale(float var1, float var2);

    public void scale(float var1, float var2, float var3, float var4);

    public void translate(float var1, float var2);

    public void clearBuffer();

    public void clearBuffer(int var1);

    public void setSize(int var1, int var2);

    public int getWidth();

    public int getHeight();

    public void setAlpha(@IntRange(from=0L, to=255L) int var1);

    public static class BitmapMatrix {
        public static final int TRANSLATE_X = 0;
        public static final int TRANSLATE_Y = 1;
        public static final int SCALE_X = 2;
        public static final int SCALE_Y = 3;
        public static final int ROTATE_X = 4;
        public static final int ROTATE_Y = 5;
        public static final int ROTATE_Z = 6;
        private float[] transform = new float[7];
        public static final int MATRIX_SIZE = 16;
        private float[] tempMultiplyMatrix4 = new float[16];
        private float[] mViewMatrix = new float[16];
        private float[] mProjectionMatrix = new float[16];
        private float[] mModelMatrix = new float[16];
        private float[] viewProjectionMatrix = new float[16];
        private float[] mvp = new float[16];
        static final float NEAR = 1.0f;
        static final float FAR = 10.0f;
        static final float EYEZ = 5.0f;
        static final float Z_RATIO = 5.5f;

        public BitmapMatrix() {
            this.reset();
        }

        public void reset() {
            Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
            Matrix.setIdentityM((float[])this.mProjectionMatrix, (int)0);
            Matrix.setIdentityM((float[])this.mModelMatrix, (int)0);
            Matrix.setIdentityM((float[])this.viewProjectionMatrix, (int)0);
            Matrix.setIdentityM((float[])this.mvp, (int)0);
            Matrix.setIdentityM((float[])this.tempMultiplyMatrix4, (int)0);
            Arrays.fill(this.transform, 0.0f);
            this.transform[2] = 1.0f;
            this.transform[3] = 1.0f;
        }

        public void translate(float dx, float dy) {
            this.transform[0] = this.transform[0] + dx;
            this.transform[1] = this.transform[1] + dy;
        }

        public void scale(float sx, float sy) {
            this.transform[2] = this.transform[2] * sx;
            this.transform[3] = this.transform[3] * sy;
        }

        public void rotateX(float degrees) {
            this.transform[4] = this.transform[4] + degrees;
        }

        public void rotateY(float degrees) {
            this.transform[5] = this.transform[5] + degrees;
        }

        public void rotateZ(float degrees) {
            this.transform[6] = this.transform[6] + degrees;
        }

        public float[] obtainResultMatrix(int viewportW, int viewportH, float x, float y, float drawW, float drawH) {
            float ratio = (float)viewportW / (float)viewportH;
            this.transform[0] = this.transform[0] + x;
            this.transform[1] = this.transform[1] + y;
            int viewportX = (int)(drawW / 2.0f - (float)viewportW + this.transform[0]);
            int viewportY = (int)(-drawH / 2.0f - this.transform[1]);
            GLES20.glViewport((int)viewportX, (int)viewportY, (int)(2 * viewportW), (int)(2 * viewportH));
            Matrix.frustumM((float[])this.mProjectionMatrix, (int)0, (float)(-ratio), (float)ratio, (float)-1.0f, (float)1.0f, (float)1.0f, (float)10.0f);
            Matrix.setLookAtM((float[])this.mViewMatrix, (int)0, (float)0.0f, (float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.multiplyMM((float[])this.viewProjectionMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mViewMatrix, (int)0);
            Matrix.scaleM((float[])this.mModelMatrix, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model -2:", this.mModelMatrix, 0);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[4], (float)1.0f, (float)0.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[5], (float)0.0f, (float)1.0f, (float)0.0f);
            Matrix.rotateM((float[])this.mModelMatrix, (int)0, (float)this.transform[6], (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20Canvas.printMatrix("model -1.5:", this.mModelMatrix, 0);
            float realW = drawW / (float)viewportW * 5.5f * 2.0f * ratio / 2.0f;
            float realH = drawH / (float)viewportH * 5.5f * 2.0f / 2.0f;
            Matrix.translateM((float[])this.tempMultiplyMatrix4, (int)0, (float[])this.mModelMatrix, (int)0, (float)(-realW / 2.0f), (float)(-realH / 2.0f), (float)-0.5f);
            GLES20Canvas.printMatrix("model -1:", this.tempMultiplyMatrix4, 0);
            Matrix.scaleM((float[])this.tempMultiplyMatrix4, (int)0, (float)(this.transform[2] * realW), (float)(this.transform[3] * realH), (float)1.0f);
            GLES20Canvas.printMatrix("model:", this.tempMultiplyMatrix4, 0);
            Matrix.multiplyMM((float[])this.mvp, (int)0, (float[])this.viewProjectionMatrix, (int)0, (float[])this.tempMultiplyMatrix4, (int)0);
            GLES20Canvas.printMatrix("ultra matrix:", this.mvp, 0);
            return this.mvp;
        }
    }
}

