/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture.gles;

import android.annotation.TargetApi;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Choreographer;
import com.chillingvan.canvasgl.glview.texture.GLViewRenderer;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.EglHelper;
import com.chillingvan.canvasgl.glview.texture.gles.EglHelperFactory;
import com.chillingvan.canvasgl.glview.texture.gles.IEglHelper;
import com.chillingvan.canvasgl.util.FileLogger;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public class GLThread
extends Thread {
    private static final String TAG = "GLThread";
    public static final boolean LOG_RENDERER_DRAW_FRAME = false;
    public static final boolean LOG_THREADS = false;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    private final GLThreadManager sGLThreadManager = new GLThreadManager();
    private int mRenderMode;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private GLViewRenderer mRenderer;
    private Object mSurface;
    private OnCreateGLContextListener onCreateGLContextListener;
    private boolean mPreserveEGLContextOnPause = true;
    private boolean mShouldExit;
    private boolean mExited;
    private boolean mRequestPaused;
    private boolean mPaused;
    private boolean mHasSurface;
    private boolean mSurfaceIsBad;
    private boolean mWaitingForSurface;
    private boolean mHaveEglContext;
    private boolean mHaveEglSurface;
    private boolean mFinishedCreatingEglSurface;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean mRequestRender = true;
    private boolean mWantRenderNotification;
    private boolean mRenderComplete;
    private ArrayList<Runnable> mEventQueue = new ArrayList();
    private boolean mSizeChanged = true;
    private boolean changeSurface = false;
    private EglContextWrapper mEglContext = EglContextWrapper.EGL_NO_CONTEXT_WRAPPER;
    private ChoreographerRenderWrapper mChoreographerRenderWrapper = new ChoreographerRenderWrapper(this);
    private long frameTimeNanos;
    private IEglHelper mEglHelper;

    GLThread(EGLConfigChooser configChooser, EGLContextFactory eglContextFactory, EGLWindowSurfaceFactory eglWindowSurfaceFactory, GLViewRenderer renderer, int renderMode, Object surface, EglContextWrapper sharedEglContext) {
        this.mRenderMode = renderMode;
        this.mWantRenderNotification = false;
        this.mEGLConfigChooser = configChooser;
        this.mEGLContextFactory = eglContextFactory;
        this.mEGLWindowSurfaceFactory = eglWindowSurfaceFactory;
        this.mSurface = surface;
        this.mRenderer = renderer;
        this.mEglContext = sharedEglContext;
    }

    public void setSurface(@NonNull Object surface) {
        if (this.mSurface != surface) {
            this.changeSurface = true;
        }
        this.mSurface = surface;
    }

    @Override
    public void run() {
        this.setName("GLThread " + this.getId());
        FileLogger.i(TAG, "starting tid=" + this.getId());
        try {
            this.guardedRun();
        }
        catch (InterruptedException e) {
            FileLogger.e(TAG, "", e);
        }
        finally {
            this.sGLThreadManager.threadExiting(this);
        }
    }

    public void setPreserveEGLContextOnPause(boolean mPreserveEGLContextOnPause) {
        this.mPreserveEGLContextOnPause = mPreserveEGLContextOnPause;
    }

    private void stopEglSurfaceLocked() {
        if (this.mHaveEglSurface) {
            this.mHaveEglSurface = false;
            this.mEglHelper.destroySurface();
        }
    }

    private void stopEglContextLocked() {
        if (this.mHaveEglContext) {
            this.mEglHelper.finish();
            this.mHaveEglContext = false;
            this.sGLThreadManager.releaseEglContextLocked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void guardedRun() throws InterruptedException {
        block52: {
            this.mEglHelper = EglHelperFactory.create(this.mEGLConfigChooser, this.mEGLContextFactory, this.mEGLWindowSurfaceFactory);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            this.mWantRenderNotification = false;
            try {
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                while (true) {
                    var12_12 = this.sGLThreadManager;
                    synchronized (var12_12) {
                        while (true) {
                            if (this.mShouldExit) {
                                // MONITOREXIT @DISABLED, blocks:[0, 51, 22, 23, 11] lbl22 : MonitorExitStatement: MONITOREXIT : var12_12
                                var13_14 = this.sGLThreadManager;
                                break block52;
                            }
                            if (!this.mEventQueue.isEmpty() && this.mHaveEglContext) {
                                event = this.mEventQueue.remove(0);
                                break;
                            }
                            pausing = false;
                            if (this.mPaused != this.mRequestPaused) {
                                pausing = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                this.sGLThreadManager.notifyAll();
                                FileLogger.i("GLThread", "mPaused is now " + this.mPaused + " tid=" + this.getId());
                            }
                            if (lostEglContext) {
                                FileLogger.i("GLThread", "lostEglContext");
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                lostEglContext = false;
                            }
                            if (pausing && this.mHaveEglSurface) {
                                FileLogger.i("GLThread", "releasing EGL surface because paused tid=" + this.getId());
                                this.stopEglSurfaceLocked();
                            }
                            if (pausing && this.mHaveEglContext && !(preserveEglContextOnPause = this.mPreserveEGLContextOnPause)) {
                                this.stopEglContextLocked();
                                FileLogger.i("GLThread", "releasing EGL context because paused tid=" + this.getId());
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                FileLogger.i("GLThread", "noticed surfaceView surface lost tid=" + this.getId());
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                FileLogger.i("GLThread", "noticed surfaceView surface acquired tid=" + this.getId());
                                this.mWaitingForSurface = false;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (doRenderNotification) {
                                this.mWantRenderNotification = false;
                                doRenderNotification = false;
                                this.mRenderComplete = true;
                                this.sGLThreadManager.notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (askedToReleaseEglContext) {
                                        askedToReleaseEglContext = false;
                                    } else if (this.sGLThreadManager.tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.mEglContext = this.mEglHelper.start(this.mEglContext);
                                            if (this.onCreateGLContextListener != null) {
                                                this.onCreateGLContextListener.onCreate(this.mEglContext);
                                            }
                                        }
                                        catch (RuntimeException t) {
                                            this.sGLThreadManager.releaseEglContextLocked(this);
                                            throw t;
                                        }
                                        this.mHaveEglContext = true;
                                        createEglContext = true;
                                        this.sGLThreadManager.notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    createEglSurface = true;
                                    createGlInterface = true;
                                    sizeChanged = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        sizeChanged = true;
                                        w = this.mWidth;
                                        h = this.mHeight;
                                        this.mWantRenderNotification = true;
                                        FileLogger.i("GLThread", "noticing that we want render notification tid=" + this.getId());
                                        createEglSurface = true;
                                        this.mSizeChanged = false;
                                    }
                                    if (this.changeSurface) {
                                        createEglSurface = true;
                                        this.changeSurface = false;
                                    }
                                    this.mRequestRender = false;
                                    this.sGLThreadManager.notifyAll();
                                    if (!this.mWantRenderNotification) break;
                                    wantRenderNotification = true;
                                    break;
                                }
                            }
                            this.sGLThreadManager.wait();
                        }
                        ** if (event == null) goto lbl106
                    }
lbl-1000:
                    // 1 sources

                    {
                        event.run();
                        event = null;
                        continue;
                    }
lbl106:
                    // 1 sources

                    if (createEglSurface) {
                        FileLogger.w("GLThread", "egl createSurface");
                        if (this.mEglHelper.createSurface(this.mSurface)) {
                            var12_12 = this.sGLThreadManager;
                            synchronized (var12_12) {
                                this.mFinishedCreatingEglSurface = true;
                                this.sGLThreadManager.notifyAll();
                            }
                            createEglSurface = false;
                        } else {
                            var12_12 = this.sGLThreadManager;
                            synchronized (var12_12) {
                                this.mFinishedCreatingEglSurface = true;
                                this.mSurfaceIsBad = true;
                                this.sGLThreadManager.notifyAll();
                                continue;
                            }
                        }
                    }
                    if (createGlInterface) {
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        FileLogger.w("GLThread", "onSurfaceCreated");
                        this.mRenderer.onSurfaceCreated();
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        FileLogger.w("GLThread", "onSurfaceChanged(" + w + ", " + h + ")");
                        this.mRenderer.onSurfaceChanged(w, h);
                        sizeChanged = false;
                    }
                    if (this.mChoreographerRenderWrapper.canSwap()) {
                        this.mRenderer.onDrawFrame();
                        this.mEglHelper.setPresentationTime(this.frameTimeNanos);
                        swapError = this.mEglHelper.swap();
                        this.mChoreographerRenderWrapper.disableSwap();
                        switch (swapError) {
                            case 12288: {
                                break;
                            }
                            case 12302: {
                                FileLogger.i("GLThread", "egl context lost tid=" + this.getId());
                                lostEglContext = true;
                                break;
                            }
                            default: {
                                EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", swapError);
                                var13_16 = this.sGLThreadManager;
                                synchronized (var13_16) {
                                    this.mSurfaceIsBad = true;
                                    this.sGLThreadManager.notifyAll();
                                    break;
                                }
                            }
                        }
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                    wantRenderNotification = false;
                }
            }
            catch (Throwable var19_19) {
                var20_20 = this.sGLThreadManager;
                synchronized (var20_20) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                    throw var19_19;
                }
            }
        }
        synchronized (var13_14) {
            this.stopEglSurfaceLocked();
            this.stopEglContextLocked();
            return;
        }
    }

    @Override
    public synchronized void start() {
        super.start();
        this.mChoreographerRenderWrapper.start();
    }

    public boolean ableToDraw() {
        return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
    }

    private boolean readyToDraw() {
        return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && this.mRequestRender;
    }

    public EglContextWrapper getEglContext() {
        return this.mEglContext;
    }

    public void setOnCreateGLContextListener(OnCreateGLContextListener onCreateGLContextListener) {
        this.onCreateGLContextListener = onCreateGLContextListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderMode(int renderMode) {
        if (0 > renderMode || renderMode > 1) {
            throw new IllegalArgumentException("renderMode");
        }
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mRenderMode = renderMode;
            this.sGLThreadManager.notifyAll();
        }
    }

    public int getRenderMode() {
        return this.mRenderMode;
    }

    public void requestRender() {
        this.requestRender(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRender(long frameTimeNanos) {
        this.frameTimeNanos = frameTimeNanos;
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mRequestRender = true;
            this.sGLThreadManager.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRenderAndWait() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            if (Thread.currentThread() == this) {
                return;
            }
            this.mWantRenderNotification = true;
            this.mRequestRender = true;
            this.mRenderComplete = false;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            FileLogger.i(TAG, "surfaceCreated tid=" + this.getId());
            this.mHasSurface = true;
            this.mFinishedCreatingEglSurface = false;
            this.sGLThreadManager.notifyAll();
            while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !this.mExited) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            FileLogger.i(TAG, "surfaceDestroyed tid=" + this.getId());
            this.mHasSurface = false;
            this.sGLThreadManager.notifyAll();
            while (!this.mWaitingForSurface && !this.mExited) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            FileLogger.i(TAG, "onPause tid=" + this.getId());
            this.mRequestPaused = true;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && !this.mPaused) {
                FileLogger.i(TAG, "onPause waiting for mPaused.");
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.mChoreographerRenderWrapper.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            FileLogger.i(TAG, "onResume tid=" + this.getId());
            this.mRequestPaused = false;
            this.mRequestRender = true;
            this.mRenderComplete = false;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                FileLogger.i(TAG, "onResume waiting for !mPaused.");
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            this.mChoreographerRenderWrapper.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowResize(int w, int h) {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            FileLogger.d(TAG, "width:" + w + " height:" + h);
            this.mWidth = w;
            this.mHeight = h;
            this.mSizeChanged = true;
            this.mRequestRender = true;
            this.mRenderComplete = false;
            if (Thread.currentThread() == this) {
                return;
            }
            this.sGLThreadManager.notifyAll();
            while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                FileLogger.i(TAG, "onWindowResize waiting for render complete from tid=" + this.getId());
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExitAndWait() {
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mShouldExit = true;
            this.sGLThreadManager.notifyAll();
            while (!this.mExited) {
                try {
                    this.sGLThreadManager.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEvent(Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("r must not be null");
        }
        GLThreadManager gLThreadManager = this.sGLThreadManager;
        synchronized (gLThreadManager) {
            this.mEventQueue.add(r);
            this.sGLThreadManager.notifyAll();
        }
    }

    public static class ChoreographerRenderWrapper {
        private ChoreographerRender choreographerRender = null;

        public ChoreographerRenderWrapper(GLThread glThread) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.choreographerRender = new ChoreographerRender(glThread);
            }
        }

        public void start() {
            if (this.choreographerRender != null) {
                this.choreographerRender.start();
            }
        }

        public void stop() {
            if (this.choreographerRender != null) {
                this.choreographerRender.stop();
            }
        }

        public boolean canSwap() {
            if (this.choreographerRender != null) {
                return this.choreographerRender.isCanSwap();
            }
            return true;
        }

        public void disableSwap() {
            if (this.choreographerRender != null) {
                this.choreographerRender.setCanSwap(false);
            }
        }
    }

    @TargetApi(value=16)
    public static class ChoreographerRender
    implements Choreographer.FrameCallback {
        private GLThread glThread;
        private boolean canSwap = true;

        @RequiresApi(api=16)
        public ChoreographerRender(GLThread glThread) {
            this.glThread = glThread;
        }

        public void doFrame(long frameTimeNanos) {
            if (this.glThread.getRenderMode() == 1) {
                this.canSwap = true;
                this.glThread.requestRender(frameTimeNanos);
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
            }
        }

        public void start() {
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }

        public void stop() {
            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
        }

        public void setCanSwap(boolean canSwap) {
            this.canSwap = canSwap;
        }

        public boolean isCanSwap() {
            return this.canSwap || this.glThread.getRenderMode() == 0;
        }
    }

    public static class Builder {
        private EGLConfigChooser configChooser;
        private EGLContextFactory eglContextFactory;
        private EGLWindowSurfaceFactory eglWindowSurfaceFactory;
        private GLViewRenderer renderer;
        private int eglContextClientVersion = 2;
        private int renderMode = 0;
        private Object surface;
        private EglContextWrapper eglContext = EglContextWrapper.EGL_NO_CONTEXT_WRAPPER;

        public Builder setSurface(Object surface) {
            this.surface = surface;
            return this;
        }

        public Builder setEGLConfigChooser(boolean needDepth) {
            this.setEGLConfigChooser(new SimpleEGLConfigChooser(needDepth, this.eglContextClientVersion));
            return this;
        }

        public Builder setEGLConfigChooser(EGLConfigChooser configChooser) {
            this.configChooser = configChooser;
            return this;
        }

        public Builder setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            this.setEGLConfigChooser(new ComponentSizeChooser(redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize, this.eglContextClientVersion));
            return this;
        }

        public Builder setEglContextFactory(EGLContextFactory eglContextFactory) {
            this.eglContextFactory = eglContextFactory;
            return this;
        }

        public Builder setEglWindowSurfaceFactory(EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
            this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
            return this;
        }

        public Builder setRenderer(GLViewRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder setGLWrapper(GLWrapper mGLWrapper) {
            return this;
        }

        public Builder setEglContextClientVersion(int eglContextClientVersion) {
            this.eglContextClientVersion = eglContextClientVersion;
            return this;
        }

        public Builder setRenderMode(int renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        public Builder setSharedEglContext(@NonNull EglContextWrapper sharedEglContext) {
            this.eglContext = sharedEglContext;
            return this;
        }

        public GLThread createGLThread() {
            if (this.renderer == null) {
                throw new NullPointerException("renderer has not been set");
            }
            if (this.surface == null && this.eglWindowSurfaceFactory == null) {
                throw new NullPointerException("surface has not been set");
            }
            if (this.configChooser == null) {
                this.configChooser = new SimpleEGLConfigChooser(true, this.eglContextClientVersion);
            }
            if (this.eglContextFactory == null) {
                this.eglContextFactory = new DefaultContextFactory(this.eglContextClientVersion);
            }
            if (this.eglWindowSurfaceFactory == null) {
                this.eglWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
            }
            return new GLThread(this.configChooser, this.eglContextFactory, this.eglWindowSurfaceFactory, this.renderer, this.renderMode, this.surface, this.eglContext);
        }
    }

    public static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        @Override
        public EGLSurface createWindowSurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig config, Object nativeWindow) {
            int[] surfaceAttribs = new int[]{12344};
            EGLSurface result = null;
            try {
                result = egl.eglCreateWindowSurface(display, config, nativeWindow, surfaceAttribs);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"DefaultWindow", (String)"eglCreateWindowSurface", (Throwable)e);
            }
            return result;
        }

        @Override
        public void destroySurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }

        @Override
        @TargetApi(value=17)
        public android.opengl.EGLSurface createWindowSurface(EGLDisplay display, android.opengl.EGLConfig config, Object nativeWindow) {
            int[] surfaceAttribs = new int[]{12344};
            android.opengl.EGLSurface result = null;
            try {
                result = EGL14.eglCreateWindowSurface((EGLDisplay)display, (android.opengl.EGLConfig)config, (Object)nativeWindow, (int[])surfaceAttribs, (int)0);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"DefaultWindow", (String)"eglCreateWindowSurface", (Throwable)e);
            }
            return result;
        }

        @Override
        @TargetApi(value=17)
        public void destroySurface(EGLDisplay display, android.opengl.EGLSurface surface) {
            EGL14.eglDestroySurface((EGLDisplay)display, (android.opengl.EGLSurface)surface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2, EGLSurface var3);

        public android.opengl.EGLSurface createWindowSurface(EGLDisplay var1, android.opengl.EGLConfig var2, Object var3);

        public void destroySurface(EGLDisplay var1, android.opengl.EGLSurface var2);
    }

    public static class DefaultContextFactory
    implements EGLContextFactory {
        private int EGL_CONTEXT_CLIENT_VERSION = 12440;
        private int contextClientVersion;

        public DefaultContextFactory(int contextClientVersion) {
            this.contextClientVersion = contextClientVersion;
        }

        @Override
        public EGLContext createContext(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig config, EGLContext eglContext) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, this.contextClientVersion, 12344};
            return egl.eglCreateContext(display, config, eglContext, (int[])(this.contextClientVersion != 0 ? attrib_list : null));
        }

        @Override
        public void destroyContext(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                FileLogger.e(GLThread.TAG, "DefaultContextFactory display:" + display + " context: " + context);
                EglHelper.throwEglException("eglDestroyContext", egl.eglGetError());
            }
        }

        @Override
        @TargetApi(value=17)
        public android.opengl.EGLContext createContextAPI17(EGLDisplay display, android.opengl.EGLConfig eglConfig, android.opengl.EGLContext sharedContext) {
            int[] attrib_list = new int[]{12440, this.contextClientVersion, 12344};
            return EGL14.eglCreateContext((EGLDisplay)display, (android.opengl.EGLConfig)eglConfig, (android.opengl.EGLContext)sharedContext, (int[])attrib_list, (int)0);
        }

        @Override
        @TargetApi(value=17)
        public void destroyContext(EGLDisplay display, android.opengl.EGLContext context) {
            if (!EGL14.eglDestroyContext((EGLDisplay)display, (android.opengl.EGLContext)context)) {
                FileLogger.e(GLThread.TAG, "DefaultContextFactory display:" + display + " context: " + context);
                EglHelper.throwEglException("eglDestroyContext", EGL14.eglGetError());
            }
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2, EGLConfig var3, EGLContext var4);

        public void destroyContext(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2, EGLContext var3);

        public android.opengl.EGLContext createContextAPI17(EGLDisplay var1, android.opengl.EGLConfig var2, android.opengl.EGLContext var3);

        public void destroyContext(EGLDisplay var1, android.opengl.EGLContext var2);
    }

    public static class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean withDepthBuffer, int contextClientVersion) {
            super(8, 8, 8, 0, withDepthBuffer ? 16 : 0, 0, contextClientVersion);
        }
    }

    private static class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue = new int[1];
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize, int contextClientVersion) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344}, contextClientVersion);
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private static abstract class BaseConfigChooser
    implements EGLConfigChooser {
        private static final int EGL_RECORDABLE_ANDROID = 12610;
        protected int[] mConfigSpec;
        private int contextClientVersion;

        public BaseConfigChooser(int[] configSpec, int contextClientVersion) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
            this.contextClientVersion = contextClientVersion;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] configSpec) {
            if (this.contextClientVersion != 2 && this.contextClientVersion != 3) {
                return configSpec;
            }
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = this.contextClientVersion == 2 ? 4 : 64;
            newConfigSpec[len + 1] = 12344;
            return newConfigSpec;
        }

        @Override
        @TargetApi(value=17)
        public android.opengl.EGLConfig chooseConfig(EGLDisplay display, boolean recordable) {
            int[] numConfigs;
            android.opengl.EGLConfig[] configs;
            int renderableType = 4;
            if (this.contextClientVersion >= 3) {
                renderableType |= 0x40;
            }
            int[] attribList = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, renderableType, 12344, 0, 12344};
            if (recordable) {
                attribList[attribList.length - 3] = 12610;
                attribList[attribList.length - 2] = 1;
            }
            if (!EGL14.eglChooseConfig((EGLDisplay)display, (int[])attribList, (int)0, (android.opengl.EGLConfig[])(configs = new android.opengl.EGLConfig[1]), (int)0, (int)configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
                Log.w((String)GLThread.TAG, (String)("unable to find RGB8888 / " + this.contextClientVersion + " EGLConfig"));
                return null;
            }
            return configs[0];
        }
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2);

        public android.opengl.EGLConfig chooseConfig(EGLDisplay var1, boolean var2);
    }

    private static class GLThreadManager {
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            FileLogger.i(GLThread.TAG, "exiting tid=" + thread.getId());
            thread.mExited = true;
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public boolean tryAcquireEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread || this.mEglOwner == null) {
                this.mEglOwner = thread;
                this.notifyAll();
                return true;
            }
            return true;
        }

        public void releaseEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }

    public static interface OnCreateGLContextListener {
        public void onCreate(EglContextWrapper var1);
    }
}

