/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture.gles;

import android.util.Log;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.glview.texture.gles.EGLLogWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import com.chillingvan.canvasgl.glview.texture.gles.IEglHelper;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglHelper
implements IEglHelper {
    private GLThread.EGLConfigChooser eglConfigChooser;
    private GLThread.EGLContextFactory eglContextFactory;
    private GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private EGL10 mEgl;
    private EGLDisplay mEglDisplay;
    private EGLSurface mEglSurface;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;

    public EglHelper(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.eglConfigChooser = configChooser;
        this.eglContextFactory = eglContextFactory;
        this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContext) {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEglConfig = this.eglConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
        this.mEglContext = this.eglContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig, eglContext.getEglContextOld());
        if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            this.mEglContext = null;
            this.throwEglException("createContext");
        }
        this.mEglSurface = null;
        EglContextWrapper eglContextWrapper = new EglContextWrapper();
        eglContextWrapper.setEglContextOld(this.mEglContext);
        return eglContextWrapper;
    }

    @Override
    public boolean createSurface(Object surface) {
        Loggers.w("EglHelper", "createSurface()  tid=" + Thread.currentThread().getId());
        if (this.mEgl == null) {
            throw new RuntimeException("egl not initialized");
        }
        if (this.mEglDisplay == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.mEglConfig == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        this.destroySurfaceImp();
        this.mEglSurface = this.eglWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
            int error = this.mEgl.eglGetError();
            if (error == 12299) {
                Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
            return false;
        }
        return true;
    }

    @Override
    public int swap() {
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
            return this.mEgl.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.destroySurfaceImp();
    }

    private void destroySurfaceImp() {
        if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.eglWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }

    @Override
    public void finish() {
        if (this.mEglContext != null) {
            this.eglContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            this.mEgl.eglTerminate(this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    @Override
    public void setPresentationTime(long nsecs) {
    }

    private void throwEglException(String function) {
        EglHelper.throwEglException(function, this.mEgl.eglGetError());
    }

    public static void throwEglException(String function, int error) {
        String message = EglHelper.formatEglError(function, error);
        throw new RuntimeException(message);
    }

    public static void logEglErrorAsWarning(String tag, String function, int error) {
        Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
    }

    public static String formatEglError(String function, int error) {
        return function + " failed: " + EGLLogWrapper.getErrorString(error);
    }
}

