/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public class PixelationFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_IMAGE_WIDTH_FACTOR = "imageWidthFactor";
    public static final String UNIFORM_IMAGE_HEIGHT_FACTOR = "imageHeightFactor";
    public static final String UNIFORM_PIXEL = "pixel";
    public static final String PIXELATION_FRAGMENT_SHADER = "precision highp float;\n varying vec2 vTextureCoord;\nuniform float imageWidthFactor;\nuniform float imageHeightFactor;\n uniform float uAlpha;\nuniform sampler2D uTextureSampler;\nuniform float pixel;\nvoid main() {\n  vec2 uv  = vTextureCoord.xy;\n  float dx = pixel * imageWidthFactor;\n  float dy = pixel * imageHeightFactor;\n  vec2 coord = vec2(dx * floor(uv.x / dx), dy * floor(uv.y / dy));\n  vec4 tc = texture2D(uTextureSampler, coord);\n  gl_FragColor = vec4(tc);\n    gl_FragColor *= uAlpha;\n}";
    private int mImageWidthFactorLocation;
    private int mImageHeightFactorLocation;
    private int mPixelLocation;
    private float mPixel;

    public PixelationFilter(@FloatRange(from=1.0, to=100.0) float pixel) {
        this.mPixel = pixel;
    }

    @Override
    public String getFragmentShader() {
        return PIXELATION_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        this.mImageWidthFactorLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_IMAGE_WIDTH_FACTOR);
        this.mImageHeightFactorLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_IMAGE_HEIGHT_FACTOR);
        this.mPixelLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_PIXEL);
        OpenGLUtil.setFloat(this.mImageWidthFactorLocation, 1.0f / (float)texture.getWidth());
        OpenGLUtil.setFloat(this.mImageHeightFactorLocation, 1.0f / (float)texture.getHeight());
        OpenGLUtil.setFloat(this.mPixelLocation, this.mPixel);
    }

    @Override
    public void setValue(@FloatRange(from=1.0, to=100.0) float pixel) {
        this.mPixel = pixel;
    }
}

