/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public class ColorMatrixFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_COLOR_MATRIX = "colorMatrix";
    public static final String UNIFORM_INTENSITY = "intensity";
    public static final String COLOR_MATRIX_FRAGMENT_SHADER = "varying highp vec2 vTextureCoord;\n\nuniform sampler2D uTextureSampler;\n\nuniform lowp mat4 colorMatrix;\nuniform lowp float intensity;\n uniform float uAlpha;\n\nvoid main() {\n    lowp vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n    lowp vec4 outputColor = textureColor * colorMatrix;\n    \n    gl_FragColor = (intensity * outputColor) + ((1.0 - intensity) * textureColor);\n    gl_FragColor *= uAlpha;\n}";
    private float a;
    private float[] b;

    public ColorMatrixFilter(@FloatRange(from=0.0, to=1.0) float intensity, float[] colorMatrix) {
        this.a = intensity;
        this.b = colorMatrix;
    }

    public void setIntensity(@FloatRange(from=0.0, to=1.0) float intensity) {
        this.a = intensity;
    }

    public void setColorMatrix(float[] colorMatrix) {
        this.b = colorMatrix;
    }

    @Override
    public String getFragmentShader() {
        return COLOR_MATRIX_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        OpenGLUtil.setFloat(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_INTENSITY), this.a);
        OpenGLUtil.setUniformMatrix4f(GLES20.glGetUniformLocation((int)program, (String)UNIFORM_COLOR_MATRIX), this.b);
    }

    @Override
    public void setValue(float value) {
        this.setIntensity(value);
    }
}

