/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.shapeFilter;

import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.shapeFilter.BasicDrawShapeFilter;

public class DrawCircleFilter
extends BasicDrawShapeFilter {
    public static final String VARYING_DRAW_REGION_COORD = "vDrawRegionCoord";
    public static final String CIRCLE_VERTEX_SHADER = "uniform mat4 uMatrix;\nattribute vec2 aPosition;\nvarying vec2 vDrawRegionCoord;\nvoid main() {\n  vec4 pos = vec4(aPosition, 0.0, 1.0);\n  gl_Position = uMatrix * pos;\n  vDrawRegionCoord = pos.xy;\n}\n";
    public static final String UNIFORM_LINE_WIDTH = "lineWidth";
    public static final String CIRCLE_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vDrawRegionCoord;\nuniform vec4 uColor;\nuniform float lineWidth;\nvoid main() {\n  float dx = vDrawRegionCoord.x - 0.5;\n  float dy = vDrawRegionCoord.y - 0.5;\n  float powVal = dx*dx + dy*dy; \n  float subRadius = 0.5 - lineWidth; \n  if(powVal >= subRadius * subRadius && powVal <= 0.5 * 0.5) {\n    gl_FragColor = uColor;\n  } else {\n    gl_FragColor = vec4(0, 0, 0, 0);\n  }\n \n}\n";
    private float a;

    public void setLineWidth(@FloatRange(from=0.0, to=0.5) float lineWidth) {
        this.a = lineWidth;
    }

    @Override
    public String getVertexShader() {
        return CIRCLE_VERTEX_SHADER;
    }

    @Override
    public String getFragmentShader() {
        return CIRCLE_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, ICanvasGL canvas) {
        super.onPreDraw(program, canvas);
        int n = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_LINE_WIDTH);
        OpenGLUtil.setFloat(n, this.a);
    }
}

