/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;

public class GLCanvasUtils {
    private static long[] a = new long[256];
    private static final boolean b = Build.TYPE.equals("eng") || Build.TYPE.equals("userdebug");

    public static void assertTrue(boolean cond) {
        if (!cond) {
            throw new AssertionError();
        }
    }

    public static void fail(String message, Object ... args) {
        throw new AssertionError((Object)(args.length == 0 ? message : String.format(message, args)));
    }

    public static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static boolean equals(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    public static int nextPowerOf2(int n) {
        if (n <= 0 || n > 0x40000000) {
            throw new IllegalArgumentException("n is invalid: " + n);
        }
        --n;
        n |= n >> 16;
        n |= n >> 8;
        n |= n >> 4;
        n |= n >> 2;
        n |= n >> 1;
        return n + 1;
    }

    public static int prevPowerOf2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return Integer.highestOneBit(n);
    }

    public static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static float clamp(float x, float min, float max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static long clamp(long x, long min, long max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static boolean isOpaque(int color) {
        return color >>> 24 == 255;
    }

    public static void swap(int[] array, int i, int j) {
        int n = array[i];
        array[i] = array[j];
        array[j] = n;
    }

    public static final long crc64Long(String in) {
        if (in == null || in.length() == 0) {
            return 0L;
        }
        return GLCanvasUtils.crc64Long(GLCanvasUtils.getBytes(in));
    }

    public static final long crc64Long(byte[] buffer) {
        long l = -1L;
        int n = buffer.length;
        for (int i = 0; i < n; ++i) {
            l = a[((int)l ^ buffer[i]) & 0xFF] ^ l >> 8;
        }
        return l;
    }

    public static byte[] getBytes(String in) {
        byte[] byArray = new byte[in.length() * 2];
        int n = 0;
        for (char c2 : in.toCharArray()) {
            byArray[n++] = (byte)(c2 & 0xFF);
            byArray[n++] = (byte)(c2 >> 8);
        }
        return byArray;
    }

    public static void closeSilently(Closeable c2) {
        if (c2 == null) {
            return;
        }
        try {
            c2.close();
        }
        catch (IOException iOException) {
            Log.w((String)"GLCanvasUtils", (String)"close fail ", (Throwable)iOException);
        }
    }

    public static int compare(long a2, long b2) {
        return a2 < b2 ? -1 : (a2 == b2 ? 0 : 1);
    }

    public static int ceilLog2(float value) {
        int n;
        for (n = 0; n < 31 && !((float)(1 << n) >= value); ++n) {
        }
        return n;
    }

    public static int floorLog2(float value) {
        int n;
        for (n = 0; n < 31 && !((float)(1 << n) > value); ++n) {
        }
        return n - 1;
    }

    public static void closeSilently(ParcelFileDescriptor fd) {
        try {
            if (fd != null) {
                fd.close();
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"GLCanvasUtils", (String)"fail to close", (Throwable)throwable);
        }
    }

    public static void closeSilently(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable throwable) {
            Log.w((String)"GLCanvasUtils", (String)"fail to close", (Throwable)throwable);
        }
    }

    public static float interpolateAngle(float source, float target, float progress) {
        float f;
        float f2 = target - source;
        if (f2 < 0.0f) {
            f2 += 360.0f;
        }
        if (f2 > 180.0f) {
            f2 -= 360.0f;
        }
        return (f = source + f2 * progress) < 0.0f ? f + 360.0f : f;
    }

    public static float interpolateScale(float source, float target, float progress) {
        return source + progress * (target - source);
    }

    public static String ensureNotNull(String value) {
        return value == null ? "" : value;
    }

    public static float parseFloatSafely(String content, float defaultValue) {
        if (content == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(content);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static int parseIntSafely(String content, int defaultValue) {
        if (content == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static boolean isNullOrEmpty(String exifMake) {
        return TextUtils.isEmpty((CharSequence)exifMake);
    }

    public static void waitWithoutInterrupt(Object object) {
        try {
            object.wait();
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)"GLCanvasUtils", (String)("unexpected interrupt: " + object));
        }
    }

    public static boolean handleInterrruptedException(Throwable e) {
        if (e instanceof InterruptedIOException || e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public static String escapeXml(String s) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = s.length();
        block7: for (int i = 0; i < n; ++i) {
            char c2 = s.charAt(i);
            switch (c2) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&#039;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String getUserAgent(Context context) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalStateException("getPackageInfo failed");
        }
        return String.format("%s/%s; %s/%s/%s/%s; %s/%s/%s", packageInfo.packageName, packageInfo.versionName, Build.BRAND, Build.DEVICE, Build.MODEL, Build.ID, Build.VERSION.SDK_INT, Build.VERSION.RELEASE, Build.VERSION.INCREMENTAL);
    }

    public static String[] copyOf(String[] source, int newSize) {
        String[] stringArray = new String[newSize];
        newSize = Math.min(source.length, newSize);
        System.arraycopy(source, 0, stringArray, 0, newSize);
        return stringArray;
    }

    public static String maskDebugInfo(Object info) {
        if (info == null) {
            return null;
        }
        String string = info.toString();
        int n = Math.min(string.length(), "********************************".length());
        return b ? string : "********************************".substring(0, n);
    }

    public static void debug(String message, Object ... args) {
        Log.v((String)"GalleryDebug", (String)String.format(message, args));
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                long l2 = ((int)l & 1) != 0 ? -7661587058870466123L : 0L;
                l = l >> 1 ^ l2;
            }
            GLCanvasUtils.a[i] = l;
        }
    }
}

