/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glcanvas;

import android.util.Log;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLCanvasUtils;
import com.chillingvan.canvasgl.glcanvas.Texture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import java.util.WeakHashMap;

public abstract class BasicTexture
implements Texture {
    protected static final int UNSPECIFIED = -1;
    protected static final int STATE_UNLOADED = 0;
    protected static final int STATE_LOADED = 1;
    protected static final int STATE_ERROR = -1;
    protected int mId = -1;
    protected int mState;
    protected int mWidth = -1;
    protected int mHeight = -1;
    protected int mTextureWidth;
    protected int mTextureHeight;
    private boolean a;
    protected GLCanvas mCanvasRef = null;
    private static WeakHashMap<BasicTexture, Object> b = new WeakHashMap();
    private static ThreadLocal c = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicTexture(GLCanvas canvas, int id, int state) {
        this.setAssociatedCanvas(canvas);
        this.mId = id;
        this.mState = state;
        WeakHashMap<BasicTexture, Object> weakHashMap = b;
        synchronized (weakHashMap) {
            b.put(this, null);
        }
    }

    protected BasicTexture() {
        this(null, 0, 0);
    }

    protected void setAssociatedCanvas(GLCanvas canvas) {
        this.mCanvasRef = canvas;
    }

    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTextureWidth = width > 0 ? GLCanvasUtils.nextPowerOf2(width) : 0;
        int n = this.mTextureHeight = height > 0 ? GLCanvasUtils.nextPowerOf2(height) : 0;
        if (this.mTextureWidth > 4096 || this.mTextureHeight > 4096) {
            Log.w((String)"BasicTexture", (String)String.format("secondBitmap is too large: %d x %d", this.mTextureWidth, this.mTextureHeight), (Throwable)new Exception());
        }
    }

    public boolean isFlippedVertically() {
        return false;
    }

    public int getId() {
        return this.mId;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    public int getTextureWidth() {
        return this.mTextureWidth;
    }

    public int getTextureHeight() {
        return this.mTextureHeight;
    }

    public boolean hasBorder() {
        return this.a;
    }

    protected void setBorder(boolean hasBorder) {
        this.a = hasBorder;
    }

    @Override
    public void draw(GLCanvas canvas, int x, int y) {
        canvas.drawTexture(this, x, y, this.getWidth(), this.getHeight(), new BasicTextureFilter());
    }

    @Override
    public void draw(GLCanvas canvas, int x, int y, int w, int h) {
        canvas.drawTexture(this, x, y, w, h, new BasicTextureFilter());
    }

    protected abstract boolean onBind(GLCanvas var1);

    protected abstract int getTarget();

    public boolean isLoaded() {
        return this.mState == 1;
    }

    public void recycle() {
        this.a();
    }

    public void yield() {
        this.a();
    }

    private void a() {
        GLCanvas gLCanvas = this.mCanvasRef;
        if (gLCanvas != null && this.mId != -1) {
            gLCanvas.unloadTexture(this);
            this.mId = -1;
        }
        this.mState = 0;
        this.setAssociatedCanvas(null);
    }

    protected void finalize() {
        c.set(BasicTexture.class);
        this.recycle();
        c.set(null);
    }

    public static boolean inFinalizer() {
        return c.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void yieldAllTextures() {
        WeakHashMap<BasicTexture, Object> weakHashMap = b;
        synchronized (weakHashMap) {
            for (BasicTexture basicTexture : b.keySet()) {
                basicTexture.yield();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateAllTextures() {
        WeakHashMap<BasicTexture, Object> weakHashMap = b;
        synchronized (weakHashMap) {
            for (BasicTexture basicTexture : b.keySet()) {
                basicTexture.mState = 0;
                basicTexture.setAssociatedCanvas(null);
            }
        }
    }
}

