/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.os.Handler;
import android.support.annotation.Nullable;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.GLSurfaceTextureProducerView;
import com.chillingvan.canvasgl.glview.texture.GLViewRenderer;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLSurface;

public abstract class OffScreenCanvas
implements GLViewRenderer {
    protected final GLThread mGLThread;
    private int a;
    private int b;
    protected ICanvasGL mCanvas;
    private BasicTexture c;
    private SurfaceTexture d;
    private GLSurfaceTextureProducerView.OnSurfaceTextureSet e;
    private SurfaceTexture f;
    private RawTexture g;
    private Handler h;
    private boolean i;
    private int j = 3553;
    private int k = 0;

    public OffScreenCanvas() {
        this(0, 0, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER);
    }

    public OffScreenCanvas(int width, int height) {
        this(width, height, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER);
    }

    public OffScreenCanvas(Object surface) {
        this(0, 0, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER, surface);
    }

    public OffScreenCanvas(int width, int height, Object surface) {
        this(width, height, EglContextWrapper.EGL_NO_CONTEXT_WRAPPER, surface);
    }

    public OffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext, Object surface) {
        this.a = width;
        this.b = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setSharedEglContext(sharedEglContext).setSurface(surface).setRenderer(this).createGLThread();
        this.h = new Handler();
    }

    public OffScreenCanvas(int width, int height, EglContextWrapper sharedEglContext) {
        this.a = width;
        this.b = height;
        this.mGLThread = new GLThread.Builder().setRenderMode(this.getRenderMode()).setSharedEglContext(sharedEglContext).setEglWindowSurfaceFactory(new a()).setRenderer(this).createGLThread();
        this.h = new Handler();
    }

    public void setProducedTextureTarget(int producedTextureTarget) {
        this.j = producedTextureTarget;
    }

    public void setOnCreateGLContextListener(GLThread.OnCreateGLContextListener onCreateGLContextListener) {
        this.mGLThread.setOnCreateGLContextListener(onCreateGLContextListener);
    }

    public void setOnSurfaceTextureSet(GLSurfaceTextureProducerView.OnSurfaceTextureSet onSurfaceTextureSet) {
        this.e = onSurfaceTextureSet;
    }

    public void setSharedTexture(BasicTexture outsideTexture, @Nullable SurfaceTexture outsideSurfaceTexture) {
        this.c = outsideTexture;
        this.d = outsideSurfaceTexture;
    }

    public void setSize(int width, int height) {
        this.a = width;
        this.b = height;
        if (this.i) {
            this.mGLThread.onWindowResize(width, height);
        }
    }

    public void setBackgroundColor(int backgroundColor) {
        this.k = backgroundColor;
    }

    public void start() {
        this.mGLThread.start();
        this.mGLThread.surfaceCreated();
        this.mGLThread.onWindowResize(this.a, this.b);
        this.i = true;
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void end() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        if (this.g != null) {
            this.g.recycle();
            this.g = null;
        }
        if (this.f != null) {
            this.f.release();
            this.f = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.end();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void onSurfaceCreated() {
        Loggers.d("OffScreenCanvas", "onSurfaceCreated: ");
        this.mCanvas = new CanvasGL();
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        Loggers.d("OffScreenCanvas", "onSurfaceChanged: ");
        this.mCanvas.setSize(width, height);
        if (this.g == null) {
            this.g = new RawTexture(width, height, false, this.j);
            if (!this.g.isLoaded()) {
                this.g.prepare(this.mCanvas.getGlCanvas());
            }
            this.f = new SurfaceTexture(this.g.getId());
            this.h.post(new Runnable(){

                @Override
                public void run() {
                    if (OffScreenCanvas.this.e != null) {
                        OffScreenCanvas.this.e.onSet(OffScreenCanvas.this.f, OffScreenCanvas.this.g);
                    }
                }
            });
        } else {
            this.g.setSize(width, height);
        }
    }

    @Override
    public void onDrawFrame() {
        this.mCanvas.clearBuffer(this.k);
        if (this.j != 3553) {
            this.f.updateTexImage();
        }
        this.onGLDraw(this.mCanvas, this.f, this.g, this.d, this.c);
    }

    protected int getRenderMode() {
        return 0;
    }

    protected abstract void onGLDraw(ICanvasGL var1, SurfaceTexture var2, RawTexture var3, @Nullable SurfaceTexture var4, @Nullable BasicTexture var5);

    public void queueEvent(Runnable r) {
        if (this.mGLThread == null) {
            return;
        }
        this.mGLThread.queueEvent(r);
    }

    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        final Handler handler = new Handler();
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                OffScreenCanvas.this.onDrawFrame();
                OffScreenCanvas.this.onDrawFrame();
                final Bitmap bitmap = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, OffScreenCanvas.this.b);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmap);
                    }
                });
            }
        });
        this.requestRender();
    }

    class a
    implements GLThread.EGLWindowSurfaceFactory {
        private a() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLConfig config, Object nativeWindow) {
            int[] nArray = new int[]{12375, OffScreenCanvas.this.a, 12374, OffScreenCanvas.this.b, 12344};
            return egl.eglCreatePbufferSurface(display, config, nArray);
        }

        @Override
        public void destroySurface(EGL10 egl, javax.microedition.khronos.egl.EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }

        @Override
        @TargetApi(value=17)
        public android.opengl.EGLSurface createWindowSurface(EGLDisplay display, android.opengl.EGLConfig config, Object nativeWindow) {
            int[] nArray = new int[]{12375, OffScreenCanvas.this.a, 12374, OffScreenCanvas.this.b, 12344};
            return EGL14.eglCreatePbufferSurface((EGLDisplay)display, (android.opengl.EGLConfig)config, (int[])nArray, (int)0);
        }

        @Override
        @TargetApi(value=17)
        public void destroySurface(EGLDisplay display, android.opengl.EGLSurface surface) {
            EGL14.eglDestroySurface((EGLDisplay)display, (android.opengl.EGLSurface)surface);
        }
    }
}

