/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture.gles;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.glview.texture.gles.EglContextWrapper;
import com.chillingvan.canvasgl.glview.texture.gles.EglHelper;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import com.chillingvan.canvasgl.glview.texture.gles.IEglHelper;

@RequiresApi(value=17)
public class EglHelperAPI17
implements IEglHelper {
    private GLThread.EGLConfigChooser eglConfigChooser;
    private GLThread.EGLContextFactory eglContextFactory;
    private GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private EGLDisplay mEglDisplay;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;
    private EGLSurface mEglSurface;

    public EglHelperAPI17(GLThread.EGLConfigChooser configChooser, GLThread.EGLContextFactory eglContextFactory, GLThread.EGLWindowSurfaceFactory eglWindowSurfaceFactory) {
        this.eglConfigChooser = configChooser;
        this.eglContextFactory = eglContextFactory;
        this.eglWindowSurfaceFactory = eglWindowSurfaceFactory;
    }

    @Override
    public EglContextWrapper start(EglContextWrapper eglContext) {
        Loggers.w("EglHelper", "start() tid=" + Thread.currentThread().getId());
        this.mEglDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
            throw new RuntimeException("eglGetDisplay failed");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            this.mEglDisplay = null;
            throw new RuntimeException("eglInitialize failed");
        }
        this.mEglConfig = this.eglConfigChooser.chooseConfig(this.mEglDisplay, false);
        this.mEglContext = this.eglContextFactory.createContextAPI17(this.mEglDisplay, this.mEglConfig, eglContext.getEglContext());
        if (this.mEglContext == null || this.mEglContext == EGL14.EGL_NO_CONTEXT) {
            this.mEglContext = null;
            this.throwEglException("createContext");
        }
        Loggers.w("EglHelper", "createContext " + this.mEglContext + " tid=" + Thread.currentThread().getId());
        this.mEglSurface = null;
        EglContextWrapper eglContextWrapper = new EglContextWrapper();
        eglContextWrapper.setEglContext(this.mEglContext);
        return eglContextWrapper;
    }

    @Override
    public boolean createSurface(Object surface) {
        Loggers.w("EglHelper", "createSurface()  tid=" + Thread.currentThread().getId());
        if (this.mEglDisplay == null) {
            throw new RuntimeException("eglDisplay not initialized");
        }
        if (this.mEglConfig == null) {
            throw new RuntimeException("mEglConfig not initialized");
        }
        this.destroySurfaceImp();
        this.mEglSurface = this.eglWindowSurfaceFactory.createWindowSurface(this.mEglDisplay, this.mEglConfig, surface);
        if (this.mEglSurface == null || this.mEglSurface == EGL14.EGL_NO_SURFACE) {
            int error = EGL14.eglGetError();
            if (error == 12299) {
                Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext)) {
            EglHelperAPI17.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", EGL14.eglGetError());
            return false;
        }
        return true;
    }

    @Override
    public int swap() {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
            Loggers.w("EglHelperAPI17", String.format("swap: start get error", new Object[0]));
            return EGL14.eglGetError();
        }
        return 12288;
    }

    @Override
    public void destroySurface() {
        this.destroySurfaceImp();
    }

    private void destroySurfaceImp() {
        if (this.mEglSurface != null && this.mEglSurface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            this.eglWindowSurfaceFactory.destroySurface(this.mEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
        }
    }

    @Override
    public void finish() {
        if (this.mEglContext != null) {
            this.eglContextFactory.destroyContext(this.mEglDisplay, this.mEglContext);
            this.mEglContext = null;
        }
        if (this.mEglDisplay != null) {
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            this.mEglDisplay = null;
        }
    }

    @Override
    public void setPresentationTime(long nsecs) {
        if (Build.VERSION.SDK_INT >= 18 && nsecs != 0L) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (long)nsecs);
        }
    }

    public static void logEglErrorAsWarning(String tag, String function, int error) {
        Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
    }

    private void throwEglException(String function) {
        EglHelperAPI17.throwEglException(function, EGL14.eglGetError());
    }

    public static void throwEglException(String function, int error) {
        String message = EglHelper.formatEglError(function, error);
        Loggers.e("EglHelper", "throwEglException tid=" + Thread.currentThread().getId() + " " + message);
        throw new RuntimeException(message);
    }
}

