/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.GLSurfaceView;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.BaseGLTextureView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

abstract class BaseGLCanvasTextureView
extends BaseGLTextureView
implements GLSurfaceView.Renderer {
    protected ICanvasGL mCanvas;
    private int backgroundColor = 0;

    public BaseGLCanvasTextureView(Context context) {
        super(context);
    }

    public BaseGLCanvasTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseGLCanvasTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        super.init();
        this.setRenderer(this);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.mCanvas = new CanvasGL();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mCanvas.setSize(width, height);
    }

    public void onDrawFrame(GL10 gl) {
        this.mGL = gl;
        this.mCanvas.clearBuffer(this.backgroundColor);
        this.onGLDraw(this.mCanvas);
    }

    @Override
    protected abstract void onGLDraw(ICanvasGL var1);

    public void setRenderBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
    }

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (BaseGLCanvasTextureView.this.mGL == null) {
                    return;
                }
                BaseGLCanvasTextureView.this.onDrawFrame(BaseGLCanvasTextureView.this.mGL);
                BaseGLCanvasTextureView.this.onDrawFrame(BaseGLCanvasTextureView.this.mGL);
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, BaseGLCanvasTextureView.this.mGL, BaseGLCanvasTextureView.this.getHeight());
                BaseGLCanvasTextureView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.requestRender();
    }
}

