/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.glcanvas.BitmapTexture;
import com.chillingvan.canvasgl.glcanvas.GLCanvas;
import com.chillingvan.canvasgl.glcanvas.GLES20Canvas;
import com.chillingvan.canvasgl.glcanvas.GLPaint;
import com.chillingvan.canvasgl.glcanvas.RawTexture;
import com.chillingvan.canvasgl.shapeFilter.BasicDrawShapeFilter;
import com.chillingvan.canvasgl.shapeFilter.DrawCircleFilter;
import com.chillingvan.canvasgl.shapeFilter.DrawShapeFilter;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.FilterGroup;
import com.chillingvan.canvasgl.textureFilter.TextureFilter;
import java.util.Map;
import java.util.WeakHashMap;

public class CanvasGL
implements ICanvasGL {
    private Map<Bitmap, BasicTexture> bitmapTextureMap = new WeakHashMap<Bitmap, BasicTexture>();
    protected final GLCanvas glCanvas;
    protected final BasicTextureFilter basicTextureFilter;
    private float[] canvasBackgroundColor;
    private float[] surfaceTextureMatrix = new float[16];
    private int width;
    private int height;
    private BasicDrawShapeFilter basicDrawShapeFilter;
    private DrawCircleFilter drawCircleFilter = new DrawCircleFilter();

    public CanvasGL() {
        this(new GLES20Canvas());
    }

    public CanvasGL(GLCanvas glCanvas) {
        this.glCanvas = glCanvas;
        glCanvas.setOnPreDrawShapeListener(new GLCanvas.OnPreDrawShapeListener(){

            @Override
            public void onPreDraw(int program, DrawShapeFilter drawShapeFilter) {
                drawShapeFilter.onPreDraw(program, CanvasGL.this);
            }
        });
        glCanvas.setOnPreDrawTextureListener(new GLCanvas.OnPreDrawTextureListener(){

            @Override
            public void onPreDraw(int textureProgram, BasicTexture texture, TextureFilter textureFilter) {
                textureFilter.onPreDraw(textureProgram, texture, CanvasGL.this);
            }
        });
        this.basicTextureFilter = new BasicTextureFilter();
        this.basicDrawShapeFilter = new BasicDrawShapeFilter();
        this.canvasBackgroundColor = new float[4];
    }

    @Override
    public BitmapTexture bindBitmapToTexture(int whichTexture, Bitmap bitmap) {
        GLES20.glActiveTexture((int)whichTexture);
        GLES20Canvas.checkError();
        BitmapTexture texture = (BitmapTexture)this.getTexture(bitmap, null);
        texture.onBind(this.glCanvas);
        GLES20.glBindTexture((int)texture.getTarget(), (int)texture.getId());
        GLES20Canvas.checkError();
        return texture;
    }

    @Override
    public void beginRenderTarget(RawTexture texture) {
        this.glCanvas.beginRenderTarget(texture);
    }

    @Override
    public void endRenderTarget() {
        this.glCanvas.endRenderTarget();
    }

    @Override
    public GLCanvas getGlCanvas() {
        return this.glCanvas;
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom) {
        this.drawSurfaceTexture(texture, surfaceTexture, left, top, right, bottom, this.basicTextureFilter);
    }

    @Override
    public void drawSurfaceTexture(BasicTexture texture, SurfaceTexture surfaceTexture, int left, int top, int right, int bottom, TextureFilter basicTextureFilter) {
        if (surfaceTexture == null) {
            this.glCanvas.drawTexture(texture, left, top, right - left, bottom - top, basicTextureFilter);
        } else {
            surfaceTexture.getTransformMatrix(this.surfaceTextureMatrix);
            this.glCanvas.drawTexture(texture, this.surfaceTextureMatrix, left, top, right - left, bottom - top, basicTextureFilter);
        }
    }

    @Override
    public void drawBitmap(Bitmap bitmap, BitmapMatrix matrix) {
        this.drawBitmap(bitmap, matrix, this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, BitmapMatrix matrix, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.save();
        this.glCanvas.setMatrix(matrix.obtainResultMatrix());
        this.glCanvas.drawTexture(basicTexture, 0, 0, bitmap.getWidth(), bitmap.getHeight(), textureFilter);
        this.restore();
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst) {
        this.drawBitmap(bitmap, new RectF(src), dst, (TextureFilter)this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top) {
        this.drawBitmap(bitmap, left, top, (TextureFilter)this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, left, top, bitmap.getWidth(), bitmap.getHeight(), textureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst) {
        this.drawBitmap(bitmap, src, new RectF(dst));
    }

    @Override
    public void drawBitmap(Bitmap bitmap, RectF src, RectF dst, TextureFilter textureFilter) {
        if (dst == null) {
            throw new NullPointerException();
        }
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, src, dst, textureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, int width, int height) {
        this.drawBitmap(bitmap, left, top, width, height, this.basicTextureFilter);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top, int width, int height, TextureFilter textureFilter) {
        BasicTexture basicTexture = this.getTexture(bitmap, textureFilter);
        this.glCanvas.drawTexture(basicTexture, left, top, width, height, textureFilter);
    }

    protected BasicTexture getTexture(Bitmap bitmap, @Nullable TextureFilter textureFilter) {
        BasicTexture resultTexture;
        this.throwIfCannotDraw(bitmap);
        if (this.bitmapTextureMap.containsKey(bitmap)) {
            resultTexture = this.bitmapTextureMap.get(bitmap);
        } else {
            resultTexture = new BitmapTexture(bitmap);
            this.bitmapTextureMap.put(bitmap, resultTexture);
        }
        if (textureFilter instanceof FilterGroup) {
            FilterGroup filterGroup = (FilterGroup)textureFilter;
            resultTexture = filterGroup.draw(resultTexture, this.glCanvas);
        }
        return resultTexture;
    }

    @Override
    public void drawCircle(float x, float y, float radius, GLPaint paint) {
        if (paint.getStyle() == Paint.Style.FILL) {
            this.drawCircleFilter.setLineWidth(0.5f);
        } else {
            this.drawCircleFilter.setLineWidth(paint.getLineWidth() / (2.0f * radius));
        }
        this.glCanvas.drawCircle(x - radius, y - radius, radius, paint, this.drawCircleFilter);
    }

    @Override
    public void drawLine(float startX, float startY, float stopX, float stopY, GLPaint paint) {
        this.glCanvas.drawLine(startX, startY, stopX, stopY, paint, this.basicDrawShapeFilter);
    }

    @Override
    public void drawRect(@NonNull RectF rect, GLPaint paint) {
        this.drawRect(rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    @Override
    public void drawRect(@NonNull Rect r, GLPaint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    @Override
    public void drawRect(float left, float top, float right, float bottom, GLPaint paint) {
        if (paint.getStyle() == Paint.Style.STROKE) {
            this.glCanvas.drawRect(left, top, right - left, bottom - top, paint, this.basicDrawShapeFilter);
        } else {
            this.glCanvas.fillRect(left, top, right - left, bottom - top, paint.getColor(), this.basicDrawShapeFilter);
        }
    }

    @Override
    public void save() {
        this.glCanvas.save();
    }

    @Override
    public void save(int saveFlags) {
        this.glCanvas.save(saveFlags);
    }

    @Override
    public void restore() {
        this.glCanvas.restore();
    }

    @Override
    public void rotate(float degrees) {
        this.glCanvas.rotate(degrees, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float degrees, float px, float py) {
        this.glCanvas.translate(px, py);
        this.rotate(degrees);
        this.glCanvas.translate(-px, -py);
    }

    @Override
    public void scale(float sx, float sy) {
        this.glCanvas.scale(sx, sy, 1.0f);
    }

    @Override
    public void scale(float sx, float sy, float px, float py) {
        this.glCanvas.translate(px, py);
        this.scale(sx, sy);
        this.glCanvas.translate(-px, -py);
    }

    @Override
    public void translate(float dx, float dy) {
        this.glCanvas.translate(dx, dy);
    }

    @Override
    public void clearBuffer() {
        this.glCanvas.clearBuffer();
    }

    @Override
    public void clearBuffer(int color) {
        this.canvasBackgroundColor[1] = (float)Color.red((int)color) / 255.0f;
        this.canvasBackgroundColor[2] = (float)Color.green((int)color) / 255.0f;
        this.canvasBackgroundColor[3] = (float)Color.blue((int)color) / 255.0f;
        this.canvasBackgroundColor[0] = (float)Color.alpha((int)color) / 255.0f;
        this.glCanvas.clearBuffer(this.canvasBackgroundColor);
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.glCanvas.setSize(width, height);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.glCanvas.setAlpha((float)alpha / 255.0f);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (BasicTexture bitmapTexture : this.bitmapTextureMap.values()) {
            bitmapTexture.recycle();
        }
    }

    protected void throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (Build.VERSION.SDK_INT >= 17 && !bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
    }

    public static class BitmapMatrix {
        public static final int TRANSLATE_X = 3;
        public static final int TRANSLATE_Y = 7;
        public static final int SCALE_X = 0;
        public static final int SCALE_Y = 5;
        public static final int MATRIX_SIZE = 16;
        public static final int SKEW_X = 4;
        public static final int SKEW_Y = 1;
        private float[] tempMultipyMatrix4 = new float[16];
        private float[] concatResultMatrix4 = new float[16];

        public BitmapMatrix() {
            this.reset();
        }

        public void reset() {
            Matrix.setIdentityM((float[])this.tempMultipyMatrix4, (int)0);
            Matrix.setIdentityM((float[])this.concatResultMatrix4, (int)0);
            Matrix.scaleM((float[])this.concatResultMatrix4, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
        }

        public void postTranslate(float dx, float dy) {
            Matrix.setIdentityM((float[])this.tempMultipyMatrix4, (int)0);
            this.tempMultipyMatrix4[3] = dx;
            this.tempMultipyMatrix4[7] = -dy;
            this.concatResultMatrix4 = this.multiplyMatrix(this.tempMultipyMatrix4, this.concatResultMatrix4);
        }

        public void postScale(float sx, float sy, float px, float py) {
            Matrix.setIdentityM((float[])this.tempMultipyMatrix4, (int)0);
            this.tempMultipyMatrix4[0] = sx;
            this.tempMultipyMatrix4[5] = sy;
            this.tempMultipyMatrix4[3] = px - sx * px;
            this.tempMultipyMatrix4[7] = -(py - sy * py);
            this.concatResultMatrix4 = this.multiplyMatrix(this.tempMultipyMatrix4, this.concatResultMatrix4);
        }

        public void postScale(float sx, float sy) {
            this.postScale(sx, sy, 0.0f, 0.0f);
        }

        public void postRotate(float degrees, float px, float py) {
            float cos;
            Matrix.setIdentityM((float[])this.tempMultipyMatrix4, (int)0);
            float sin = (float)Math.sin(Math.toRadians(degrees));
            this.tempMultipyMatrix4[0] = cos = (float)Math.cos(Math.toRadians(degrees));
            this.tempMultipyMatrix4[4] = -sin;
            this.tempMultipyMatrix4[1] = sin;
            this.tempMultipyMatrix4[5] = cos;
            this.tempMultipyMatrix4[3] = py * sin + px * (1.0f - cos);
            this.tempMultipyMatrix4[7] = -(py * (1.0f - cos) - px * sin);
            this.concatResultMatrix4 = this.multiplyMatrix(this.tempMultipyMatrix4, this.concatResultMatrix4);
        }

        public void postRotate(float degrees) {
            this.postRotate(degrees, 0.0f, 0.0f);
        }

        private float[] multiplyMatrix(float[] lhs, float[] rhs) {
            float[] resultMatrix4 = new float[16];
            for (int i = 0; i < 4; ++i) {
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                float w = 0.0f;
                for (int j = 0; j < 4; ++j) {
                    float e = BitmapMatrix.matrixGet(lhs, i, j);
                    x += BitmapMatrix.matrixGet(rhs, j, 0) * e;
                    y += BitmapMatrix.matrixGet(rhs, j, 1) * e;
                    z += BitmapMatrix.matrixGet(rhs, j, 2) * e;
                    w += BitmapMatrix.matrixGet(rhs, j, 3) * e;
                }
                BitmapMatrix.matrixSet(resultMatrix4, i, 0, x);
                BitmapMatrix.matrixSet(resultMatrix4, i, 1, y);
                BitmapMatrix.matrixSet(resultMatrix4, i, 2, z);
                BitmapMatrix.matrixSet(resultMatrix4, i, 3, w);
            }
            return resultMatrix4;
        }

        private static void matrixSet(float[] m, int x, int y, float val) {
            m[4 * x + y] = val;
        }

        private static float matrixGet(float[] m, int x, int y) {
            return m[4 * x + y];
        }

        public float[] obtainResultMatrix() {
            float[] resultMatrix4 = new float[16];
            Matrix.transposeM((float[])resultMatrix4, (int)0, (float[])this.concatResultMatrix4, (int)0);
            return resultMatrix4;
        }
    }
}

