/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import android.opengl.GLES20;
import android.support.annotation.FloatRange;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glcanvas.BasicTexture;
import com.chillingvan.canvasgl.textureFilter.BasicTextureFilter;
import com.chillingvan.canvasgl.textureFilter.OneValueFilter;

public class ContrastFilter
extends BasicTextureFilter
implements OneValueFilter {
    public static final String UNIFORM_CONTRAST = "contrast";
    public static final String CONTRAST_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform float uAlpha;\nuniform float contrast;\nuniform sampler2D uTextureSampler;\nvoid main() {\n  vec4 textureColor = texture2D(uTextureSampler, vTextureCoord);\n  gl_FragColor = vec4(((textureColor.rgb - vec3(0.5)) * contrast+ vec3(0.5)), textureColor.w);\n  gl_FragColor *= uAlpha;\n}\n";
    private float mContrast;
    private int mContrastLocation;

    public ContrastFilter(@FloatRange(from=0.0, to=4.0) float contrast) {
        this.mContrast = contrast;
    }

    @Override
    public String getFragmentShader() {
        return CONTRAST_FRAGMENT_SHADER;
    }

    @Override
    public void onPreDraw(int program, BasicTexture texture, ICanvasGL canvas) {
        super.onPreDraw(program, texture, canvas);
        this.mContrastLocation = GLES20.glGetUniformLocation((int)program, (String)UNIFORM_CONTRAST);
        OpenGLUtil.setFloat(this.mContrastLocation, this.mContrast);
    }

    @Override
    public void setValue(@FloatRange(from=0.0, to=4.0) float contrast) {
        this.mContrast = contrast;
    }
}

