/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.TextureView;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.Loggers;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.gles.GLThread;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

abstract class BaseGLTextureView
extends TextureView
implements GLSurfaceView.Renderer,
TextureView.SurfaceTextureListener {
    protected GLThread mGLThread;
    protected GLThread.Builder glThreadBuilder = new GLThread.Builder();
    protected ICanvasGL mCanvas;
    private int backgroundColor = 0;
    private List<Runnable> cacheEvents = new ArrayList<Runnable>();
    public GL10 mGL;
    private TextureView.SurfaceTextureListener surfaceTextureListener;
    private GLThread.OnCreateGLContextListener onCreateGLContextListener;
    private boolean shouldBeCreated = false;
    private boolean surfaceAvailable = false;

    public BaseGLTextureView(Context context) {
        super(context);
        this.init();
    }

    public BaseGLTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BaseGLTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Loggers.d("BaseGLTextureView", "onSizeChanged: ");
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mGLThread != null) {
            this.mGLThread.onWindowResize(w, h);
        }
    }

    public void onPause() {
        if (this.mGLThread != null) {
            this.mGLThread.onPause();
        }
    }

    public void onResume() {
        if (this.mGLThread != null) {
            this.mGLThread.onResume();
        }
    }

    public void queueEvent(Runnable r) {
        if (this.mGLThread == null) {
            this.cacheEvents.add(r);
            return;
        }
        this.mGLThread.queueEvent(r);
    }

    public void requestRender() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRender();
        }
    }

    public void requestRenderAndWait() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void surfaceCreated() {
        this.mGLThread.surfaceCreated();
    }

    protected void surfaceDestroyed() {
        this.mGLThread.surfaceDestroyed();
    }

    protected void surfaceChanged(int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    protected void surfaceRedrawNeeded() {
        if (this.mGLThread != null) {
            this.mGLThread.requestRenderAndWait();
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        super.onDetachedFromWindow();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void init() {
        super.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    @Nullable
    public EGLContext getCurrentEglContext() {
        return this.mGLThread == null ? null : this.mGLThread.getEglContext();
    }

    public void setOnCreateGLContextListener(GLThread.OnCreateGLContextListener onCreateGLContextListener) {
        this.onCreateGLContextListener = onCreateGLContextListener;
    }

    public void setSurfaceTextureListener(TextureView.SurfaceTextureListener surfaceTextureListener) {
        this.surfaceTextureListener = surfaceTextureListener;
    }

    protected int getRenderMode() {
        return 0;
    }

    public void setRenderBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
    }

    protected abstract void onGLDraw(ICanvasGL var1);

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (BaseGLTextureView.this.mGL == null) {
                    return;
                }
                BaseGLTextureView.this.onDrawFrame(BaseGLTextureView.this.mGL);
                BaseGLTextureView.this.onDrawFrame(BaseGLTextureView.this.mGL);
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, BaseGLTextureView.this.mGL, BaseGLTextureView.this.getHeight());
                BaseGLTextureView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.requestRender();
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Loggers.d("BaseGLTextureView", "onSurfaceCreated: ");
        this.mCanvas = new CanvasGL();
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Loggers.d("BaseGLTextureView", "onSurfaceChanged: ");
        this.mCanvas.setSize(width, height);
    }

    public void onDrawFrame(GL10 gl) {
        this.mGL = gl;
        this.mCanvas.clearBuffer(this.backgroundColor);
        this.onGLDraw(this.mCanvas);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Loggers.d("BaseGLTextureView", "onSurfaceTextureAvailable: ");
        this.surfaceAvailable = true;
        if (this.mGLThread == null) {
            this.glThreadBuilder.setRenderMode(this.getRenderMode()).setSurface(surface).setRenderer(this);
            if (this.shouldBeCreated) {
                this.createGLThread();
            }
        } else {
            this.mGLThread.setSurface(surface);
            this.freshSurface(width, height);
        }
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onSurfaceTextureAvailable(surface, width, height);
        }
    }

    protected void createGLThread() {
        this.shouldBeCreated = true;
        if (!this.surfaceAvailable) {
            return;
        }
        this.mGLThread = this.glThreadBuilder.createGLThread();
        this.mGLThread.setOnCreateGLContextListener(new GLThread.OnCreateGLContextListener(){

            @Override
            public void onCreate(final EGLContext eglContext) {
                BaseGLTextureView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BaseGLTextureView.this.onCreateGLContextListener != null) {
                            BaseGLTextureView.this.onCreateGLContextListener.onCreate(eglContext);
                        }
                    }
                });
            }
        });
        this.mGLThread.start();
        this.freshSurface(this.getWidth(), this.getHeight());
        for (Runnable cacheEvent : this.cacheEvents) {
            this.mGLThread.queueEvent(cacheEvent);
        }
        this.cacheEvents.clear();
    }

    private void freshSurface(int width, int height) {
        this.surfaceCreated();
        this.surfaceChanged(width, height);
        this.surfaceRedrawNeeded();
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        Loggers.d("BaseGLTextureView", "onSurfaceTextureSizeChanged: ");
        this.surfaceChanged(width, height);
        this.surfaceRedrawNeeded();
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onSurfaceTextureSizeChanged(surface, width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        Loggers.d("BaseGLTextureView", "onSurfaceTextureDestroyed: ");
        this.surfaceDestroyed();
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onSurfaceTextureDestroyed(surface);
        }
        this.surfaceAvailable = false;
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.surfaceTextureListener != null) {
            this.surfaceTextureListener.onSurfaceTextureUpdated(surface);
        }
    }
}

