/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.textureFilter;

import androidx.annotation.FloatRange;
import com.chillingvan.canvasgl.textureFilter.TextureSampling3mul3Filter;

public class DirectionalSobelEdgeDetectionFilter
extends TextureSampling3mul3Filter {
    public static final String DIRECTIONAL_SOBEL_EDGE_DETECTION_FRAGMENT_SHADER = "precision mediump float;\n\nvarying vec2 vTextureCoord;\nvarying vec2 leftTextureCoordinate;\nvarying vec2 rightTextureCoordinate;\n\nvarying vec2 topTextureCoordinate;\nvarying vec2 topLeftTextureCoordinate;\nvarying vec2 topRightTextureCoordinate;\n\nvarying vec2 bottomTextureCoordinate;\nvarying vec2 bottomLeftTextureCoordinate;\nvarying vec2 bottomRightTextureCoordinate;\n\nuniform sampler2D uTextureSampler;\n uniform float uAlpha;\n\nvoid main() {\n    float bottomLeftIntensity = texture2D(uTextureSampler, bottomLeftTextureCoordinate).r;\n    float topRightIntensity = texture2D(uTextureSampler, topRightTextureCoordinate).r;\n    float topLeftIntensity = texture2D(uTextureSampler, topLeftTextureCoordinate).r;\n    float bottomRightIntensity = texture2D(uTextureSampler, bottomRightTextureCoordinate).r;\n    float leftIntensity = texture2D(uTextureSampler, leftTextureCoordinate).r;\n    float rightIntensity = texture2D(uTextureSampler, rightTextureCoordinate).r;\n    float bottomIntensity = texture2D(uTextureSampler, bottomTextureCoordinate).r;\n    float topIntensity = texture2D(uTextureSampler, topTextureCoordinate).r;\n\n    vec2 gradientDirection;\n    gradientDirection.x = -bottomLeftIntensity - 2.0 * leftIntensity - topLeftIntensity + bottomRightIntensity + 2.0 * rightIntensity + topRightIntensity;\n    gradientDirection.y = -topLeftIntensity - 2.0 * topIntensity - topRightIntensity + bottomLeftIntensity + 2.0 * bottomIntensity + bottomRightIntensity;\n\n    float gradientMagnitude = length(gradientDirection);\n    vec2 normalizedDirection = normalize(gradientDirection);\n    normalizedDirection = sign(normalizedDirection) * floor(abs(normalizedDirection) + 0.617316); // Offset by 1-sin(pi/8) to set to 0 if near axis, 1 if away\n    normalizedDirection = (normalizedDirection + 1.0) * 0.5; // Place -1.0 - 1.0 within 0 - 1.0\n\n    gl_FragColor = vec4(gradientMagnitude, normalizedDirection.x, normalizedDirection.y, 1.0);\n    gl_FragColor *= uAlpha;\n}";

    public DirectionalSobelEdgeDetectionFilter(@FloatRange(from=0.0, to=5.0) float lineSize) {
        super(lineSize);
    }

    @Override
    public String getFragmentShader() {
        return DIRECTIONAL_SOBEL_EDGE_DETECTION_FRAGMENT_SHADER;
    }
}

