/*
 * Decompiled with CFR 0.152.
 */
package com.chillingvan.canvasgl.glview.texture;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import com.chillingvan.canvasgl.CanvasGL;
import com.chillingvan.canvasgl.ICanvasGL;
import com.chillingvan.canvasgl.OpenGLUtil;
import com.chillingvan.canvasgl.glview.GLView;
import com.chillingvan.canvasgl.glview.texture.BaseGLTextureView;
import com.chillingvan.canvasgl.glview.texture.GLViewRenderer;
import com.chillingvan.canvasgl.util.Loggers;

abstract class BaseGLCanvasTextureView
extends BaseGLTextureView
implements GLViewRenderer {
    private static final String TAG = "BaseGLCanvasTextureView";
    protected ICanvasGL mCanvas;
    private int backgroundColor = 0;

    public BaseGLCanvasTextureView(Context context) {
        super(context);
    }

    public BaseGLCanvasTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseGLCanvasTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        super.init();
        this.setRenderer(this);
    }

    @Override
    public void onSurfaceCreated() {
        Loggers.d(TAG, "onSurfaceCreated: ");
        this.mCanvas = new CanvasGL();
    }

    @Override
    public void onSurfaceChanged(int width, int height) {
        Loggers.d(TAG, "onSurfaceChanged: ");
        this.mCanvas.setSize(width, height);
    }

    @Override
    public void onDrawFrame() {
        this.mCanvas.clearBuffer(this.backgroundColor);
        this.onGLDraw(this.mCanvas);
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.mCanvas != null) {
            this.mCanvas.pause();
        }
    }

    public void clearTextureCache() {
        if (this.mCanvas != null) {
            this.mCanvas.clearBitmapCache();
        }
    }

    @Override
    protected abstract void onGLDraw(ICanvasGL var1);

    public void setRenderBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
    }

    public void getDrawingBitmap(final Rect rect, final GLView.GetDrawingCacheCallback getDrawingCacheCallback) {
        this.queueEvent(new Runnable(){

            @Override
            public void run() {
                BaseGLCanvasTextureView.this.onDrawFrame();
                BaseGLCanvasTextureView.this.onDrawFrame();
                final Bitmap bitmapFromGLSurface = OpenGLUtil.createBitmapFromGLSurface(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, BaseGLCanvasTextureView.this.getHeight());
                BaseGLCanvasTextureView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        getDrawingCacheCallback.onFetch(bitmapFromGLSurface);
                    }
                });
            }
        });
        this.requestRender();
    }
}

