/*
 * Decompiled with CFR 0.152.
 */
package believe.cht.fadeintextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import believe.cht.fadeintextview.Letter;
import believe.cht.fadeintextview.R;
import believe.cht.fadeintextview.TextViewListener;

public class TextView
extends AppCompatTextView {
    private long start;
    private long letterDuration;
    private boolean isAnimating = false;
    private Interpolator mInterpolator;
    private CharSequence charSequence;
    private SpannableString spannableString;
    TextViewListener textViewListener;

    public TextView(Context context) {
        super(context);
        this.init();
    }

    public TextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init() {
        this.mInterpolator = new DecelerateInterpolator();
        this.letterDuration = 250L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.mInterpolator = new DecelerateInterpolator();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextView);
        try {
            this.letterDuration = typedArray.getInteger(R.styleable.TextView_letterDuration, 120);
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setLetterDuration(long letterDuration) {
        this.letterDuration = letterDuration;
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        Letter[] letters;
        this.charSequence = text;
        this.spannableString = new SpannableString(text);
        for (Letter letter : letters = (Letter[])this.spannableString.getSpans(0, this.spannableString.length(), Letter.class)) {
            this.spannableString.removeSpan((Object)letter);
        }
        int length = this.spannableString.length();
        if (this.textViewListener != null) {
            this.textViewListener.onTextStart();
        }
        for (int i = 0; i < length; ++i) {
            this.spannableString.setSpan((Object)new Letter(), i, i + 1, 17);
        }
        super.setText((CharSequence)this.spannableString, TextView.BufferType.SPANNABLE);
        this.isAnimating = true;
        this.start = AnimationUtils.currentAnimationTimeMillis();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getText() {
        return this.charSequence;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isAnimating) {
            long mDelta = AnimationUtils.currentAnimationTimeMillis() - this.start;
            Letter[] letters = (Letter[])this.spannableString.getSpans(0, this.spannableString.length(), Letter.class);
            int length = letters.length;
            for (int i = 0; i < length; ++i) {
                Letter letter = letters[i];
                float delta = Math.max(Math.min(mDelta - (long)i * this.letterDuration, this.letterDuration), 0L);
                letter.setAlpha(this.mInterpolator.getInterpolation(delta / (float)this.letterDuration));
            }
            if (mDelta < this.letterDuration * (long)length) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            } else {
                this.isAnimating = false;
                if (this.textViewListener != null) {
                    this.textViewListener.onTextFinish();
                }
            }
        }
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    public void setListener(TextViewListener textViewListener) {
        this.textViewListener = textViewListener;
    }
}

