/*
 * Decompiled with CFR 0.152.
 */
package cn.carbs.android.gregorianlunarcalendar.library.data;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class ChineseCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 8L;
    public static final int CHINESE_YEAR = 801;
    public static final int CHINESE_MONTH = 802;
    public static final int CHINESE_DATE = 803;
    public static final int CHINESE_SECTIONAL_TERM = 804;
    public static final int CHINESE_PRINCIPLE_TERM = 805;
    public static final int CHINESE_HEAVENLY_STEM = 806;
    public static final int CHINESE_EARTHLY_BRANCH = 807;
    public static final int CHINESE_ZODIAC = 808;
    public static final int CHINESE_TERM_OR_DATE = 888;
    private int chineseYear;
    private int chineseMonth;
    private int chineseDate;
    private int sectionalTerm;
    private int principleTerm;
    private boolean areChineseFieldsComputed;
    private boolean areSolarTermsComputed;
    private boolean lastSetChinese;
    private static final int baseYear = 1901;
    private static final int baseMonth = 1;
    private static final int baseDate = 1;
    private static final int baseIndex = 0;
    private static final int baseChineseYear = 1900;
    private static final int baseChineseMonth = 11;
    private static final int baseChineseDate = 11;
    private static final String[] chineseWeekNames = new String[]{"", "\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final String[] chineseMonthNames = new String[]{"", "\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    private static final String[] chineseDateNames = new String[]{"", "\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    private static final String[] principleTermNames = new String[]{"\u5927\u5bd2", "\u96e8\u6c34", "\u6625\u5206", "\u8c37\u96e8", "\u590f\u6ee1", "\u590f\u81f3", "\u5927\u6691", "\u5904\u6691", "\u79cb\u5206", "\u971c\u964d", "\u5c0f\u96ea", "\u51ac\u81f3"};
    private static final String[] sectionalTermNames = new String[]{"\u5c0f\u5bd2", "\u7acb\u6625", "\u60ca\u86f0", "\u6e05\u660e", "\u7acb\u590f", "\u8292\u79cd", "\u5c0f\u6691", "\u7acb\u79cb", "\u767d\u9732", "\u5bd2\u9732", "\u7acb\u51ac", "\u5927\u96ea"};
    private static final String[] stemNames = new String[]{"", "\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] branchNames = new String[]{"", "\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] animalNames = new String[]{"", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final int[] bigLeapMonthYears = new int[]{6, 14, 19, 25, 33, 36, 38, 41, 44, 52, 55, 79, 117, 136, 147, 150, 155, 158, 185, 193};
    private static final char[][] sectionalTermMap = new char[][]{{'\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005'}, {'\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0004', '\u0004', '\u0005', '\u0005', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0003', '\u0004', '\u0004', '\u0004', '\u0003', '\u0003', '\u0004', '\u0004', '\u0003', '\u0003', '\u0003'}, {'\u0006', '\u0006', '\u0006', '\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0005'}, {'\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0004', '\u0004', '\u0005', '\u0005', '\u0004', '\u0004', '\u0004', '\u0005', '\u0004', '\u0004', '\u0004', '\u0004', '\u0005'}, {'\u0006', '\u0006', '\u0006', '\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0005'}, {'\u0006', '\u0006', '\u0007', '\u0007', '\u0006', '\u0006', '\u0006', '\u0007', '\u0006', '\u0006', '\u0006', '\u0006', '\u0005', '\u0006', '\u0006', '\u0006', '\u0005', '\u0005', '\u0006', '\u0006', '\u0005', '\u0005', '\u0005', '\u0006', '\u0005', '\u0005', '\u0005', '\u0005', '\u0004', '\u0005', '\u0005', '\u0005', '\u0005'}, {'\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0006', '\u0006', '\u0006', '\u0007', '\u0007'}, {'\b', '\b', '\b', '\t', '\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0007'}, {'\b', '\b', '\b', '\t', '\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0007'}, {'\t', '\t', '\t', '\t', '\b', '\t', '\t', '\t', '\b', '\b', '\t', '\t', '\b', '\b', '\b', '\t', '\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\b'}, {'\b', '\b', '\b', '\b', '\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0007'}, {'\u0007', '\b', '\b', '\b', '\u0007', '\u0007', '\b', '\b', '\u0007', '\u0007', '\u0007', '\b', '\u0007', '\u0007', '\u0007', '\u0007', '\u0006', '\u0007', '\u0007', '\u0007', '\u0006', '\u0006', '\u0007', '\u0007', '\u0006', '\u0006', '\u0006', '\u0007', '\u0007'}};
    private static final char[][] sectionalTermYear = new char[][]{{'\r', '1', 'U', 'u', '\u0095', '\u00b9', '\u00c9', '\u00fa', '\u00fa'}, {'\r', '-', 'Q', 'u', '\u0095', '\u00b9', '\u00c9', '\u00fa', '\u00fa'}, {'\r', '0', 'T', 'p', '\u0094', '\u00b8', '\u00c8', '\u00c9', '\u00fa'}, {'\r', '-', 'L', 'l', '\u008c', '\u00ac', '\u00c8', '\u00c9', '\u00fa'}, {'\r', ',', 'H', 'h', '\u0084', '\u00a8', '\u00c8', '\u00c9', '\u00fa'}, {'\u0005', '!', 'D', '`', '|', '\u0098', '\u00bc', '\u00c8', '\u00c9'}, {'\u001d', '9', 'U', 'x', '\u0094', '\u00b0', '\u00c8', '\u00c9', '\u00fa'}, {'\r', '0', 'L', 'h', '\u0084', '\u00a8', '\u00c4', '\u00c8', '\u00c9'}, {'\u0019', '<', 'X', 'x', '\u0094', '\u00b8', '\u00c8', '\u00c9', '\u00fa'}, {'\u0010', ',', 'L', 'l', '\u0090', '\u00ac', '\u00c8', '\u00c9', '\u00fa'}, {'\u001c', '<', '\\', '|', '\u00a0', '\u00c0', '\u00c8', '\u00c9', '\u00fa'}, {'\u0011', '5', 'U', '|', '\u009c', '\u00bc', '\u00c8', '\u00c9', '\u00fa'}};
    private static final char[][] principleTermMap = new char[][]{{'\u0015', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0014', '\u0013', '\u0014', '\u0014', '\u0014', '\u0013', '\u0013', '\u0014'}, {'\u0014', '\u0013', '\u0013', '\u0014', '\u0014', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0013', '\u0012', '\u0013', '\u0013', '\u0013', '\u0012', '\u0012', '\u0013', '\u0013', '\u0012', '\u0012', '\u0012', '\u0012', '\u0012', '\u0012', '\u0012'}, {'\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0015', '\u0014', '\u0014', '\u0014', '\u0014', '\u0013', '\u0014', '\u0014', '\u0014', '\u0014'}, {'\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0015', '\u0014', '\u0014', '\u0014', '\u0014', '\u0013', '\u0014', '\u0014', '\u0014', '\u0013', '\u0013', '\u0014', '\u0014', '\u0013', '\u0013', '\u0013', '\u0014', '\u0014'}, {'\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0014', '\u0014', '\u0014', '\u0015', '\u0015'}, {'\u0016', '\u0016', '\u0016', '\u0016', '\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0014', '\u0015', '\u0015', '\u0015', '\u0014', '\u0014', '\u0015', '\u0015', '\u0015'}, {'\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0016', '\u0016', '\u0016', '\u0016', '\u0017'}, {'\u0017', '\u0018', '\u0018', '\u0018', '\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0017'}, {'\u0017', '\u0018', '\u0018', '\u0018', '\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0017'}, {'\u0018', '\u0018', '\u0018', '\u0018', '\u0017', '\u0018', '\u0018', '\u0018', '\u0017', '\u0017', '\u0018', '\u0018', '\u0017', '\u0017', '\u0017', '\u0018', '\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0017'}, {'\u0017', '\u0017', '\u0017', '\u0017', '\u0016', '\u0017', '\u0017', '\u0017', '\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0016', '\u0016', '\u0016', '\u0016', '\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0016'}, {'\u0016', '\u0016', '\u0017', '\u0017', '\u0016', '\u0016', '\u0016', '\u0017', '\u0016', '\u0016', '\u0016', '\u0016', '\u0015', '\u0016', '\u0016', '\u0016', '\u0015', '\u0015', '\u0016', '\u0016', '\u0015', '\u0015', '\u0015', '\u0016', '\u0015', '\u0015', '\u0015', '\u0015', '\u0016'}};
    private static final char[][] principleTermYear = new char[][]{{'\r', '-', 'Q', 'q', '\u0095', '\u00b9', '\u00c9'}, {'\u0015', '9', ']', '}', '\u00a1', '\u00c1', '\u00c9'}, {'\u0015', '8', 'X', 'x', '\u0098', '\u00bc', '\u00c8', '\u00c9'}, {'\u0015', '1', 'Q', 't', '\u0090', '\u00b0', '\u00c8', '\u00c9'}, {'\u0011', '1', 'M', 'p', '\u008c', '\u00a8', '\u00c8', '\u00c9'}, {'\u001c', '<', 'X', 't', '\u0094', '\u00b4', '\u00c8', '\u00c9'}, {'\u0019', '5', 'T', 'p', '\u0090', '\u00ac', '\u00c8', '\u00c9'}, {'\u001d', '9', 'Y', 'x', '\u0094', '\u00b4', '\u00c8', '\u00c9'}, {'\u0011', '-', 'I', 'l', '\u008c', '\u00a8', '\u00c8', '\u00c9'}, {'\u001c', '<', '\\', '|', '\u00a0', '\u00c0', '\u00c8', '\u00c9'}, {'\u0010', ',', 'P', 'p', '\u0094', '\u00b4', '\u00c8', '\u00c9'}, {'\u0011', '5', 'X', 'x', '\u009c', '\u00bc', '\u00c8', '\u00c9'}};
    private static final char[] daysInGregorianMonth = new char[]{'\u001f', '\u001c', '\u001f', '\u001e', '\u001f', '\u001e', '\u001f', '\u001f', '\u001e', '\u001f', '\u001e', '\u001f'};
    private static final char[] chineseMonths = new char[]{'\u0000', '\u0004', '\u00ad', '\b', 'Z', '\u0001', '\u00d5', 'T', '\u00b4', '\t', 'd', '\u0005', 'Y', 'E', '\u0095', '\n', '\u00a6', '\u0004', 'U', '$', '\u00ad', '\b', 'Z', 'b', '\u00da', '\u0004', '\u00b4', '\u0005', '\u00b4', 'U', 'R', '\r', '\u0094', '\n', 'J', '*', 'V', '\u0002', 'm', 'q', 'm', '\u0001', '\u00da', '\u0002', '\u00d2', 'R', '\u00a9', '\u0005', 'I', '\r', '*', 'E', '+', '\t', 'V', '\u0001', '\u00b5', ' ', 'm', '\u0001', 'Y', 'i', '\u00d4', '\n', '\u00a8', '\u0005', '\u00a9', 'V', '\u00a5', '\u0004', '+', '\t', '\u009e', '8', '\u00b6', '\b', '\u00ec', 't', 'l', '\u0005', '\u00d4', '\n', '\u00e4', 'j', 'R', '\u0005', '\u0095', '\n', 'Z', 'B', '[', '\u0004', '\u00b6', '\u0004', '\u00b4', '\"', 'j', '\u0005', 'R', 'u', '\u00c9', '\n', 'R', '\u0005', '5', 'U', 'M', '\n', 'Z', '\u0002', ']', '1', '\u00b5', '\u0002', 'j', '\u008a', 'h', '\u0005', '\u00a9', '\n', '\u008a', 'j', '*', '\u0005', '-', '\t', '\u00aa', 'H', 'Z', '\u0001', '\u00b5', '\t', '\u00b0', '9', 'd', '\u0005', '%', 'u', '\u0095', '\n', '\u0096', '\u0004', 'M', 'T', '\u00ad', '\u0004', '\u00da', '\u0004', '\u00d4', 'D', '\u00b4', '\u0005', 'T', '\u0085', 'R', '\r', '\u0092', '\n', 'V', 'j', 'V', '\u0002', 'm', '\u0002', 'j', 'A', '\u00da', '\u0002', '\u00b2', '\u00a1', '\u00a9', '\u0005', 'I', '\r', '\n', 'm', '*', '\t', 'V', '\u0001', '\u00ad', 'P', 'm', '\u0001', '\u00d9', '\u0002', '\u00d1', ':', '\u00a8', '\u0005', ')', '\u0085', '\u00a5', '\f', '*', '\t', '\u0096', 'T', '\u00b6', '\b', 'l', '\t', 'd', 'E', '\u00d4', '\n', '\u00a4', '\u0005', 'Q', '%', '\u0095', '\n', '*', 'r', '[', '\u0004', '\u00b6', '\u0004', '\u00ac', 'R', 'j', '\u0005', '\u00d2', '\n', '\u00a2', 'J', 'J', '\u0005', 'U', '\u0094', '-', '\n', 'Z', '\u0002', 'u', 'a', '\u00b5', '\u0002', 'j', '\u0003', 'a', 'E', '\u00a9', '\n', 'J', '\u0005', '%', '%', '-', '\t', '\u009a', 'h', '\u00da', '\b', '\u00b4', '\t', '\u00a8', 'Y', 'T', '\u0003', '\u00a5', '\n', '\u0091', ':', '\u0096', '\u0004', '\u00ad', '\u00b0', '\u00ad', '\u0004', '\u00da', '\u0004', '\u00f4', 'b', '\u00b4', '\u0005', 'T', '\u000b', 'D', ']', 'R', '\n', '\u0095', '\u0004', 'U', '\"', 'm', '\u0002', 'Z', 'q', '\u00da', '\u0002', '\u00aa', '\u0005', '\u00b2', 'U', 'I', '\u000b', 'J', '\n', '-', '9', '6', '\u0001', 'm', '\u0080', 'm', '\u0001', '\u00d9', '\u0002', '\u00e9', 'j', '\u00a8', '\u0005', ')', '\u000b', '\u009a', 'L', '\u00aa', '\b', '\u00b6', '\b', '\u00b4', '8', 'l', '\t', 'T', 'u', '\u00d4', '\n', '\u00a4', '\u0005', 'E', 'U', '\u0095', '\n', '\u009a', '\u0004', 'U', 'D', '\u00b5', '\u0004', 'j', '\u0082', 'j', '\u0005', '\u00d2', '\n', '\u0092', 'j', 'J', '\u0005', 'U', '\n', '*', 'J', 'Z', '\u0002', '\u00b5', '\u0002', '\u00b2', '1', 'i', '\u0003', '1', 's', '\u00a9', '\n', 'J', '\u0005', '-', 'U', '-', '\t', 'Z', '\u0001', '\u00d5', 'H', '\u00b4', '\t', 'h', '\u0089', 'T', '\u000b', '\u00a4', '\n', '\u00a5', 'j', '\u0095', '\u0004', '\u00ad', '\b', 'j', 'D', '\u00da', '\u0004', 't', '\u0005', '\u00b0', '%', 'T', '\u0003'};

    public ChineseCalendar() {
    }

    public ChineseCalendar(Date d) {
        super.setTime(d);
    }

    public ChineseCalendar(Calendar c) {
        this(c.getTime());
    }

    public ChineseCalendar(int y, int m, int d) {
        super(y, m, d);
    }

    public ChineseCalendar(boolean isChinese, int y, int m, int d) {
        if (isChinese) {
            this.set(801, y);
            this.set(802, m);
            this.set(803, d);
        } else {
            this.set(y, m, d);
        }
    }

    @Override
    public void set(int field, int value) {
        this.computeIfNeed(field);
        if (this.isChineseField(field)) {
            switch (field) {
                case 801: {
                    this.chineseYear = value;
                    break;
                }
                case 802: {
                    this.chineseMonth = value;
                    break;
                }
                case 803: {
                    this.chineseDate = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("field not supported, field : " + field);
                }
            }
            this.lastSetChinese = true;
        } else {
            super.set(field, value);
            this.lastSetChinese = false;
        }
        this.areFieldsSet = false;
        this.areChineseFieldsComputed = false;
        this.areSolarTermsComputed = false;
    }

    @Override
    public int get(int field) {
        this.computeIfNeed(field);
        if (!this.isChineseField(field)) {
            return super.get(field);
        }
        switch (field) {
            case 801: {
                return this.chineseYear;
            }
            case 802: {
                return this.chineseMonth;
            }
            case 803: {
                return this.chineseDate;
            }
            case 804: {
                return this.sectionalTerm;
            }
            case 805: {
                return this.principleTerm;
            }
            case 806: {
                return (this.chineseYear - 4) % 10 + 1;
            }
            case 807: 
            case 808: {
                return (this.chineseYear - 4) % 12 + 1;
            }
            case 888: {
                int option = this.get(5) == this.get(804) ? 804 : (this.get(5) == this.get(805) ? 805 : (this.get(803) == 1 ? 802 : 803));
                return option;
            }
        }
        throw new IllegalArgumentException("field not supported, field : " + field);
    }

    @Override
    public void add(int field, int amount) {
        this.computeIfNeed(field);
        if (!this.isChineseField(field)) {
            super.add(field, amount);
            this.lastSetChinese = false;
            this.areChineseFieldsComputed = false;
            this.areSolarTermsComputed = false;
            return;
        }
        switch (field) {
            case 801: {
                this.chineseYear += amount;
                break;
            }
            case 802: {
                for (int i = 0; i < amount; ++i) {
                    this.chineseMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
                    if (this.chineseMonth != 1) continue;
                    ++this.chineseYear;
                }
                break;
            }
            case 803: {
                int maxDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
                for (int i = 0; i < amount; ++i) {
                    ++this.chineseDate;
                    if (this.chineseDate <= maxDate) continue;
                    this.chineseDate = 1;
                    this.chineseMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
                    if (this.chineseMonth == 1) {
                        ++this.chineseYear;
                    }
                    maxDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
                }
            }
            default: {
                throw new IllegalArgumentException("field not supported, field : " + field);
            }
        }
        this.lastSetChinese = true;
        this.areFieldsSet = false;
        this.areChineseFieldsComputed = false;
        this.areSolarTermsComputed = false;
    }

    @Override
    public void roll(int field, int amount) {
        this.computeIfNeed(field);
        if (!this.isChineseField(field)) {
            super.roll(field, amount);
            this.lastSetChinese = false;
            this.areChineseFieldsComputed = false;
            this.areSolarTermsComputed = false;
            return;
        }
        switch (field) {
            case 801: {
                this.chineseYear += amount;
                break;
            }
            case 802: {
                for (int i = 0; i < amount; ++i) {
                    this.chineseMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
                }
                break;
            }
            case 803: {
                int maxDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
                for (int i = 0; i < amount; ++i) {
                    ++this.chineseDate;
                    if (this.chineseDate <= maxDate) continue;
                    this.chineseDate = 1;
                }
            }
            default: {
                throw new IllegalArgumentException("field not supported, field : " + field);
            }
        }
        this.lastSetChinese = true;
        this.areFieldsSet = false;
        this.areChineseFieldsComputed = false;
        this.areSolarTermsComputed = false;
    }

    public String getChinese(int field) {
        this.computeIfNeed(field);
        switch (field) {
            case 801: {
                return this.getChinese(806) + this.getChinese(807) + "\u5e74";
            }
            case 802: {
                if (this.chineseMonth > 0) {
                    return chineseMonthNames[this.chineseMonth] + "\u6708";
                }
                return "\u95f0" + chineseMonthNames[-this.chineseMonth] + "\u6708";
            }
            case 803: {
                return chineseDateNames[this.chineseDate];
            }
            case 804: {
                return sectionalTermNames[this.get(2)];
            }
            case 805: {
                return principleTermNames[this.get(2)];
            }
            case 806: {
                return stemNames[this.get(field)];
            }
            case 807: {
                return branchNames[this.get(field)];
            }
            case 808: {
                return animalNames[this.get(field)];
            }
            case 7: {
                return chineseWeekNames[this.get(field)];
            }
            case 888: {
                return this.getChinese(this.get(888));
            }
        }
        throw new IllegalArgumentException("field not supported, field : " + field);
    }

    public String getSimpleGregorianDateString() {
        return new StringBuffer().append(this.get(1)).append("-").append(this.get(2) + 1).append("-").append(this.get(5)).toString();
    }

    public String getSimpleChineseDateString() {
        return new StringBuffer().append(this.get(801)).append("-").append(this.get(802) > 0 ? "" + this.get(802) : "*" + -this.get(802)).append("-").append(this.get(803)).toString();
    }

    public String getChineseDateString() {
        return new StringBuffer().append(this.getChinese(801)).append(this.getChinese(802)).append(this.getChinese(803)).toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSimpleGregorianDateString()).append(" | ").append(this.getChinese(7)).append(" | [lunar]").append(this.getChineseDateString()).append(" ").append(this.getChinese(808)).append("year ").append(this.get(804)).append("day").append(this.getChinese(804)).append(" ").append(this.get(805)).append("day").append(this.getChinese(805));
        return buf.toString();
    }

    private boolean isChineseField(int field) {
        switch (field) {
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 888: {
                return true;
            }
        }
        return false;
    }

    private boolean isChineseTermsField(int field) {
        switch (field) {
            case 804: 
            case 805: 
            case 888: {
                return true;
            }
        }
        return false;
    }

    private void computeIfNeed(int field) {
        if (this.isChineseField(field)) {
            if (!this.lastSetChinese && !this.areChineseFieldsComputed) {
                super.complete();
                this.computeChineseFields();
                this.areFieldsSet = true;
                this.areChineseFieldsComputed = true;
                this.areSolarTermsComputed = false;
            }
            if (this.isChineseTermsField(field) && !this.areSolarTermsComputed) {
                this.computeSolarTerms();
                this.areSolarTermsComputed = true;
            }
        } else if (this.lastSetChinese && !this.areFieldsSet) {
            this.computeGregorianFields();
            super.complete();
            this.areFieldsSet = true;
            this.areChineseFieldsComputed = true;
            this.areSolarTermsComputed = false;
        }
    }

    private void computeGregorianFields() {
        int y = this.chineseYear;
        int m = this.chineseMonth;
        int d = this.chineseDate;
        this.areChineseFieldsComputed = true;
        this.areFieldsSet = true;
        this.lastSetChinese = false;
        if (y < 1900) {
            y = 1899;
        } else if (y > 2100) {
            y = 2101;
        }
        if (m < -12) {
            m = -12;
        } else if (m > 12) {
            m = 12;
        }
        if (d < 1) {
            d = 1;
        } else if (d > 30) {
            d = 30;
        }
        int dateint = y * 10000 + Math.abs(m) * 100 + d;
        if (dateint < 19001111) {
            this.set(1901, 0, 1);
            super.complete();
        } else if (dateint > 21001201) {
            this.set(2100, 11, 31);
            super.complete();
        } else {
            int days;
            if (Math.abs(m) > 12) {
                m = 12;
            }
            if ((days = ChineseCalendar.daysInChineseMonth(y, m)) == 0) {
                m = -m;
                days = ChineseCalendar.daysInChineseMonth(y, m);
            }
            if (d > days) {
                d = days;
            }
            this.set(y, Math.abs(m) - 1, d);
            this.computeChineseFields();
            int amount = 0;
            while (this.chineseYear != y || this.chineseMonth != m) {
                amount += ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
                this.chineseMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
                if (this.chineseMonth != 1) continue;
                ++this.chineseYear;
            }
            super.add(5, amount += d - this.chineseDate);
        }
        this.computeChineseFields();
    }

    private void computeChineseFields() {
        int i;
        int startDate;
        int startMonth;
        int startYear;
        int gregorianYear = this.internalGet(1);
        int gregorianMonth = this.internalGet(2) + 1;
        int gregorianDate = this.internalGet(5);
        if (gregorianYear < 1901 || gregorianYear > 2100) {
            return;
        }
        if (gregorianYear < 2000) {
            startYear = 1901;
            startMonth = 1;
            startDate = 1;
            this.chineseYear = 1900;
            this.chineseMonth = 11;
            this.chineseDate = 11;
        } else {
            startYear = 2000;
            startMonth = 1;
            startDate = 1;
            this.chineseYear = 1999;
            this.chineseMonth = 11;
            this.chineseDate = 25;
        }
        int daysDiff = 0;
        for (i = startYear; i < gregorianYear; ++i) {
            if (ChineseCalendar.isGregorianLeapYear(i)) {
                daysDiff += 366;
                continue;
            }
            daysDiff += 365;
        }
        for (i = startMonth; i < gregorianMonth; ++i) {
            daysDiff += ChineseCalendar.daysInGregorianMonth(gregorianYear, i - 1);
        }
        this.chineseDate += (daysDiff += gregorianDate - startDate);
        int lastDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
        while (this.chineseDate > lastDate) {
            this.chineseDate -= lastDate;
            this.chineseMonth = ChineseCalendar.nextChineseMonth(this.chineseYear, this.chineseMonth);
            if (this.chineseMonth == 1) {
                ++this.chineseYear;
            }
            lastDate = ChineseCalendar.daysInChineseMonth(this.chineseYear, this.chineseMonth);
        }
    }

    private void computeSolarTerms() {
        int gregorianYear = this.internalGet(1);
        int gregorianMonth = this.internalGet(2);
        if (gregorianYear < 1901 || gregorianYear > 2100) {
            return;
        }
        this.sectionalTerm = ChineseCalendar.sectionalTerm(gregorianYear, gregorianMonth);
        this.principleTerm = ChineseCalendar.principleTerm(gregorianYear, gregorianMonth);
    }

    public static boolean isGregorianLeapYear(int year) {
        boolean isLeap = false;
        if (year % 4 == 0) {
            isLeap = true;
        }
        if (year % 100 == 0) {
            isLeap = false;
        }
        if (year % 400 == 0) {
            isLeap = true;
        }
        return isLeap;
    }

    public static int daysInGregorianMonth(int y, int m) {
        int d = daysInGregorianMonth[m];
        if (m == 1 && ChineseCalendar.isGregorianLeapYear(y)) {
            ++d;
        }
        return d;
    }

    public static int sectionalTerm(int y, int m) {
        ++m;
        if (y < 1901 || y > 2100) {
            return 0;
        }
        int index = 0;
        int ry = y - 1901 + 1;
        while (ry >= sectionalTermYear[m - 1][index]) {
            ++index;
        }
        int term = sectionalTermMap[m - 1][4 * index + ry % 4];
        if (ry == 121 && m == 4) {
            term = 5;
        }
        if (ry == 132 && m == 4) {
            term = 5;
        }
        if (ry == 194 && m == 6) {
            term = 6;
        }
        return term;
    }

    public static int principleTerm(int y, int m) {
        ++m;
        if (y < 1901 || y > 2100) {
            return 0;
        }
        int index = 0;
        int ry = y - 1901 + 1;
        while (ry >= principleTermYear[m - 1][index]) {
            ++index;
        }
        int term = principleTermMap[m - 1][4 * index + ry % 4];
        if (ry == 171 && m == 3) {
            term = 21;
        }
        if (ry == 181 && m == 5) {
            term = 21;
        }
        return term;
    }

    public static int getMonthLeapByYear(int y) {
        int index = y - 1900 + 0;
        int v = 0;
        v = chineseMonths[2 * index + 1];
        v = v >> 4 & 0xF;
        return -v;
    }

    public static int daysInChineseMonth(int y, int m) {
        int d;
        block4: {
            int v;
            int index;
            block5: {
                int l;
                block3: {
                    index = y - 1900 + 0;
                    v = 0;
                    l = 0;
                    d = 30;
                    if (1 > m || m > 8) break block3;
                    v = chineseMonths[2 * index];
                    l = m - 1;
                    if ((v >> l & 1) != 1) break block4;
                    d = 29;
                    break block4;
                }
                if (9 > m || m > 12) break block5;
                v = chineseMonths[2 * index + 1];
                l = m - 9;
                if ((v >> l & 1) != 1) break block4;
                d = 29;
                break block4;
            }
            v = chineseMonths[2 * index + 1];
            if ((v = v >> 4 & 0xF) != Math.abs(m)) {
                d = 0;
            } else {
                d = 29;
                for (int i = 0; i < bigLeapMonthYears.length; ++i) {
                    if (bigLeapMonthYears[i] != index) continue;
                    d = 30;
                    break;
                }
            }
        }
        return d;
    }

    public static int nextChineseMonth(int y, int m) {
        int n = Math.abs(m) + 1;
        if (m > 0) {
            int index = y - 1900 + 0;
            int v = chineseMonths[2 * index + 1];
            if ((v = v >> 4 & 0xF) == m) {
                n = -m;
            }
        }
        if (n == 13) {
            n = 1;
        }
        return n;
    }
}

