/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.listener.GSYMediaPlayerListener;
import com.shuyu.gsyvideoplayer.listener.VideoAllCallBack;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.NetInfoModule;
import com.shuyu.gsyvideoplayer.video.base.GSYTextureRenderView;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoViewBridge;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public abstract class GSYVideoView
extends GSYTextureRenderView
implements GSYMediaPlayerListener {
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPAREING = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public static final int CHANGE_DELAY_TIME = 2000;
    protected int mCurrentState = -1;
    protected int mPlayPosition = -22;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected int mBufferPoint;
    protected int mBackUpPlayingBufferState = -1;
    protected long mSeekOnStart = -1L;
    protected long mCurrentPosition;
    protected long mSaveChangeViewTIme = 0L;
    protected float mSpeed = 1.0f;
    protected boolean mCache = false;
    protected boolean mIfCurrentIsFullscreen = false;
    protected boolean mLooping = false;
    protected boolean mHadPlay = false;
    protected boolean mNetChanged = false;
    protected boolean mSoundTouch = false;
    protected boolean mShowPauseCover = false;
    protected boolean mPauseBeforePrepared = false;
    protected boolean mStartAfterPrepared = true;
    protected boolean mHadPrepared = false;
    protected boolean mReleaseWhenLossAudio = true;
    protected AudioManager mAudioManager;
    protected String mPlayTag = "";
    protected Context mContext;
    protected String mOriginUrl;
    protected String mUrl;
    protected String mTitle;
    protected String mNetSate = "NORMAL";
    protected String mOverrideExtension;
    protected File mCachePath;
    protected VideoAllCallBack mVideoAllCallBack;
    protected Map<String, String> mMapHeadData = new HashMap<String, String>();
    protected NetInfoModule mNetInfoModule;
    protected AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    GSYVideoView.this.onGankAudio();
                    break;
                }
                case -1: {
                    GSYVideoView.this.onLossAudio();
                    break;
                }
                case -2: {
                    GSYVideoView.this.onLossTransientAudio();
                    break;
                }
                case -3: {
                    GSYVideoView.this.onLossTransientCanDuck();
                }
            }
        }
    };

    public GSYVideoView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GSYVideoView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public GSYVideoView(Context context, Boolean fullFlag) {
        super(context);
        this.mIfCurrentIsFullscreen = fullFlag;
        this.init(context);
    }

    @Override
    protected void showPauseCover() {
        if (this.mCurrentState == 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover && this.mSurface != null && this.mSurface.isValid() && this.getGSYVideoManager().isSurfaceSupportLockCanvas()) {
            try {
                RectF rectF = new RectF(0.0f, 0.0f, (float)this.mTextureView.getWidth(), (float)this.mTextureView.getHeight());
                Canvas canvas = this.mSurface.lockCanvas(new Rect(0, 0, this.mTextureView.getWidth(), this.mTextureView.getHeight()));
                if (canvas != null) {
                    canvas.drawBitmap(this.mFullPauseBitmap, null, rectF, null);
                    this.mSurface.unlockCanvasAndPost(canvas);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void releasePauseCover() {
        try {
            if (this.mCurrentState != 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover) {
                this.mFullPauseBitmap.recycle();
                this.mFullPauseBitmap = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getCurrentVideoWidth() {
        if (this.getGSYVideoManager() != null) {
            return this.getGSYVideoManager().getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getCurrentVideoHeight() {
        if (this.getGSYVideoManager() != null) {
            return this.getGSYVideoManager().getVideoHeight();
        }
        return 0;
    }

    @Override
    public int getVideoSarNum() {
        if (this.getGSYVideoManager() != null) {
            return this.getGSYVideoManager().getVideoSarNum();
        }
        return 0;
    }

    @Override
    public int getVideoSarDen() {
        if (this.getGSYVideoManager() != null) {
            return this.getGSYVideoManager().getVideoSarDen();
        }
        return 0;
    }

    protected void updatePauseCover() {
        if ((this.mFullPauseBitmap == null || this.mFullPauseBitmap.isRecycled()) && this.mShowPauseCover) {
            try {
                this.initCover();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFullPauseBitmap = null;
            }
        }
    }

    protected Context getActivityContext() {
        return CommonUtil.getActivityContext(this.getContext());
    }

    protected void init(Context context) {
        this.mContext = this.getActivityContext() != null ? this.getActivityContext() : context;
        this.initInflate(this.mContext);
        this.mTextureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        if (this.isInEditMode()) {
            return;
        }
        this.mScreenWidth = this.mContext.getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.mContext.getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
    }

    protected void initInflate(Context context) {
        try {
            View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        }
        catch (InflateException e) {
            if (e.toString().contains("GSYImageCover")) {
                Debuger.printfError("********************\n*****   \u6ce8\u610f   *************************\n*\u8be5\u7248\u672c\u9700\u8981\u6e05\u9664\u5e03\u5c40\u6587\u4ef6\u4e2d\u7684GSYImageCover\n****  Attention  ***\n*Please remove GSYImageCover from Layout in this Version\n********************\n");
                e.printStackTrace();
                throw new InflateException("\u8be5\u7248\u672c\u9700\u8981\u6e05\u9664\u5e03\u5c40\u6587\u4ef6\u4e2d\u7684GSYImageCover\uff0cplease remove GSYImageCover from your layout");
            }
            e.printStackTrace();
        }
    }

    protected void startButtonLogic() {
        if (this.mVideoAllCallBack != null && this.mCurrentState == 0) {
            Debuger.printfLog("onClickStartIcon");
            this.mVideoAllCallBack.onClickStartIcon(this.mOriginUrl, this.mTitle, this);
        } else if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onClickStartError");
            this.mVideoAllCallBack.onClickStartError(this.mOriginUrl, this.mTitle, this);
        }
        this.prepareVideo();
    }

    protected void prepareVideo() {
        this.startPrepare();
    }

    protected void startPrepare() {
        if (this.getGSYVideoManager().listener() != null) {
            this.getGSYVideoManager().listener().onCompletion();
        }
        if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onStartPrepared");
            this.mVideoAllCallBack.onStartPrepared(this.mOriginUrl, this.mTitle, this);
        }
        this.getGSYVideoManager().setListener(this);
        this.getGSYVideoManager().setPlayTag(this.mPlayTag);
        this.getGSYVideoManager().setPlayPosition(this.mPlayPosition);
        this.mAudioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 2);
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).getWindow().addFlags(128);
        }
        this.mBackUpPlayingBufferState = -1;
        this.getGSYVideoManager().prepare(this.mUrl, this.mMapHeadData == null ? new HashMap() : this.mMapHeadData, this.mLooping, this.mSpeed, this.mCache, this.mCachePath, this.mOverrideExtension);
        this.setStateAndUi(1);
    }

    protected void onGankAudio() {
    }

    protected void onLossAudio() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoView.this.mReleaseWhenLossAudio) {
                    GSYVideoView.this.releaseVideos();
                } else {
                    GSYVideoView.this.onVideoPause();
                }
            }
        });
    }

    protected void onLossTransientAudio() {
        try {
            this.onVideoPause();
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    protected void onLossTransientCanDuck() {
    }

    public boolean setUp(String url, boolean cacheWithPlay, String title) {
        return this.setUp(url, cacheWithPlay, null, title);
    }

    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, Map<String, String> mapHeadData, String title) {
        if (this.setUp(url, cacheWithPlay, cachePath, title)) {
            if (this.mMapHeadData != null) {
                this.mMapHeadData.clear();
            } else {
                this.mMapHeadData = new HashMap<String, String>();
            }
            if (mapHeadData != null) {
                this.mMapHeadData.putAll(mapHeadData);
            }
            return true;
        }
        return false;
    }

    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, String title) {
        return this.setUp(url, cacheWithPlay, cachePath, title, true);
    }

    protected boolean setUp(String url, boolean cacheWithPlay, File cachePath, String title, boolean changeState) {
        this.mCache = cacheWithPlay;
        this.mCachePath = cachePath;
        this.mOriginUrl = url;
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - this.mSaveChangeViewTIme < 2000L) {
            return false;
        }
        this.mCurrentState = 0;
        this.mUrl = url;
        this.mTitle = title;
        if (changeState) {
            this.setStateAndUi(0);
        }
        return true;
    }

    public void onVideoReset() {
        this.setStateAndUi(0);
    }

    @Override
    public void onVideoPause() {
        if (this.mCurrentState == 1) {
            this.mPauseBeforePrepared = true;
        }
        try {
            if (this.getGSYVideoManager() != null && this.getGSYVideoManager().isPlaying()) {
                this.setStateAndUi(5);
                this.mCurrentPosition = this.getGSYVideoManager().getCurrentPosition();
                if (this.getGSYVideoManager() != null) {
                    this.getGSYVideoManager().pause();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onVideoResume() {
        this.onVideoResume(true);
    }

    @Override
    public void onVideoResume(boolean seek) {
        this.mPauseBeforePrepared = false;
        if (this.mCurrentState == 5) {
            try {
                if (this.mCurrentPosition >= 0L && this.getGSYVideoManager() != null) {
                    if (seek) {
                        this.getGSYVideoManager().seekTo(this.mCurrentPosition);
                    }
                    this.getGSYVideoManager().start();
                    this.setStateAndUi(2);
                    if (this.mAudioManager != null && !this.mReleaseWhenLossAudio) {
                        this.mAudioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 2);
                    }
                    this.mCurrentPosition = 0L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void netWorkErrorLogic() {
        final long currentPosition = this.getCurrentPositionWhenPlaying();
        Debuger.printfError("******* Net State Changed. renew player to connect *******" + currentPosition);
        this.getGSYVideoManager().releaseMediaPlayer();
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSYVideoView.this.setSeekOnStart(currentPosition);
                GSYVideoView.this.startPlayLogic();
            }
        }, 500L);
    }

    protected void deleteCacheFileWhenError() {
        this.clearCurrentCache();
        Debuger.printfError("Link Or mCache Error, Please Try Again " + this.mOriginUrl);
        if (this.mCache) {
            Debuger.printfError("mCache Link " + this.mUrl);
        }
        this.mUrl = this.mOriginUrl;
    }

    @Override
    public void onPrepared() {
        if (this.mCurrentState != 1) {
            return;
        }
        this.mHadPrepared = true;
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            Debuger.printfLog("onPrepared");
            this.mVideoAllCallBack.onPrepared(this.mOriginUrl, this.mTitle, this);
        }
        if (!this.mStartAfterPrepared) {
            this.setStateAndUi(5);
            this.onVideoPause();
            return;
        }
        this.startAfterPrepared();
    }

    @Override
    public void onAutoCompletion() {
        this.setStateAndUi(6);
        this.mSaveChangeViewTIme = 0L;
        this.mCurrentPosition = 0L;
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (!this.mIfCurrentIsFullscreen) {
            this.getGSYVideoManager().setLastListener(null);
        }
        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).getWindow().clearFlags(128);
        }
        this.releaseNetWorkState();
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            Debuger.printfLog("onAutoComplete");
            this.mVideoAllCallBack.onAutoComplete(this.mOriginUrl, this.mTitle, this);
        }
    }

    @Override
    public void onCompletion() {
        this.setStateAndUi(0);
        this.mSaveChangeViewTIme = 0L;
        this.mCurrentPosition = 0L;
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (!this.mIfCurrentIsFullscreen) {
            this.getGSYVideoManager().setListener(null);
            this.getGSYVideoManager().setLastListener(null);
        }
        this.getGSYVideoManager().setCurrentVideoHeight(0);
        this.getGSYVideoManager().setCurrentVideoWidth(0);
        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).getWindow().clearFlags(128);
        }
        this.releaseNetWorkState();
    }

    @Override
    public void onSeekComplete() {
        Debuger.printfLog("onSeekComplete");
    }

    @Override
    public void onError(int what, int extra) {
        if (this.mNetChanged) {
            this.mNetChanged = false;
            this.netWorkErrorLogic();
            if (this.mVideoAllCallBack != null) {
                this.mVideoAllCallBack.onPlayError(this.mOriginUrl, this.mTitle, this);
            }
            return;
        }
        if (what != 38 && what != -38) {
            this.setStateAndUi(7);
            this.deleteCacheFileWhenError();
            if (this.mVideoAllCallBack != null) {
                this.mVideoAllCallBack.onPlayError(this.mOriginUrl, this.mTitle, this);
            }
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        if (what == 701) {
            this.mBackUpPlayingBufferState = this.mCurrentState;
            if (this.mHadPlay && this.mCurrentState != 1 && this.mCurrentState > 0) {
                this.setStateAndUi(3);
            }
        } else if (what == 702) {
            if (this.mBackUpPlayingBufferState != -1) {
                if (this.mBackUpPlayingBufferState == 3) {
                    this.mBackUpPlayingBufferState = 2;
                }
                if (this.mHadPlay && this.mCurrentState != 1 && this.mCurrentState > 0) {
                    this.setStateAndUi(this.mBackUpPlayingBufferState);
                }
                this.mBackUpPlayingBufferState = -1;
            }
        } else if (what == this.getGSYVideoManager().getRotateInfoFlag()) {
            this.mRotate = extra;
            Debuger.printfLog("Video Rotate Info " + extra);
            if (this.mTextureView != null) {
                this.mTextureView.setRotation(this.mRotate);
            }
        }
    }

    @Override
    public void onVideoSizeChanged() {
        int mVideoWidth = this.getGSYVideoManager().getCurrentVideoWidth();
        int mVideoHeight = this.getGSYVideoManager().getCurrentVideoHeight();
        if (mVideoWidth != 0 && mVideoHeight != 0 && this.mTextureView != null) {
            this.mTextureView.requestLayout();
        }
    }

    @Override
    protected void setDisplay(Surface surface) {
        this.getGSYVideoManager().setDisplay(surface);
    }

    @Override
    protected void releaseSurface(Surface surface) {
        this.getGSYVideoManager().releaseSurface(surface);
    }

    public void clearCurrentCache() {
        if (this.getGSYVideoManager().isCacheFile() && this.mCache) {
            Debuger.printfError("Play Error " + this.mUrl);
            this.mUrl = this.mOriginUrl;
            this.getGSYVideoManager().clearCache(this.mContext, this.mCachePath, this.mOriginUrl);
        } else if (this.mUrl.contains("127.0.0.1")) {
            this.getGSYVideoManager().clearCache(this.getContext(), this.mCachePath, this.mOriginUrl);
        }
    }

    public int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (this.mCurrentState == 2 || this.mCurrentState == 5) {
            try {
                position = (int)this.getGSYVideoManager().getCurrentPosition();
            }
            catch (Exception e) {
                e.printStackTrace();
                return position;
            }
        }
        if (position == 0 && this.mCurrentPosition > 0L) {
            return (int)this.mCurrentPosition;
        }
        return position;
    }

    public int getDuration() {
        int duration = 0;
        try {
            duration = (int)this.getGSYVideoManager().getDuration();
        }
        catch (Exception e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    public void release() {
        this.mSaveChangeViewTIme = 0L;
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - this.mSaveChangeViewTIme > 2000L) {
            this.releaseVideos();
        }
    }

    public void startAfterPrepared() {
        if (!this.mHadPrepared) {
            this.prepareVideo();
        }
        try {
            if (this.getGSYVideoManager() != null) {
                this.getGSYVideoManager().start();
            }
            this.setStateAndUi(2);
            if (this.getGSYVideoManager() != null && this.mSeekOnStart > 0L) {
                this.getGSYVideoManager().seekTo(this.mSeekOnStart);
                this.mSeekOnStart = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addTextureView();
        this.createNetWorkState();
        this.listenerNetWorkState();
        this.mHadPlay = true;
        if (this.mTextureView != null) {
            this.mTextureView.onResume();
        }
        if (this.mPauseBeforePrepared) {
            this.onVideoPause();
            this.mPauseBeforePrepared = false;
        }
    }

    protected boolean isCurrentMediaListener() {
        return this.getGSYVideoManager().listener() != null && this.getGSYVideoManager().listener() == this;
    }

    protected void createNetWorkState() {
        if (this.mNetInfoModule == null) {
            this.mNetInfoModule = new NetInfoModule(this.mContext.getApplicationContext(), new NetInfoModule.NetChangeListener(){

                @Override
                public void changed(String state) {
                    if (!GSYVideoView.this.mNetSate.equals(state)) {
                        Debuger.printfError("******* change network state ******* " + state);
                        GSYVideoView.this.mNetChanged = true;
                    }
                    GSYVideoView.this.mNetSate = state;
                }
            });
            this.mNetSate = this.mNetInfoModule.getCurrentConnectionType();
        }
    }

    protected void listenerNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostResume();
        }
    }

    protected void unListenerNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostPause();
        }
    }

    protected void releaseNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostPause();
            this.mNetInfoModule = null;
        }
    }

    protected abstract boolean backFromFull(Context var1);

    protected abstract void releaseVideos();

    protected abstract void setStateAndUi(int var1);

    public abstract GSYVideoViewBridge getGSYVideoManager();

    public abstract int getLayoutId();

    public abstract void startPlayLogic();

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public boolean isInPlayingState() {
        return this.mCurrentState >= 0 && this.mCurrentState != 0 && this.mCurrentState != 6 && this.mCurrentState != 7;
    }

    public String getPlayTag() {
        return this.mPlayTag;
    }

    public void setPlayTag(String playTag) {
        this.mPlayTag = playTag;
    }

    public int getPlayPosition() {
        return this.mPlayPosition;
    }

    public void setPlayPosition(int playPosition) {
        this.mPlayPosition = playPosition;
    }

    public long getNetSpeed() {
        return this.getGSYVideoManager().getNetSpeed();
    }

    public String getNetSpeedText() {
        long speed = this.getNetSpeed();
        return CommonUtil.getTextSpeed(speed);
    }

    public long getSeekOnStart() {
        return this.mSeekOnStart;
    }

    public void setSeekOnStart(long seekOnStart) {
        this.mSeekOnStart = seekOnStart;
    }

    public int getBuffterPoint() {
        return this.mBufferPoint;
    }

    public boolean isIfCurrentIsFullscreen() {
        return this.mIfCurrentIsFullscreen;
    }

    public void setIfCurrentIsFullscreen(boolean ifCurrentIsFullscreen) {
        this.mIfCurrentIsFullscreen = ifCurrentIsFullscreen;
    }

    public boolean isLooping() {
        return this.mLooping;
    }

    public void setLooping(boolean looping) {
        this.mLooping = looping;
    }

    public void setVideoAllCallBack(VideoAllCallBack mVideoAllCallBack) {
        this.mVideoAllCallBack = mVideoAllCallBack;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.setSpeed(speed, false);
    }

    public void setSpeed(float speed, boolean soundTouch) {
        this.mSpeed = speed;
        this.mSoundTouch = soundTouch;
        if (this.getGSYVideoManager() != null) {
            this.getGSYVideoManager().setSpeed(speed, soundTouch);
        }
    }

    public void setSpeedPlaying(float speed, boolean soundTouch) {
        this.setSpeed(speed, soundTouch);
        this.getGSYVideoManager().setSpeedPlaying(speed, soundTouch);
    }

    public boolean isShowPauseCover() {
        return this.mShowPauseCover;
    }

    public void setShowPauseCover(boolean showPauseCover) {
        this.mShowPauseCover = showPauseCover;
    }

    public void seekTo(long position) {
        try {
            if (this.getGSYVideoManager() != null && position > 0L) {
                this.getGSYVideoManager().seekTo(position);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isStartAfterPrepared() {
        return this.mStartAfterPrepared;
    }

    public void setStartAfterPrepared(boolean startAfterPrepared) {
        this.mStartAfterPrepared = startAfterPrepared;
    }

    public boolean isReleaseWhenLossAudio() {
        return this.mReleaseWhenLossAudio;
    }

    public void setReleaseWhenLossAudio(boolean releaseWhenLossAudio) {
        this.mReleaseWhenLossAudio = releaseWhenLossAudio;
    }

    public Map<String, String> getMapHeadData() {
        return this.mMapHeadData;
    }

    public void setMapHeadData(Map<String, String> headData) {
        if (headData != null) {
            this.mMapHeadData = headData;
        }
    }

    public String getOverrideExtension() {
        return this.mOverrideExtension;
    }

    public void setOverrideExtension(String overrideExtension) {
        this.mOverrideExtension = overrideExtension;
    }
}

