/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.shuyu.gsyvideoplayer.GSYRenderView;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;

public abstract class GSYTextureRenderView
extends FrameLayout
implements TextureView.SurfaceTextureListener,
SurfaceHolder.Callback2 {
    protected Surface mSurface;
    protected GSYRenderView mTextureView;
    protected ViewGroup mTextureViewContainer;
    protected Bitmap mFullPauseBitmap;
    protected int mRotate;

    public GSYTextureRenderView(@NonNull Context context) {
        super(context);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYTextureRenderView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        Surface newSurface = new Surface(surface);
        this.pauseLogic(newSurface, true);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GSYVideoManager.instance().setDisplay(null);
        surface.release();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        this.releasePauseCover();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.pauseLogic(holder.getSurface(), false);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        GSYVideoManager.instance().setDisplay(null);
        holder.getSurface().release();
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
    }

    protected void pauseLogic(Surface surface, boolean pauseLogic) {
        this.mSurface = surface;
        if (pauseLogic) {
            this.showPauseCover();
        }
        GSYVideoManager.instance().setDisplay(this.mSurface);
    }

    protected void addTextureView() {
        this.mTextureView = new GSYRenderView();
        if (GSYVideoType.getRenderType() == 1) {
            this.mTextureView.addSurfaceView(this.getContext(), this.mTextureViewContainer, this.mRotate, this);
            return;
        }
        this.mTextureView.addTextureView(this.getContext(), this.mTextureViewContainer, this.mRotate, this);
    }

    protected int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }

    protected void changeTextureViewShowType() {
        int params = this.getTextureParams();
        ViewGroup.LayoutParams layoutParams = this.mTextureView.getLayoutParams();
        layoutParams.width = params;
        layoutParams.height = params;
        this.mTextureView.setLayoutParams(layoutParams);
    }

    protected void initCover() {
        this.mFullPauseBitmap = this.mTextureView.initCover();
    }

    protected void setSmallVideoTextureView(View.OnTouchListener onTouchListener) {
        this.mTextureViewContainer.setOnTouchListener(onTouchListener);
        this.mTextureViewContainer.setOnClickListener(null);
        this.setSmallVideoTextureView();
    }

    protected abstract void showPauseCover();

    protected abstract void releasePauseCover();

    protected abstract void setSmallVideoTextureView();
}

