/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.transition.TransitionManager;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.OrientationOption;
import com.shuyu.gsyvideoplayer.utils.OrientationUtils;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoControlView;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoPlayer;
import com.shuyu.gsyvideoplayer.view.SmallVideoTouch;
import java.lang.reflect.Constructor;

public abstract class GSYBaseVideoPlayer
extends GSYVideoControlView {
    protected int mSystemUiVisibility;
    protected int[] mListItemRect;
    protected int[] mListItemSize;
    protected boolean mActionBar = false;
    protected boolean mStatusBar = false;
    protected boolean mShowFullAnimation = true;
    protected boolean mRotateViewAuto = true;
    protected boolean mRotateWithSystem = true;
    protected boolean mLockLand = false;
    protected boolean mAutoFullWithSize = false;
    protected boolean isNeedAutoAdaptation = false;
    protected boolean mFullAnimEnd = true;
    protected View mSmallClose;
    protected OrientationUtils mOrientationUtils;
    private boolean mIsOnlyRotateLand = false;
    protected View.OnClickListener mBackFromFullScreenListener;
    protected Handler mInnerHandler = new Handler();
    protected Runnable mCheckoutTask = new Runnable(){

        @Override
        public void run() {
            GSYVideoPlayer gsyVideoPlayer = GSYBaseVideoPlayer.this.getFullWindowPlayer();
            if (gsyVideoPlayer != null && gsyVideoPlayer.mCurrentState != GSYBaseVideoPlayer.this.mCurrentState && gsyVideoPlayer.mCurrentState == 3 && GSYBaseVideoPlayer.this.mCurrentState != 1) {
                gsyVideoPlayer.setStateAndUi(GSYBaseVideoPlayer.this.mCurrentState);
            }
        }
    };

    public GSYBaseVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public GSYBaseVideoPlayer(Context context) {
        super(context);
    }

    public GSYBaseVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYBaseVideoPlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.mSmallClose = this.findViewById(R.id.small_close);
    }

    @Override
    public void onBackFullscreen() {
        this.clearFullscreenLayout();
    }

    @Override
    protected void setSmallVideoTextureView() {
        if (this.mProgressBar != null) {
            this.mProgressBar.setOnTouchListener(null);
            this.mProgressBar.setVisibility(4);
        }
        if (this.mFullscreenButton != null) {
            this.mFullscreenButton.setOnTouchListener(null);
            this.mFullscreenButton.setVisibility(4);
        }
        if (this.mCurrentTimeTextView != null) {
            this.mCurrentTimeTextView.setVisibility(4);
        }
        if (this.mTextureViewContainer != null) {
            this.mTextureViewContainer.setOnClickListener(null);
        }
        if (this.mSmallClose != null) {
            this.mSmallClose.setVisibility(0);
            this.mSmallClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYBaseVideoPlayer.this.hideSmallVideo();
                    GSYBaseVideoPlayer.this.releaseVideos();
                }
            });
        }
    }

    @Override
    protected void lockTouchLogic() {
        super.lockTouchLogic();
        if (!this.mLockCurScreen) {
            if (this.mOrientationUtils != null) {
                this.mOrientationUtils.setEnable(this.isRotateViewAuto());
            }
        } else if (this.mOrientationUtils != null) {
            this.mOrientationUtils.setEnable(false);
        }
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
        this.checkAutoFullSizeWhenFull();
    }

    @Override
    public void onInfo(int what, int extra) {
        super.onInfo(what, extra);
        if (what == this.getGSYVideoManager().getRotateInfoFlag()) {
            this.checkAutoFullSizeWhenFull();
        }
    }

    private ViewGroup getViewGroup() {
        return (ViewGroup)CommonUtil.scanForActivity(this.getContext()).findViewById(0x1020002);
    }

    private void removeVideo(ViewGroup vp, int id2) {
        View old = vp.findViewById(id2);
        if (old != null && old.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)old.getParent();
            vp.removeView((View)viewGroup);
        }
    }

    private void saveLocationStatus(Context context, boolean statusBar, boolean actionBar) {
        this.getLocationOnScreen(this.mListItemRect);
        if (context instanceof Activity) {
            int statusBarH = CommonUtil.getStatusBarHeight(context);
            int actionBerH = CommonUtil.getActionBarHeight((Activity)context);
            boolean isTranslucent = (0x4000000 & ((Activity)context).getWindow().getAttributes().flags) == 0x4000000;
            Debuger.printfLog("*************isTranslucent*************** " + isTranslucent);
            if (statusBar && !isTranslucent) {
                this.mListItemRect[1] = this.mListItemRect[1] - statusBarH;
            }
            if (actionBar) {
                this.mListItemRect[1] = this.mListItemRect[1] - actionBerH;
            }
        }
        this.mListItemSize[0] = this.getWidth();
        this.mListItemSize[1] = this.getHeight();
    }

    protected void cloneParams(GSYBaseVideoPlayer from, GSYBaseVideoPlayer to) {
        to.mHadPlay = from.mHadPlay;
        to.mPlayTag = from.mPlayTag;
        to.mPlayPosition = from.mPlayPosition;
        to.mEffectFilter = from.mEffectFilter;
        to.mFullPauseBitmap = from.mFullPauseBitmap;
        to.mNeedShowWifiTip = from.mNeedShowWifiTip;
        to.mShrinkImageRes = from.mShrinkImageRes;
        to.mEnlargeImageRes = from.mEnlargeImageRes;
        to.mRotate = from.mRotate;
        to.mShowPauseCover = from.mShowPauseCover;
        to.mDismissControlTime = from.mDismissControlTime;
        to.mSeekRatio = from.mSeekRatio;
        to.mNetChanged = from.mNetChanged;
        to.mNetSate = from.mNetSate;
        to.mRotateViewAuto = from.mRotateViewAuto;
        to.mRotateWithSystem = from.mRotateWithSystem;
        to.mBackUpPlayingBufferState = from.mBackUpPlayingBufferState;
        to.mRenderer = from.mRenderer;
        to.mMode = from.mMode;
        to.mBackFromFullScreenListener = from.mBackFromFullScreenListener;
        to.mGSYVideoProgressListener = from.mGSYVideoProgressListener;
        to.mHadPrepared = from.mHadPrepared;
        to.mStartAfterPrepared = from.mStartAfterPrepared;
        to.mPauseBeforePrepared = from.mPauseBeforePrepared;
        to.mReleaseWhenLossAudio = from.mReleaseWhenLossAudio;
        to.mVideoAllCallBack = from.mVideoAllCallBack;
        to.mRotateViewAuto = from.mRotateViewAuto;
        to.mActionBar = from.mActionBar;
        to.mStatusBar = from.mStatusBar;
        to.mAutoFullWithSize = from.mAutoFullWithSize;
        to.mOverrideExtension = from.mOverrideExtension;
        if (from.mSetUpLazy) {
            to.setUpLazy(from.mOriginUrl, from.mCache, from.mCachePath, from.mMapHeadData, from.mTitle);
            to.mUrl = from.mUrl;
        } else {
            to.setUp(from.mOriginUrl, from.mCache, from.mCachePath, from.mMapHeadData, from.mTitle);
        }
        to.setLooping(from.isLooping());
        to.setIsTouchWigetFull(from.mIsTouchWigetFull);
        to.setSpeed(from.getSpeed(), from.mSoundTouch);
        to.setStateAndUi(from.mCurrentState);
    }

    private void pauseFullCoverLogic() {
        if (this.mCurrentState == 5 && this.mTextureView != null && (this.mFullPauseBitmap == null || this.mFullPauseBitmap.isRecycled()) && this.mShowPauseCover) {
            try {
                this.initCover();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFullPauseBitmap = null;
            }
        }
    }

    private void pauseFullBackCoverLogic(GSYBaseVideoPlayer gsyVideoPlayer) {
        if (gsyVideoPlayer.mCurrentState == 5 && gsyVideoPlayer.mTextureView != null && this.mShowPauseCover) {
            if (gsyVideoPlayer.mFullPauseBitmap != null && !gsyVideoPlayer.mFullPauseBitmap.isRecycled() && this.mShowPauseCover) {
                this.mFullPauseBitmap = gsyVideoPlayer.mFullPauseBitmap;
            } else if (this.mShowPauseCover) {
                try {
                    this.initCover();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mFullPauseBitmap = null;
                }
            }
        }
    }

    protected void resolveFullVideoShow(Context context, final GSYBaseVideoPlayer gsyVideoPlayer, final FrameLayout frameLayout) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
        lp.setMargins(0, 0, 0, 0);
        lp.height = -1;
        lp.width = -1;
        lp.gravity = 17;
        gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
        gsyVideoPlayer.setIfCurrentIsFullscreen(true);
        this.mOrientationUtils = new OrientationUtils((Activity)context, gsyVideoPlayer, this.getOrientationOption());
        this.mOrientationUtils.setEnable(this.isRotateViewAuto());
        this.mOrientationUtils.setRotateWithSystem(this.mRotateWithSystem);
        this.mOrientationUtils.setOnlyRotateLand(this.mIsOnlyRotateLand);
        gsyVideoPlayer.mOrientationUtils = this.mOrientationUtils;
        final boolean isVertical = this.isVerticalFullByVideoSize();
        final boolean isLockLand = this.isLockLandByAutoFullSize();
        if (this.isShowFullAnimation()) {
            this.mInnerHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!isVertical && isLockLand && GSYBaseVideoPlayer.this.mOrientationUtils != null && GSYBaseVideoPlayer.this.mOrientationUtils.getIsLand() != 1) {
                        GSYBaseVideoPlayer.this.mOrientationUtils.resolveByClick();
                    }
                    gsyVideoPlayer.setVisibility(0);
                    frameLayout.setVisibility(0);
                }
            }, 300L);
        } else {
            if (!isVertical && isLockLand && this.mOrientationUtils != null) {
                this.mOrientationUtils.resolveByClick();
            }
            gsyVideoPlayer.setVisibility(0);
            frameLayout.setVisibility(0);
        }
        if (this.mVideoAllCallBack != null) {
            Debuger.printfError("onEnterFullscreen");
            this.mVideoAllCallBack.onEnterFullscreen(this.mOriginUrl, this.mTitle, gsyVideoPlayer);
        }
        this.mIfCurrentIsFullscreen = true;
        this.checkoutState();
        this.checkAutoFullWithSizeAndAdaptation(gsyVideoPlayer);
    }

    protected void resolveNormalVideoShow(View oldF, ViewGroup vp, GSYVideoPlayer gsyVideoPlayer) {
        if (oldF != null && oldF.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)oldF.getParent();
            vp.removeView((View)viewGroup);
        }
        this.mCurrentState = this.getGSYVideoManager().getLastState();
        if (gsyVideoPlayer != null) {
            this.cloneParams(gsyVideoPlayer, this);
        }
        if (this.mCurrentState != 0 || this.mCurrentState != 6) {
            this.createNetWorkState();
        }
        this.getGSYVideoManager().setListener(this.getGSYVideoManager().lastListener());
        this.getGSYVideoManager().setLastListener(null);
        this.setStateAndUi(this.mCurrentState);
        this.addTextureView();
        this.mSaveChangeViewTIme = System.currentTimeMillis();
        if (this.mVideoAllCallBack != null) {
            Debuger.printfError("onQuitFullscreen");
            this.mVideoAllCallBack.onQuitFullscreen(this.mOriginUrl, this.mTitle, this);
        }
        this.mIfCurrentIsFullscreen = false;
        if (this.mHideKey) {
            CommonUtil.showNavKey(this.mContext, this.mSystemUiVisibility);
        }
        CommonUtil.showSupportActionBar(this.mContext, this.mActionBar, this.mStatusBar);
        if (this.getFullscreenButton() != null) {
            this.getFullscreenButton().setImageResource(this.getEnlargeImageRes());
        }
    }

    protected void clearFullscreenLayout() {
        ViewGroup vp;
        View oldF;
        if (!this.mFullAnimEnd) {
            return;
        }
        this.mIfCurrentIsFullscreen = false;
        int delay = 0;
        if (this.mOrientationUtils != null) {
            delay = this.mOrientationUtils.backToProtVideo();
            this.mOrientationUtils.setEnable(false);
            if (this.mOrientationUtils != null) {
                this.mOrientationUtils.releaseListener();
                this.mOrientationUtils = null;
            }
        }
        if (!this.mShowFullAnimation) {
            delay = 0;
        }
        if ((oldF = (vp = this.getViewGroup()).findViewById(this.getFullId())) != null) {
            GSYVideoPlayer gsyVideoPlayer = (GSYVideoPlayer)oldF;
            gsyVideoPlayer.mIfCurrentIsFullscreen = false;
        }
        this.mInnerHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSYBaseVideoPlayer.this.backToNormal();
            }
        }, (long)delay);
    }

    protected void backToNormal() {
        final ViewGroup vp = this.getViewGroup();
        final View oldF = vp.findViewById(this.getFullId());
        if (oldF != null) {
            final GSYVideoPlayer gsyVideoPlayer = (GSYVideoPlayer)oldF;
            this.pauseFullBackCoverLogic(gsyVideoPlayer);
            if (this.mShowFullAnimation) {
                TransitionManager.beginDelayedTransition((ViewGroup)vp);
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
                lp.setMargins(this.mListItemRect[0], this.mListItemRect[1], 0, 0);
                lp.width = this.mListItemSize[0];
                lp.height = this.mListItemSize[1];
                lp.gravity = 0;
                gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.mInnerHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GSYBaseVideoPlayer.this.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
                    }
                }, 400L);
            } else {
                this.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
            }
        } else {
            this.resolveNormalVideoShow(null, vp, null);
        }
    }

    protected void checkoutState() {
        this.removeCallbacks(this.mCheckoutTask);
        this.mInnerHandler.postDelayed(this.mCheckoutTask, 500L);
    }

    protected boolean isVerticalVideo() {
        boolean isVertical = false;
        int videoHeight = this.getCurrentVideoHeight();
        int videoWidth = this.getCurrentVideoWidth();
        Debuger.printfLog("GSYVideoBase isVerticalVideo  videoHeight " + videoHeight + " videoWidth " + videoWidth);
        Debuger.printfLog("GSYVideoBase isVerticalVideo  mRotate " + this.mRotate);
        if (videoHeight > 0 && videoWidth > 0) {
            isVertical = this.mRotate == 90 || this.mRotate == 270 ? videoWidth > videoHeight : videoHeight > videoWidth;
        }
        return isVertical;
    }

    protected boolean isLockLandByAutoFullSize() {
        boolean isLockLand = this.mLockLand;
        if (this.isAutoFullWithSize()) {
            isLockLand = this.isVerticalVideo();
        }
        return isLockLand;
    }

    protected void checkAutoFullSizeWhenFull() {
        if (this.mIfCurrentIsFullscreen) {
            boolean isV = this.isVerticalFullByVideoSize();
            Debuger.printfLog("GSYVideoBase onPrepared isVerticalFullByVideoSize " + isV);
            if (isV && this.mOrientationUtils != null) {
                this.mOrientationUtils.backToProtVideo();
                this.checkAutoFullWithSizeAndAdaptation(this);
            }
        }
    }

    protected abstract int getFullId();

    protected abstract int getSmallId();

    public boolean isVerticalFullByVideoSize() {
        return this.isVerticalVideo() && this.isAutoFullWithSize();
    }

    public void onConfigurationChanged(Activity activity, Configuration newConfig, OrientationUtils orientationUtils) {
        this.onConfigurationChanged(activity, newConfig, orientationUtils, true, true);
    }

    public void onConfigurationChanged(Activity activity, Configuration newConfig, OrientationUtils orientationUtils, boolean hideActionBar, boolean hideStatusBar) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            if (!this.isIfCurrentIsFullscreen()) {
                this.startWindowFullscreen((Context)activity, hideActionBar, hideStatusBar);
            }
        } else {
            if (this.isIfCurrentIsFullscreen() && !this.isVerticalFullByVideoSize()) {
                this.backFromFull((Context)activity);
            }
            if (orientationUtils != null) {
                orientationUtils.setEnable(true);
            }
        }
    }

    public OrientationOption getOrientationOption() {
        return null;
    }

    public GSYBaseVideoPlayer startWindowFullscreen(final Context context, boolean actionBar, boolean statusBar) {
        this.mSystemUiVisibility = ((Activity)context).getWindow().getDecorView().getSystemUiVisibility();
        CommonUtil.hideSupportActionBar(context, actionBar, statusBar);
        if (this.mHideKey) {
            CommonUtil.hideNavKey(context);
        }
        this.mActionBar = actionBar;
        this.mStatusBar = statusBar;
        this.mListItemRect = new int[2];
        this.mListItemSize = new int[2];
        final ViewGroup vp = this.getViewGroup();
        this.removeVideo(vp, this.getFullId());
        this.pauseFullCoverLogic();
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        this.saveLocationStatus(context, statusBar, actionBar);
        this.cancelProgressTimer();
        boolean hadNewConstructor = true;
        try {
            this.getClass().getConstructor(Context.class, Boolean.class);
        }
        catch (Exception e) {
            hadNewConstructor = false;
        }
        try {
            GSYBaseVideoPlayer gsyVideoPlayer;
            if (!hadNewConstructor) {
                Constructor<?> constructor = this.getClass().getConstructor(Context.class);
                gsyVideoPlayer = (GSYBaseVideoPlayer)constructor.newInstance(this.mContext);
            } else {
                Constructor<?> constructor = this.getClass().getConstructor(Context.class, Boolean.class);
                gsyVideoPlayer = (GSYBaseVideoPlayer)constructor.newInstance(this.mContext, true);
            }
            gsyVideoPlayer.setId(this.getFullId());
            gsyVideoPlayer.setIfCurrentIsFullscreen(true);
            gsyVideoPlayer.setVideoAllCallBack(this.mVideoAllCallBack);
            this.cloneParams(this, gsyVideoPlayer);
            if (gsyVideoPlayer.getFullscreenButton() != null) {
                gsyVideoPlayer.getFullscreenButton().setImageResource(this.getShrinkImageRes());
                gsyVideoPlayer.getFullscreenButton().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GSYBaseVideoPlayer.this.mBackFromFullScreenListener == null) {
                            GSYBaseVideoPlayer.this.clearFullscreenLayout();
                        } else {
                            GSYBaseVideoPlayer.this.mBackFromFullScreenListener.onClick(v);
                        }
                    }
                });
            }
            if (gsyVideoPlayer.getBackButton() != null) {
                gsyVideoPlayer.getBackButton().setVisibility(0);
                gsyVideoPlayer.getBackButton().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (GSYBaseVideoPlayer.this.mBackFromFullScreenListener == null) {
                            GSYBaseVideoPlayer.this.clearFullscreenLayout();
                        } else {
                            GSYBaseVideoPlayer.this.mBackFromFullScreenListener.onClick(v);
                        }
                    }
                });
            }
            FrameLayout.LayoutParams lpParent = new FrameLayout.LayoutParams(-1, -1);
            final FrameLayout frameLayout = new FrameLayout(context);
            frameLayout.setBackgroundColor(-16777216);
            if (this.mShowFullAnimation) {
                this.mFullAnimEnd = false;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.getWidth(), this.getHeight());
                lp.setMargins(this.mListItemRect[0], this.mListItemRect[1], 0, 0);
                frameLayout.addView((View)gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
                vp.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
                this.mInnerHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TransitionManager.beginDelayedTransition((ViewGroup)vp);
                        GSYBaseVideoPlayer.this.resolveFullVideoShow(context, gsyVideoPlayer, frameLayout);
                        GSYBaseVideoPlayer.this.mFullAnimEnd = true;
                    }
                }, 300L);
            } else {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.getWidth(), this.getHeight());
                frameLayout.addView((View)gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
                vp.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
                gsyVideoPlayer.setVisibility(4);
                frameLayout.setVisibility(4);
                this.resolveFullVideoShow(context, gsyVideoPlayer, frameLayout);
            }
            gsyVideoPlayer.addTextureView();
            gsyVideoPlayer.startProgressTimer();
            this.getGSYVideoManager().setLastListener(this);
            this.getGSYVideoManager().setListener(gsyVideoPlayer);
            this.checkoutState();
            return gsyVideoPlayer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GSYBaseVideoPlayer showSmallVideo(Point size, boolean actionBar, boolean statusBar) {
        ViewGroup vp = this.getViewGroup();
        this.removeVideo(vp, this.getSmallId());
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Context.class);
            GSYBaseVideoPlayer gsyVideoPlayer = (GSYBaseVideoPlayer)constructor.newInstance(this.getActivityContext());
            gsyVideoPlayer.setId(this.getSmallId());
            FrameLayout.LayoutParams lpParent = new FrameLayout.LayoutParams(-1, -1);
            FrameLayout frameLayout = new FrameLayout(this.mContext);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(size.x, size.y);
            int marginLeft = CommonUtil.getScreenWidth(this.mContext) - size.x;
            int marginTop = CommonUtil.getScreenHeight(this.mContext) - size.y;
            if (actionBar) {
                marginTop -= CommonUtil.getActionBarHeight((Activity)this.mContext);
            }
            if (statusBar) {
                marginTop -= CommonUtil.getStatusBarHeight(this.mContext);
            }
            lp.setMargins(marginLeft, marginTop, 0, 0);
            frameLayout.addView((View)gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
            vp.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
            this.cloneParams(this, gsyVideoPlayer);
            gsyVideoPlayer.setIsTouchWiget(false);
            gsyVideoPlayer.addTextureView();
            gsyVideoPlayer.onClickUiToggle(null);
            gsyVideoPlayer.setVideoAllCallBack(this.mVideoAllCallBack);
            gsyVideoPlayer.setSmallVideoTextureView(new SmallVideoTouch(gsyVideoPlayer, marginLeft, marginTop));
            this.getGSYVideoManager().setLastListener(this);
            this.getGSYVideoManager().setListener(gsyVideoPlayer);
            if (this.mVideoAllCallBack != null) {
                Debuger.printfError("onEnterSmallWidget");
                this.mVideoAllCallBack.onEnterSmallWidget(this.mOriginUrl, this.mTitle, gsyVideoPlayer);
            }
            return gsyVideoPlayer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void hideSmallVideo() {
        ViewGroup vp = this.getViewGroup();
        GSYVideoPlayer gsyVideoPlayer = (GSYVideoPlayer)vp.findViewById(this.getSmallId());
        this.removeVideo(vp, this.getSmallId());
        this.mCurrentState = this.getGSYVideoManager().getLastState();
        if (gsyVideoPlayer != null) {
            this.cloneParams(gsyVideoPlayer, this);
        }
        this.getGSYVideoManager().setListener(this.getGSYVideoManager().lastListener());
        this.getGSYVideoManager().setLastListener(null);
        this.setStateAndUi(this.mCurrentState);
        this.addTextureView();
        this.mSaveChangeViewTIme = System.currentTimeMillis();
        if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onQuitSmallWidget");
            this.mVideoAllCallBack.onQuitSmallWidget(this.mOriginUrl, this.mTitle, this);
        }
    }

    public boolean isShowFullAnimation() {
        return this.mShowFullAnimation;
    }

    public void setShowFullAnimation(boolean showFullAnimation) {
        this.mShowFullAnimation = showFullAnimation;
    }

    public boolean isRotateViewAuto() {
        if (this.mAutoFullWithSize) {
            return false;
        }
        return this.mRotateViewAuto;
    }

    public void setRotateViewAuto(boolean rotateViewAuto) {
        this.mRotateViewAuto = rotateViewAuto;
        if (this.mOrientationUtils != null) {
            this.mOrientationUtils.setEnable(rotateViewAuto);
        }
    }

    public boolean isLockLand() {
        return this.mLockLand;
    }

    public void setLockLand(boolean lockLand) {
        this.mLockLand = lockLand;
    }

    public boolean isRotateWithSystem() {
        return this.mRotateWithSystem;
    }

    public void setRotateWithSystem(boolean rotateWithSystem) {
        this.mRotateWithSystem = rotateWithSystem;
        if (this.mOrientationUtils != null) {
            this.mOrientationUtils.setRotateWithSystem(rotateWithSystem);
        }
    }

    public GSYVideoPlayer getFullWindowPlayer() {
        ViewGroup vp = (ViewGroup)CommonUtil.scanForActivity(this.getContext()).findViewById(0x1020002);
        View full = vp.findViewById(this.getFullId());
        GSYVideoPlayer gsyVideoPlayer = null;
        if (full != null) {
            gsyVideoPlayer = (GSYVideoPlayer)full;
        }
        return gsyVideoPlayer;
    }

    public GSYVideoPlayer getSmallWindowPlayer() {
        ViewGroup vp = (ViewGroup)CommonUtil.scanForActivity(this.getContext()).findViewById(0x1020002);
        View small = vp.findViewById(this.getSmallId());
        GSYVideoPlayer gsyVideoPlayer = null;
        if (small != null) {
            gsyVideoPlayer = (GSYVideoPlayer)small;
        }
        return gsyVideoPlayer;
    }

    public GSYBaseVideoPlayer getCurrentPlayer() {
        if (this.getFullWindowPlayer() != null) {
            return this.getFullWindowPlayer();
        }
        if (this.getSmallWindowPlayer() != null) {
            return this.getSmallWindowPlayer();
        }
        return this;
    }

    public void setBackFromFullScreenListener(View.OnClickListener backFromFullScreenListener) {
        this.mBackFromFullScreenListener = backFromFullScreenListener;
    }

    public void setFullHideActionBar(boolean actionBar) {
        this.mActionBar = actionBar;
    }

    public void setFullHideStatusBar(boolean statusBar) {
        this.mStatusBar = statusBar;
    }

    public boolean isFullHideActionBar() {
        return this.mActionBar;
    }

    public boolean isFullHideStatusBar() {
        return this.mStatusBar;
    }

    public int getSaveBeforeFullSystemUiVisibility() {
        return this.mSystemUiVisibility;
    }

    public void setSaveBeforeFullSystemUiVisibility(int systemUiVisibility) {
        this.mSystemUiVisibility = systemUiVisibility;
    }

    public boolean isAutoFullWithSize() {
        return this.mAutoFullWithSize;
    }

    public void setAutoFullWithSize(boolean autoFullWithSize) {
        this.mAutoFullWithSize = autoFullWithSize;
    }

    public boolean isNeedAutoAdaptation() {
        return this.isNeedAutoAdaptation;
    }

    public void setNeedAutoAdaptation(boolean needAutoAdaptation) {
        this.isNeedAutoAdaptation = needAutoAdaptation;
    }

    public boolean isOnlyRotateLand() {
        return this.mIsOnlyRotateLand;
    }

    public void setOnlyRotateLand(boolean onlyRotateLand) {
        this.mIsOnlyRotateLand = onlyRotateLand;
        if (this.mOrientationUtils != null) {
            this.mOrientationUtils.setOnlyRotateLand(this.mIsOnlyRotateLand);
        }
    }

    protected void checkAutoFullWithSizeAndAdaptation(final GSYBaseVideoPlayer gsyVideoPlayer) {
        if (gsyVideoPlayer != null && this.isNeedAutoAdaptation && this.isAutoFullWithSize() && this.isVerticalVideo() && this.isFullHideStatusBar()) {
            this.mInnerHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    gsyVideoPlayer.getCurrentPlayer().autoAdaptation();
                }
            }, 100L);
        }
    }

    protected void autoAdaptation() {
        Context context = this.getContext();
        if (this.isVerticalVideo()) {
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            if (location[1] == 0) {
                this.setPadding(0, CommonUtil.getStatusBarHeight(context), 0, 0);
                Debuger.printfLog("\u7ad6\u5c4f\uff0c\u7cfb\u7edf\u672a\u5c06\u5e03\u5c40\u4e0b\u79fb");
            } else {
                Debuger.printfLog("\u7ad6\u5c4f\uff0c\u7cfb\u7edf\u5c06\u5e03\u5c40\u4e0b\u79fb\uff1by:" + location[1]);
            }
        }
    }
}

