/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.player;

import android.content.Context;
import android.net.Uri;
import android.os.Message;
import android.view.Surface;
import com.google.android.exoplayer2.video.DummySurface;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import java.util.List;
import tv.danmaku.ijk.media.exo2.IjkExo2MediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class Exo2PlayerManager
implements IPlayerManager {
    private IjkExo2MediaPlayer mediaPlayer;
    private Surface surface;
    private DummySurface dummySurface;

    @Override
    public IMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    @Override
    public void initVideoPlayer(Context context, Message msg, List<VideoOptionModel> optionModelList, ICacheManager cacheManager) {
        this.mediaPlayer = new IjkExo2MediaPlayer(context);
        this.mediaPlayer.setAudioStreamType(3);
        if (this.dummySurface == null) {
            this.dummySurface = DummySurface.newInstanceV17((Context)context, (boolean)false);
        }
        GSYModel gsyModel = (GSYModel)msg.obj;
        try {
            this.mediaPlayer.setLooping(gsyModel.isLooping());
            this.mediaPlayer.setPreview(gsyModel.getMapHeadData() != null && gsyModel.getMapHeadData().size() > 0);
            if (gsyModel.isCache() && cacheManager != null) {
                cacheManager.doCacheLogic(context, (IMediaPlayer)this.mediaPlayer, gsyModel.getUrl(), gsyModel.getMapHeadData(), gsyModel.getCachePath());
            } else {
                this.mediaPlayer.setCache(gsyModel.isCache());
                this.mediaPlayer.setCacheDir(gsyModel.getCachePath());
                this.mediaPlayer.setDataSource(context, Uri.parse((String)gsyModel.getUrl()), gsyModel.getMapHeadData());
            }
            if (gsyModel.getSpeed() != 1.0f && gsyModel.getSpeed() > 0.0f) {
                this.mediaPlayer.setSpeed(gsyModel.getSpeed(), 1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDisplay(Message msg) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (msg.obj == null) {
            this.mediaPlayer.setSurface((Surface)this.dummySurface);
        } else {
            Surface holder;
            this.surface = holder = (Surface)msg.obj;
            this.mediaPlayer.setSurface(holder);
        }
    }

    @Override
    public void setSpeed(float speed, boolean soundTouch) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.setSpeed(speed, 1.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setNeedMute(boolean needMute) {
        if (this.mediaPlayer != null) {
            if (needMute) {
                this.mediaPlayer.setVolume(0.0f, 0.0f);
            } else {
                this.mediaPlayer.setVolume(1.0f, 1.0f);
            }
        }
    }

    @Override
    public void releaseSurface() {
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setSurface(null);
            this.mediaPlayer.release();
        }
        if (this.dummySurface != null) {
            this.dummySurface.release();
            this.dummySurface = null;
        }
    }

    @Override
    public int getBufferedPercentage() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getBufferedPercentage();
        }
        return 0;
    }

    @Override
    public long getNetSpeed() {
        if (this.mediaPlayer != null) {
            // empty if block
        }
        return 0L;
    }

    @Override
    public void setSpeedPlaying(float speed, boolean soundTouch) {
    }

    @Override
    public void start() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    @Override
    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    @Override
    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoHeight();
        }
        return 0;
    }

    @Override
    public boolean isPlaying() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void seekTo(long time) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(time);
        }
    }

    @Override
    public long getCurrentPosition() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public int getVideoSarNum() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoSarNum();
        }
        return 1;
    }

    @Override
    public int getVideoSarDen() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoSarDen();
        }
        return 1;
    }

    @Override
    public boolean isSurfaceSupportLockCanvas() {
        return false;
    }
}

