/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Util;
import androidx.media3.database.DatabaseProvider;
import androidx.media3.database.StandaloneDatabaseProvider;
import androidx.media3.datasource.AssetDataSource;
import androidx.media3.datasource.DataSink;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.RawResourceDataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.datasource.cache.Cache;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.datasource.cache.CacheEvictor;
import androidx.media3.datasource.cache.CacheKeyFactory;
import androidx.media3.datasource.cache.CacheSpan;
import androidx.media3.datasource.cache.LeastRecentlyUsedCacheEvictor;
import androidx.media3.datasource.cache.SimpleCache;
import androidx.media3.datasource.rtmp.RtmpDataSource;
import androidx.media3.exoplayer.dash.DashChunkSource;
import androidx.media3.exoplayer.dash.DashMediaSource;
import androidx.media3.exoplayer.dash.DefaultDashChunkSource;
import androidx.media3.exoplayer.hls.HlsMediaSource;
import androidx.media3.exoplayer.rtsp.RtspMediaSource;
import androidx.media3.exoplayer.smoothstreaming.DefaultSsChunkSource;
import androidx.media3.exoplayer.smoothstreaming.SsChunkSource;
import androidx.media3.exoplayer.smoothstreaming.SsMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.ExtractorsFactory;
import com.google.common.base.Ascii;
import java.io.File;
import java.util.Map;
import java.util.NavigableSet;
import tv.danmaku.ijk.media.exo2.ExoMediaSourceInterceptListener;

public class ExoSourceManager {
    private static final String TAG = "ExoSourceManager";
    private static final long DEFAULT_MAX_SIZE = 0x20000000L;
    public static final int TYPE_RTMP = 14;
    private static Cache mCache;
    private static String mCachePath;
    @Deprecated
    private static boolean sSkipSSLChain;
    private static int sHttpReadTimeout;
    private static int sHttpConnectTimeout;
    private static boolean isForceRtspTcp;
    private Context mAppContext;
    private Map<String, String> mMapHeadData;
    private String mDataSource;
    private static ExoMediaSourceInterceptListener sExoMediaSourceInterceptListener;
    private static DatabaseProvider sDatabaseProvider;
    private boolean isCached = false;

    public static ExoSourceManager newInstance(Context context, @Nullable Map<String, String> mapHeadData) {
        return new ExoSourceManager(context, mapHeadData);
    }

    private ExoSourceManager(Context context, Map<String, String> mapHeadData) {
        this.mAppContext = context.getApplicationContext();
        this.mMapHeadData = mapHeadData;
    }

    public MediaSource getMediaSource(String dataSource, boolean preview, boolean cacheEnable, boolean isLooping, File cacheDir, @Nullable String overrideExtension) {
        MediaSource mediaSource = null;
        if (sExoMediaSourceInterceptListener != null) {
            mediaSource = sExoMediaSourceInterceptListener.getMediaSource(dataSource, preview, cacheEnable, isLooping, cacheDir);
        }
        if (mediaSource != null) {
            return mediaSource;
        }
        this.mDataSource = dataSource;
        Uri contentUri = Uri.parse((String)dataSource);
        MediaItem mediaItem = MediaItem.fromUri((Uri)contentUri);
        int contentType = ExoSourceManager.inferContentType(dataSource, overrideExtension);
        String uerAgent = null;
        if (this.mMapHeadData != null) {
            uerAgent = this.mMapHeadData.get("User-Agent");
        }
        if ("android.resource".equals(contentUri.getScheme())) {
            DataSpec dataSpec = new DataSpec(contentUri);
            final RawResourceDataSource rawResourceDataSource = new RawResourceDataSource(this.mAppContext);
            try {
                rawResourceDataSource.open(dataSpec);
            }
            catch (RawResourceDataSource.RawResourceDataSourceException e) {
                e.printStackTrace();
            }
            DataSource.Factory factory = new DataSource.Factory(){

                public DataSource createDataSource() {
                    return rawResourceDataSource;
                }
            };
            return new ProgressiveMediaSource.Factory(factory).createMediaSource(mediaItem);
        }
        if ("assets".equals(contentUri.getScheme())) {
            DataSpec dataSpec = new DataSpec(contentUri);
            final AssetDataSource rawResourceDataSource = new AssetDataSource(this.mAppContext);
            try {
                rawResourceDataSource.open(dataSpec);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DataSource.Factory factory = new DataSource.Factory(){

                public DataSource createDataSource() {
                    return rawResourceDataSource;
                }
            };
            return new ProgressiveMediaSource.Factory(factory).createMediaSource(mediaItem);
        }
        switch (contentType) {
            case 1: {
                mediaSource = new SsMediaSource.Factory((SsChunkSource.Factory)new DefaultSsChunkSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent)), (DataSource.Factory)new DefaultDataSource.Factory(this.mAppContext, ExoSourceManager.getHttpDataSourceFactory(this.mAppContext, preview, uerAgent, this.mMapHeadData))).createMediaSource(mediaItem);
                break;
            }
            case 3: {
                RtspMediaSource.Factory rtspFactory = new RtspMediaSource.Factory();
                if (uerAgent != null) {
                    rtspFactory.setUserAgent(uerAgent);
                }
                if (sHttpConnectTimeout > 0) {
                    rtspFactory.setTimeoutMs((long)sHttpConnectTimeout);
                }
                rtspFactory.setForceUseRtpTcp(isForceRtspTcp);
                mediaSource = rtspFactory.createMediaSource(mediaItem);
                break;
            }
            case 0: {
                mediaSource = new DashMediaSource.Factory((DashChunkSource.Factory)new DefaultDashChunkSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent)), (DataSource.Factory)new DefaultDataSource.Factory(this.mAppContext, ExoSourceManager.getHttpDataSourceFactory(this.mAppContext, preview, uerAgent, this.mMapHeadData))).createMediaSource(mediaItem);
                break;
            }
            case 2: {
                mediaSource = new HlsMediaSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent)).setAllowChunklessPreparation(true).createMediaSource(mediaItem);
                break;
            }
            case 14: {
                RtmpDataSource.Factory rtmpDataSourceFactory = new RtmpDataSource.Factory();
                mediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)rtmpDataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(mediaItem);
                break;
            }
            default: {
                mediaSource = new ProgressiveMediaSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir, uerAgent), (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(mediaItem);
            }
        }
        return mediaSource;
    }

    public static void setExoMediaSourceInterceptListener(ExoMediaSourceInterceptListener exoMediaSourceInterceptListener) {
        sExoMediaSourceInterceptListener = exoMediaSourceInterceptListener;
    }

    public static void resetExoMediaSourceInterceptListener() {
        sExoMediaSourceInterceptListener = null;
    }

    public static ExoMediaSourceInterceptListener getExoMediaSourceInterceptListener() {
        return sExoMediaSourceInterceptListener;
    }

    @SuppressLint(value={"WrongConstant"})
    public static int inferContentType(String fileName, @Nullable String overrideExtension) {
        if ((fileName = Ascii.toLowerCase((String)fileName)).startsWith("rtmp:")) {
            return 14;
        }
        return ExoSourceManager.inferContentType(Uri.parse((String)fileName), overrideExtension);
    }

    public static int inferContentType(Uri uri, @Nullable String overrideExtension) {
        return TextUtils.isEmpty((CharSequence)overrideExtension) ? Util.inferContentType((Uri)uri) : Util.inferContentTypeForExtension((String)overrideExtension);
    }

    public static synchronized Cache getCacheSingleInstance(Context context, File cacheDir) {
        boolean isLocked;
        String dirs = context.getCacheDir().getAbsolutePath();
        if (cacheDir != null) {
            dirs = cacheDir.getAbsolutePath();
        }
        if (mCache == null && !(isLocked = SimpleCache.isCacheFolderLocked((File)new File(mCachePath = dirs + File.separator + "exo")))) {
            mCache = new SimpleCache(new File(mCachePath), (CacheEvictor)new LeastRecentlyUsedCacheEvictor(0x20000000L), (DatabaseProvider)(sDatabaseProvider != null ? sDatabaseProvider : new StandaloneDatabaseProvider(context)));
        }
        return mCache;
    }

    public void release() {
        this.isCached = false;
        if (mCache != null) {
            try {
                mCache.release();
                mCache = null;
                mCachePath = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void clearCache(Context context, File cacheDir, String url) {
        try {
            Cache cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir);
            if (!TextUtils.isEmpty((CharSequence)url)) {
                if (cache != null) {
                    ExoSourceManager.removeCache(cache, url);
                }
            } else if (cache != null) {
                for (String key : cache.getKeys()) {
                    ExoSourceManager.removeCache(cache, key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeCache(Cache cache, String url) {
        NavigableSet cachedSpans = cache.getCachedSpans(ExoSourceManager.buildCacheKey(url));
        for (CacheSpan cachedSpan : cachedSpans) {
            try {
                cache.removeSpan(cachedSpan);
            }
            catch (Exception exception) {}
        }
    }

    public static String buildCacheKey(String url) {
        DataSpec dataSpec = new DataSpec(Uri.parse((String)url));
        String key = CacheKeyFactory.DEFAULT.buildCacheKey(dataSpec);
        return key;
    }

    public static boolean cachePreView(Context context, File cacheDir, String url) {
        return ExoSourceManager.resolveCacheState(ExoSourceManager.getCacheSingleInstance(context, cacheDir), url);
    }

    public boolean hadCached() {
        return this.isCached;
    }

    @Deprecated
    public static boolean isSkipSSLChain() {
        return sSkipSSLChain;
    }

    @Deprecated
    public static void setSkipSSLChain(boolean skipSSLChain) {
        sSkipSSLChain = skipSSLChain;
    }

    public static int getHttpReadTimeout() {
        return sHttpReadTimeout;
    }

    public static void setHttpReadTimeout(int httpReadTimeout) {
        sHttpReadTimeout = httpReadTimeout;
    }

    public static int getHttpConnectTimeout() {
        return sHttpConnectTimeout;
    }

    public static void setHttpConnectTimeout(int httpConnectTimeout) {
        sHttpConnectTimeout = httpConnectTimeout;
    }

    public static DatabaseProvider getDatabaseProvider() {
        return sDatabaseProvider;
    }

    public static void setDatabaseProvider(DatabaseProvider databaseProvider) {
        sDatabaseProvider = databaseProvider;
    }

    public static boolean isForceRtspTcp() {
        return isForceRtspTcp;
    }

    public static void setForceRtspTcp(boolean isForceRtspTcp) {
        ExoSourceManager.isForceRtspTcp = isForceRtspTcp;
    }

    private DataSource.Factory getDataSourceFactoryCache(Context context, boolean cacheEnable, boolean preview, File cacheDir, String uerAgent) {
        Cache cache;
        if (cacheEnable && (cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir)) != null) {
            DataSink.Factory cacheSinkFactory = null;
            if (sExoMediaSourceInterceptListener != null) {
                cacheSinkFactory = sExoMediaSourceInterceptListener.cacheWriteDataSinkFactory(mCachePath, this.mDataSource);
            }
            this.isCached = ExoSourceManager.resolveCacheState(cache, this.mDataSource);
            CacheDataSource.Factory factory = new CacheDataSource.Factory();
            CacheDataSource.Factory dataSourceFactory = factory.setCache(cache).setCacheReadDataSourceFactory(ExoSourceManager.getDataSourceFactory(context, preview, uerAgent, this.mMapHeadData)).setFlags(2).setUpstreamDataSourceFactory(ExoSourceManager.getHttpDataSourceFactory(context, preview, uerAgent, this.mMapHeadData));
            if (sExoMediaSourceInterceptListener != null && cacheSinkFactory != null) {
                dataSourceFactory.setCacheWriteDataSinkFactory(cacheSinkFactory);
            }
            return dataSourceFactory;
        }
        return ExoSourceManager.getDataSourceFactory(context, preview, uerAgent, this.mMapHeadData);
    }

    public static DataSource.Factory getDataSourceFactory(Context context, boolean preview, String uerAgent, Map<String, String> mapHeadData) {
        DefaultDataSource.Factory factory = new DefaultDataSource.Factory(context, ExoSourceManager.getHttpDataSourceFactory(context, preview, uerAgent, mapHeadData));
        if (preview) {
            factory.setTransferListener((TransferListener)new DefaultBandwidthMeter.Builder(context).build());
        }
        return factory;
    }

    public static DataSource.Factory getHttpDataSourceFactory(Context context, boolean preview, String uerAgent, Map<String, String> mapHeadData) {
        if (uerAgent == null) {
            uerAgent = Util.getUserAgent((Context)context, (String)TAG);
        }
        int connectTimeout = 8000;
        int readTimeout = 8000;
        if (sHttpConnectTimeout > 0) {
            connectTimeout = sHttpConnectTimeout;
        }
        if (sHttpReadTimeout > 0) {
            readTimeout = sHttpReadTimeout;
        }
        boolean allowCrossProtocolRedirects = false;
        if (mapHeadData != null && mapHeadData.size() > 0) {
            allowCrossProtocolRedirects = "true".equals(mapHeadData.get("allowCrossProtocolRedirects"));
        }
        DataSource.Factory dataSourceFactory = null;
        if (sExoMediaSourceInterceptListener != null) {
            dataSourceFactory = sExoMediaSourceInterceptListener.getHttpDataSourceFactory(uerAgent, (TransferListener)(preview ? null : new DefaultBandwidthMeter.Builder(context.getApplicationContext()).build()), connectTimeout, readTimeout, mapHeadData, allowCrossProtocolRedirects);
        }
        if (dataSourceFactory == null) {
            dataSourceFactory = new DefaultHttpDataSource.Factory().setAllowCrossProtocolRedirects(allowCrossProtocolRedirects).setConnectTimeoutMs(connectTimeout).setReadTimeoutMs(readTimeout).setTransferListener(preview ? null : new DefaultBandwidthMeter.Builder(context.getApplicationContext()).build());
            if (mapHeadData != null && mapHeadData.size() > 0) {
                ((DefaultHttpDataSource.Factory)dataSourceFactory).setDefaultRequestProperties(mapHeadData);
            }
        }
        return dataSourceFactory;
    }

    private static boolean resolveCacheState(Cache cache, String url) {
        boolean isCache = true;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            String key = ExoSourceManager.buildCacheKey(url);
            if (!TextUtils.isEmpty((CharSequence)key)) {
                NavigableSet cachedSpans = cache.getCachedSpans(key);
                if (cachedSpans.size() == 0) {
                    isCache = false;
                } else {
                    long contentLength = cache.getContentMetadata(key).get("exo_len", -1L);
                    long currentLength = 0L;
                    for (CacheSpan cachedSpan : cachedSpans) {
                        currentLength += cache.getCachedLength(key, cachedSpan.position, cachedSpan.length);
                    }
                    isCache = currentLength >= contentLength;
                }
            } else {
                isCache = false;
            }
        }
        return isCache;
    }

    static {
        sSkipSSLChain = false;
        sHttpReadTimeout = -1;
        sHttpConnectTimeout = -1;
        isForceRtspTcp = true;
    }
}

