/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import android.util.Pair;
import androidx.exifinterface.media.ExifInterface;
import com.canhub.cropper.CropException;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.utils.GetUriForFileKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002ghB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0002J(\u0010,\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fH\u0002Jp\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020&2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u000205H\u0002Jx\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020&2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\f2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u0002052\u0006\u00108\u001a\u00020\fH\u0002Jp\u0010/\u001a\u0002002\u0006\u0010%\u001a\u00020&2\b\u00101\u001a\u0004\u0018\u00010$2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\f2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u000205JH\u0010>\u001a\u0002002\b\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u000205JR\u0010@\u001a\u0004\u0018\u00010\u001b2\u0006\u0010?\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u0010A\u001a\u00020B2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u000205H\u0002JD\u0010C\u001a\u0004\u0018\u00010\u001b2\b\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u00102\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u00042\u0006\u00103\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fH\u0002J\"\u0010D\u001a\u0004\u0018\u00010\u001b2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020$2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010J\u001a\u00020I2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020$H\u0002J&\u0010K\u001a\u0002002\u0006\u0010%\u001a\u00020&2\u0006\u0010G\u001a\u00020$2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\fJ8\u0010L\u001a\u0002002\u0006\u0010%\u001a\u00020&2\u0006\u0010G\u001a\u00020$2\u0006\u00109\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u00108\u001a\u00020\fH\u0002J \u0010M\u001a\u00020N2\u0006\u00109\u001a\u00020\u00042\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fH\u0002J\u000e\u0010O\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\u000e\u0010Q\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\u000e\u0010R\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ6\u0010S\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020\f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\fJ\u000e\u0010V\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\u000e\u0010W\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\u000e\u0010X\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\u000e\u0010Y\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\u000e\u0010Z\u001a\u00020B2\u0006\u0010P\u001a\u00020\u000eJ\"\u0010[\u001a\u00020\\2\b\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u0010%\u001a\u00020&2\b\u0010G\u001a\u0004\u0018\u00010$J\u0018\u0010[\u001a\u00020\\2\b\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u0010]\u001a\u00020^J(\u0010_\u001a\u00020\u001b2\b\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010H\u001a\u00020`J(\u0010a\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010b\u001a\u00020\f2\u0006\u0010:\u001a\u0002052\u0006\u0010;\u001a\u000205H\u0002J0\u0010c\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010d\u001a\u00020\f2\b\u0010e\u001a\u0004\u0018\u00010$J$\u0010f\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\b\u0010?\u001a\u0004\u0018\u00010\u001b2\b\u0010e\u001a\u0004\u0018\u00010$R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006i"}, d2={"Lcom/canhub/cropper/BitmapUtils;", "", "()V", "EMPTY_RECT", "Landroid/graphics/Rect;", "getEMPTY_RECT", "()Landroid/graphics/Rect;", "EMPTY_RECT_F", "Landroid/graphics/RectF;", "getEMPTY_RECT_F", "()Landroid/graphics/RectF;", "IMAGE_MAX_BITMAP_DIMENSION", "", "POINTS", "", "getPOINTS", "()[F", "POINTS2", "getPOINTS2", "RECT", "getRECT", "WRITE_AND_TRUNCATE", "", "mMaxTextureSize", "mStateBitmap", "Landroid/util/Pair;", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "getMStateBitmap", "()Landroid/util/Pair;", "setMStateBitmap", "(Landroid/util/Pair;)V", "maxTextureSize", "getMaxTextureSize", "()I", "buildUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "calculateInSampleSizeByMaxTextureSize", "width", "height", "calculateInSampleSizeByRequestedSize", "reqWidth", "reqHeight", "cropBitmap", "Lcom/canhub/cropper/BitmapUtils$BitmapSampled;", "loadedImageUri", "cropPoints", "degreesRotated", "fixAspectRatio", "", "aspectRatioX", "aspectRatioY", "sampleMulti", "rect", "flipHorizontally", "flipVertically", "orgWidth", "orgHeight", "cropBitmapObjectHandleOOM", "bitmap", "cropBitmapObjectWithScale", "scale", "", "cropForRotatedImage", "decodeImage", "resolver", "Landroid/content/ContentResolver;", "uri", "options", "Landroid/graphics/BitmapFactory$Options;", "decodeImageForOption", "decodeSampledBitmap", "decodeSampledBitmapRegion", "fixRectForAspectRatio", "", "getRectBottom", "points", "getRectCenterX", "getRectCenterY", "getRectFromPoints", "imageWidth", "imageHeight", "getRectHeight", "getRectLeft", "getRectRight", "getRectTop", "getRectWidth", "orientateBitmapByExif", "Lcom/canhub/cropper/BitmapUtils$RotateBitmapResult;", "exif", "Landroidx/exifinterface/media/ExifInterface;", "resizeBitmap", "Lcom/canhub/cropper/CropImageView$RequestSizeOptions;", "rotateAndFlipBitmapInt", "degrees", "writeBitmapToUri", "compressQuality", "customOutputUri", "writeTempStateStoreBitmap", "BitmapSampled", "RotateBitmapResult", "cropper_release"})
public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();
    @NotNull
    private static final Rect EMPTY_RECT = new Rect();
    @NotNull
    private static final RectF EMPTY_RECT_F = new RectF();
    private static final int IMAGE_MAX_BITMAP_DIMENSION = 2048;
    @NotNull
    private static final String WRITE_AND_TRUNCATE = "wt";
    @NotNull
    private static final RectF RECT = new RectF();
    @NotNull
    private static final float[] POINTS = new float[6];
    @NotNull
    private static final float[] POINTS2 = new float[6];
    private static int mMaxTextureSize;
    @Nullable
    private static Pair<String, WeakReference<Bitmap>> mStateBitmap;

    private BitmapUtils() {
    }

    @NotNull
    public final Rect getEMPTY_RECT() {
        return EMPTY_RECT;
    }

    @NotNull
    public final RectF getEMPTY_RECT_F() {
        return EMPTY_RECT_F;
    }

    @NotNull
    public final RectF getRECT() {
        return RECT;
    }

    @NotNull
    public final float[] getPOINTS() {
        return POINTS;
    }

    @NotNull
    public final float[] getPOINTS2() {
        return POINTS2;
    }

    @Nullable
    public final Pair<String, WeakReference<Bitmap>> getMStateBitmap() {
        return mStateBitmap;
    }

    public final void setMStateBitmap(@Nullable Pair<String, WeakReference<Bitmap>> pair) {
        mStateBitmap = pair;
    }

    @NotNull
    public final RotateBitmapResult orientateBitmapByExif(@Nullable Bitmap bitmap, @NotNull Context context, @Nullable Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ExifInterface ei = null;
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri2 = uri;
            Intrinsics.checkNotNull((Object)uri2);
            InputStream is = contentResolver.openInputStream(uri2);
            if (is != null) {
                ei = new ExifInterface(is);
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ei != null ? this.orientateBitmapByExif(bitmap, ei) : new RotateBitmapResult(bitmap, 0, false, false, 12, null);
    }

    @NotNull
    public final RotateBitmapResult orientateBitmapByExif(@Nullable Bitmap bitmap, @NotNull ExifInterface exif) {
        int n;
        Intrinsics.checkNotNullParameter((Object)exif, (String)"exif");
        int orientationAttributeInt = exif.getAttributeInt("Orientation", 1);
        switch (orientationAttributeInt) {
            case 5: 
            case 6: 
            case 7: {
                n = 90;
                break;
            }
            case 3: {
                n = 180;
                break;
            }
            case 8: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        int degrees = n;
        boolean flipHorizontally = orientationAttributeInt == 2 || orientationAttributeInt == 5;
        boolean flipVertically = orientationAttributeInt == 4 || orientationAttributeInt == 7;
        return new RotateBitmapResult(bitmap, degrees, flipHorizontally, flipVertically);
    }

    @NotNull
    public final BitmapSampled decodeSampledBitmap(@NotNull Context context, @NotNull Uri uri, int reqWidth, int reqHeight) {
        BitmapSampled bitmapSampled;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            ContentResolver resolver = context.getContentResolver();
            Intrinsics.checkNotNullExpressionValue((Object)resolver, (String)"resolver");
            BitmapFactory.Options options2 = this.decodeImageForOption(resolver, uri);
            if (options2.outWidth == -1 && options2.outHeight == -1) {
                throw new RuntimeException("File is not a picture");
            }
            options2.inSampleSize = Math.max(this.calculateInSampleSizeByRequestedSize(options2.outWidth, options2.outHeight, reqWidth, reqHeight), this.calculateInSampleSizeByMaxTextureSize(options2.outWidth, options2.outHeight));
            Bitmap bitmap = this.decodeImage(resolver, uri, options2);
            bitmapSampled = new BitmapSampled(bitmap, options2.inSampleSize);
        }
        catch (Exception e) {
            throw new CropException.FailedToLoadBitmap(uri, e.getMessage());
        }
        return bitmapSampled;
    }

    @NotNull
    public final BitmapSampled cropBitmapObjectHandleOOM(@Nullable Bitmap bitmap, @NotNull float[] cropPoints, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, boolean flipHorizontally, boolean flipVertically) {
        Intrinsics.checkNotNullParameter((Object)cropPoints, (String)"cropPoints");
        int scale = 1;
        while (true) {
            try {
                Bitmap bitmap2 = bitmap;
                Intrinsics.checkNotNull((Object)bitmap2);
                Bitmap cropBitmap = this.cropBitmapObjectWithScale(bitmap2, cropPoints, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY, 1.0f / (float)scale, flipHorizontally, flipVertically);
                return new BitmapSampled(cropBitmap, scale);
            }
            catch (OutOfMemoryError e) {
                if ((scale *= 2) <= 8) continue;
                throw e;
            }
            break;
        }
    }

    private final Bitmap cropBitmapObjectWithScale(Bitmap bitmap, float[] cropPoints, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, float scale, boolean flipHorizontally, boolean flipVertically) {
        Rect rect = this.getRectFromPoints(cropPoints, bitmap.getWidth(), bitmap.getHeight(), fixAspectRatio, aspectRatioX, aspectRatioY);
        Matrix matrix = new Matrix();
        matrix.setRotate((float)degreesRotated, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
        matrix.postScale(flipHorizontally ? -scale : scale, flipVertically ? -scale : scale);
        Bitmap result = Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height(), (Matrix)matrix, (boolean)true);
        if (Intrinsics.areEqual((Object)result, (Object)bitmap)) {
            result = bitmap.copy(bitmap.getConfig(), false);
        }
        if (degreesRotated % 90 != 0) {
            result = this.cropForRotatedImage(result, cropPoints, rect, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY);
        }
        return result;
    }

    @NotNull
    public final BitmapSampled cropBitmap(@NotNull Context context, @Nullable Uri loadedImageUri, @NotNull float[] cropPoints, int degreesRotated, int orgWidth, int orgHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int reqWidth, int reqHeight, boolean flipHorizontally, boolean flipVertically) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cropPoints, (String)"cropPoints");
        int sampleMulti = 1;
        while (true) {
            try {
                Uri uri = loadedImageUri;
                Intrinsics.checkNotNull((Object)uri);
                return this.cropBitmap(context, uri, cropPoints, degreesRotated, orgWidth, orgHeight, fixAspectRatio, aspectRatioX, aspectRatioY, reqWidth, reqHeight, flipHorizontally, flipVertically, sampleMulti);
            }
            catch (OutOfMemoryError e) {
                if ((sampleMulti *= 2) <= 16) continue;
                throw new RuntimeException("Failed to handle OOM by sampling (" + sampleMulti + "): " + loadedImageUri + "\r\n" + e.getMessage(), e);
            }
            break;
        }
    }

    public final float getRectLeft(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return Math.min(Math.min(Math.min(points[0], points[2]), points[4]), points[6]);
    }

    public final float getRectTop(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return Math.min(Math.min(Math.min(points[1], points[3]), points[5]), points[7]);
    }

    public final float getRectRight(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return Math.max(Math.max(Math.max(points[0], points[2]), points[4]), points[6]);
    }

    public final float getRectBottom(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return Math.max(Math.max(Math.max(points[1], points[3]), points[5]), points[7]);
    }

    public final float getRectWidth(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return this.getRectRight(points) - this.getRectLeft(points);
    }

    public final float getRectHeight(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return this.getRectBottom(points) - this.getRectTop(points);
    }

    public final float getRectCenterX(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return (this.getRectRight(points) + this.getRectLeft(points)) / 2.0f;
    }

    public final float getRectCenterY(@NotNull float[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        return (this.getRectBottom(points) + this.getRectTop(points)) / 2.0f;
    }

    @NotNull
    public final Rect getRectFromPoints(@NotNull float[] cropPoints, int imageWidth, int imageHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        Intrinsics.checkNotNullParameter((Object)cropPoints, (String)"cropPoints");
        int left = MathKt.roundToInt((float)Math.max(0.0f, this.getRectLeft(cropPoints)));
        int top = MathKt.roundToInt((float)Math.max(0.0f, this.getRectTop(cropPoints)));
        int right = MathKt.roundToInt((float)Math.min((float)imageWidth, this.getRectRight(cropPoints)));
        int bottom = MathKt.roundToInt((float)Math.min((float)imageHeight, this.getRectBottom(cropPoints)));
        Rect rect = new Rect(left, top, right, bottom);
        if (fixAspectRatio) {
            this.fixRectForAspectRatio(rect, aspectRatioX, aspectRatioY);
        }
        return rect;
    }

    private final void fixRectForAspectRatio(Rect rect, int aspectRatioX, int aspectRatioY) {
        if (aspectRatioX == aspectRatioY && rect.width() != rect.height()) {
            if (rect.height() > rect.width()) {
                rect.bottom -= rect.height() - rect.width();
            } else {
                rect.right -= rect.width() - rect.height();
            }
        }
    }

    @Nullable
    public final Uri writeTempStateStoreBitmap(@NotNull Context context, @Nullable Bitmap bitmap, @Nullable Uri customOutputUri) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Bitmap bitmap2 = bitmap;
            Intrinsics.checkNotNull((Object)bitmap2);
            uri = this.writeBitmapToUri(context, bitmap2, Bitmap.CompressFormat.JPEG, 95, customOutputUri);
        }
        catch (Exception e) {
            Log.w((String)"AIC", (String)"Failed to write bitmap to temp file for image-cropper save instance state", (Throwable)e);
            uri = null;
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Uri writeBitmapToUri(@NotNull Context context, @NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat compressFormat, int compressQuality, @Nullable Uri customOutputUri) throws FileNotFoundException {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Uri uri2 = customOutputUri;
        if (uri2 == null) {
            uri2 = this.buildUri(context, compressFormat);
        }
        Uri newUri = uri2;
        Closeable closeable = context.getContentResolver().openOutputStream(newUri, WRITE_AND_TRUNCATE);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            bitmap.compress(compressFormat, compressQuality, it);
            uri = newUri;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return uri;
    }

    private final Uri buildUri(Context context, Bitmap.CompressFormat compressFormat) {
        Uri uri;
        try {
            Uri uri2;
            String ext;
            switch (WhenMappings.$EnumSwitchMapping$0[compressFormat.ordinal()]) {
                case 1: {
                    String string = ".jpg";
                    break;
                }
                case 2: {
                    String string = ".png";
                    break;
                }
                default: {
                    String string = ext = ".webp";
                }
            }
            if (Build.VERSION.SDK_INT >= 29) {
                Uri uri3;
                try {
                    File file = File.createTempFile("cropped", ext, context.getExternalFilesDir(Environment.DIRECTORY_PICTURES));
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    uri3 = GetUriForFileKt.getUriForFile(context, file);
                }
                catch (Exception e) {
                    Log.e((String)"AIC", (String)String.valueOf(e.getMessage()));
                    File file = File.createTempFile("cropped", ext, context.getCacheDir());
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    uri3 = GetUriForFileKt.getUriForFile(context, file);
                }
                uri2 = uri3;
            } else {
                uri2 = Uri.fromFile((File)File.createTempFile("cropped", ext, context.getCacheDir()));
            }
            uri = uri2;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"{\n      val ext = when (\u2026.cacheDir))\n      }\n    }");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp file for output image", e);
        }
        return uri;
    }

    @NotNull
    public final Bitmap resizeBitmap(@Nullable Bitmap bitmap, int reqWidth, int reqHeight, @NotNull CropImageView.RequestSizeOptions options2) {
        Intrinsics.checkNotNullParameter((Object)((Object)options2), (String)"options");
        try {
            if (reqWidth > 0 && reqHeight > 0 && (options2 == CropImageView.RequestSizeOptions.RESIZE_FIT || options2 == CropImageView.RequestSizeOptions.RESIZE_INSIDE || options2 == CropImageView.RequestSizeOptions.RESIZE_EXACT)) {
                Bitmap resized = null;
                if (options2 == CropImageView.RequestSizeOptions.RESIZE_EXACT) {
                    Bitmap bitmap2 = bitmap;
                    Intrinsics.checkNotNull((Object)bitmap2);
                    resized = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)reqWidth, (int)reqHeight, (boolean)false);
                } else {
                    Bitmap bitmap3 = bitmap;
                    Intrinsics.checkNotNull((Object)bitmap3);
                    int width = bitmap3.getWidth();
                    int height = bitmap.getHeight();
                    float scale = Math.max((float)width / (float)reqWidth, (float)height / (float)reqHeight);
                    if (scale > 1.0f || options2 == CropImageView.RequestSizeOptions.RESIZE_FIT) {
                        resized = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((float)width / scale)), (int)((int)((float)height / scale)), (boolean)false);
                    }
                }
                if (resized != null) {
                    if (!Intrinsics.areEqual((Object)resized, (Object)bitmap)) {
                        bitmap.recycle();
                    }
                    return resized;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)"AIC", (String)"Failed to resize cropped image, return bitmap before resize", (Throwable)e);
        }
        Bitmap bitmap4 = bitmap;
        Intrinsics.checkNotNull((Object)bitmap4);
        return bitmap4;
    }

    private final BitmapSampled cropBitmap(Context context, Uri loadedImageUri, float[] cropPoints, int degreesRotated, int orgWidth, int orgHeight, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int reqWidth, int reqHeight, boolean flipHorizontally, boolean flipVertically, int sampleMulti) {
        BitmapSampled bitmapSampled;
        Rect rect = this.getRectFromPoints(cropPoints, orgWidth, orgHeight, fixAspectRatio, aspectRatioX, aspectRatioY);
        int width = reqWidth > 0 ? reqWidth : rect.width();
        int height = reqHeight > 0 ? reqHeight : rect.height();
        Bitmap result = null;
        int sampleSize = 1;
        try {
            BitmapSampled bitmapSampled2 = this.decodeSampledBitmapRegion(context, loadedImageUri, rect, width, height, sampleMulti);
            result = bitmapSampled2.getBitmap();
            sampleSize = bitmapSampled2.getSampleSize();
        }
        catch (Exception bitmapSampled2) {
            // empty catch block
        }
        if (result != null) {
            try {
                result = this.rotateAndFlipBitmapInt(result, degreesRotated, flipHorizontally, flipVertically);
                if (degreesRotated % 90 != 0) {
                    result = this.cropForRotatedImage(result, cropPoints, rect, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY);
                }
            }
            catch (OutOfMemoryError e) {
                result.recycle();
                throw e;
            }
            bitmapSampled = new BitmapSampled(result, sampleSize);
        } else {
            bitmapSampled = this.cropBitmap(context, loadedImageUri, cropPoints, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY, sampleMulti, rect, width, height, flipHorizontally, flipVertically);
        }
        return bitmapSampled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BitmapSampled cropBitmap(Context context, Uri loadedImageUri, float[] cropPoints, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, int sampleMulti, Rect rect, int width, int height, boolean flipHorizontally, boolean flipVertically) {
        int sampleSize;
        Bitmap result;
        block9: {
            result = null;
            sampleSize = 0;
            try {
                BitmapFactory.Options options2 = new BitmapFactory.Options();
                options2.inSampleSize = sampleSize = sampleMulti * this.calculateInSampleSizeByRequestedSize(rect.width(), rect.height(), width, height);
                ContentResolver contentResolver = context.getContentResolver();
                Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"context.contentResolver");
                Bitmap fullBitmap = this.decodeImage(contentResolver, loadedImageUri, options2);
                if (fullBitmap == null) break block9;
                try {
                    float[] points2 = new float[cropPoints.length];
                    System.arraycopy(cropPoints, 0, points2, 0, cropPoints.length);
                    int n = points2.length;
                    for (int i = 0; i < n; ++i) {
                        points2[i] = points2[i] / (float)options2.inSampleSize;
                    }
                    result = this.cropBitmapObjectWithScale(fullBitmap, points2, degreesRotated, fixAspectRatio, aspectRatioX, aspectRatioY, 1.0f, flipHorizontally, flipVertically);
                }
                finally {
                    if (!Intrinsics.areEqual((Object)result, (Object)fullBitmap)) {
                        fullBitmap.recycle();
                    }
                }
            }
            catch (OutOfMemoryError e) {
                Bitmap bitmap = result;
                if (bitmap != null) {
                    bitmap.recycle();
                }
                throw e;
            }
            catch (Exception e) {
                throw new CropException.FailedToLoadBitmap(loadedImageUri, e.getMessage());
            }
        }
        return new BitmapSampled(result, sampleSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BitmapFactory.Options decodeImageForOption(ContentResolver resolver, Uri uri) throws FileNotFoundException {
        BitmapFactory.Options options2;
        Closeable closeable = resolver.openInputStream(uri);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            BitmapFactory.Options options3 = new BitmapFactory.Options();
            options3.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)it, (Rect)EMPTY_RECT, (BitmapFactory.Options)options3);
            options3.inJustDecodeBounds = false;
            options2 = options3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return options2;
    }

    /*
     * Exception decompiling
     */
    private final Bitmap decodeImage(ContentResolver resolver, Uri uri, BitmapFactory.Options options) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final BitmapSampled decodeSampledBitmapRegion(Context context, Uri uri, Rect rect, int reqWidth, int reqHeight, int sampleMulti) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Bitmap cropForRotatedImage(Bitmap bitmap, float[] cropPoints, Rect rect, int degreesRotated, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        block5: {
            tempBitmap = bitmap;
            if (degreesRotated % 90 == 0) break block5;
            adjLeft = 0;
            adjTop = 0;
            width = 0;
            height = 0;
            rads = Math.toRadians(degreesRotated);
            if (degreesRotated < 90) ** GOTO lbl-1000
            v0 = 181 <= degreesRotated ? degreesRotated < 270 : false;
            if (v0) lbl-1000:
            // 2 sources

            {
                v1 = rect.left;
            } else {
                v1 = rect.right;
            }
            compareTo = v1;
            for (i = 0; i < cropPoints.length; i += 2) {
                if (!(cropPoints[i] >= (float)(compareTo - 1)) || !(cropPoints[i] <= (float)(compareTo + 1))) continue;
                adjLeft = (int)Math.abs(Math.sin(rads) * (double)((float)rect.bottom - cropPoints[i + 1]));
                adjTop = (int)Math.abs(Math.cos(rads) * (double)(cropPoints[i + 1] - (float)rect.top));
                width = (int)Math.abs((double)(cropPoints[i + 1] - (float)rect.top) / Math.sin(rads));
                height = (int)Math.abs((double)((float)rect.bottom - cropPoints[i + 1]) / Math.cos(rads));
                break;
            }
            rect.set(adjLeft, adjTop, adjLeft + width, adjTop + height);
            if (fixAspectRatio) {
                this.fixRectForAspectRatio(rect, aspectRatioX, aspectRatioY);
            }
            bitmapTmp = tempBitmap;
            v2 = bitmap;
            Intrinsics.checkNotNull((Object)v2);
            tempBitmap = Bitmap.createBitmap((Bitmap)v2, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
            if (Intrinsics.areEqual((Object)bitmapTmp, (Object)tempBitmap)) break block5;
            v3 = bitmapTmp;
            if (v3 != null) {
                v3.recycle();
            }
        }
        return tempBitmap;
    }

    private final int calculateInSampleSizeByRequestedSize(int width, int height, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            while (height / 2 / inSampleSize > reqHeight && width / 2 / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private final int calculateInSampleSizeByMaxTextureSize(int width, int height) {
        int inSampleSize = 1;
        if (mMaxTextureSize == 0) {
            mMaxTextureSize = this.getMaxTextureSize();
        }
        if (mMaxTextureSize > 0) {
            while (height / inSampleSize > mMaxTextureSize || width / inSampleSize > mMaxTextureSize) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private final Bitmap rotateAndFlipBitmapInt(Bitmap bitmap, int degrees, boolean flipHorizontally, boolean flipVertically) {
        Bitmap bitmap2;
        if (degrees > 0 || flipHorizontally || flipVertically) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)degrees);
            matrix.postScale((float)(flipHorizontally ? -1 : 1), (float)(flipVertically ? -1 : 1));
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
            if (!Intrinsics.areEqual((Object)newBitmap, (Object)bitmap)) {
                bitmap.recycle();
            }
            Bitmap bitmap3 = newBitmap;
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"{\n      val matrix = Mat\u2026  }\n      newBitmap\n    }");
            bitmap2 = bitmap3;
        } else {
            bitmap2 = bitmap;
        }
        return bitmap2;
    }

    private final int getMaxTextureSize() {
        int n;
        try {
            EGL eGL = EGLContext.getEGL();
            Intrinsics.checkNotNull((Object)eGL, (String)"null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
            EGL10 egl = (EGL10)eGL;
            EGLDisplay display = egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            int[] version = new int[2];
            egl.eglInitialize(display, version);
            int[] totalConfigurations = new int[1];
            egl.eglGetConfigs(display, null, 0, totalConfigurations);
            EGLConfig[] configurationsList = new EGLConfig[totalConfigurations[0]];
            egl.eglGetConfigs(display, configurationsList, totalConfigurations[0], totalConfigurations);
            int[] textureSize = new int[1];
            int maximumTextureSize = 0;
            int n2 = totalConfigurations[0];
            for (int i = 0; i < n2; ++i) {
                egl.eglGetConfigAttrib(display, configurationsList[i], 12332, textureSize);
                if (maximumTextureSize >= textureSize[0]) continue;
                maximumTextureSize = textureSize[0];
            }
            egl.eglTerminate(display);
            n = Math.max(maximumTextureSize, 2048);
        }
        catch (Exception e) {
            n = 2048;
        }
        return n;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/canhub/cropper/BitmapUtils$BitmapSampled;", "", "bitmap", "Landroid/graphics/Bitmap;", "sampleSize", "", "(Landroid/graphics/Bitmap;I)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getSampleSize", "()I", "cropper_release"})
    public static final class BitmapSampled {
        @Nullable
        private final Bitmap bitmap;
        private final int sampleSize;

        public BitmapSampled(@Nullable Bitmap bitmap, int sampleSize) {
            this.bitmap = bitmap;
            this.sampleSize = sampleSize;
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final int getSampleSize() {
            return this.sampleSize;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/canhub/cropper/BitmapUtils$RotateBitmapResult;", "", "bitmap", "Landroid/graphics/Bitmap;", "degrees", "", "flipHorizontally", "", "flipVertically", "(Landroid/graphics/Bitmap;IZZ)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getDegrees", "()I", "getFlipHorizontally", "()Z", "getFlipVertically", "cropper_release"})
    public static final class RotateBitmapResult {
        @Nullable
        private final Bitmap bitmap;
        private final int degrees;
        private final boolean flipHorizontally;
        private final boolean flipVertically;

        public RotateBitmapResult(@Nullable Bitmap bitmap, int degrees, boolean flipHorizontally, boolean flipVertically) {
            this.bitmap = bitmap;
            this.degrees = degrees;
            this.flipHorizontally = flipHorizontally;
            this.flipVertically = flipVertically;
        }

        public /* synthetic */ RotateBitmapResult(Bitmap bitmap, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                bl2 = false;
            }
            this(bitmap, n, bl, bl2);
        }

        @Nullable
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        public final int getDegrees() {
            return this.degrees;
        }

        public final boolean getFlipHorizontally() {
            return this.flipHorizontally;
        }

        public final boolean getFlipVertically() {
            return this.flipVertically;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.CompressFormat.values().length];
            try {
                nArray[Bitmap.CompressFormat.JPEG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.PNG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

