/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.annotation.RequiresApi;
import com.canhub.cropper.BitmapUtils;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.CropWindowHandler;
import com.canhub.cropper.CropWindowMoveHandler;
import com.canhub.cropper.common.CommonVersionCheck;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b0\u0018\u0000 \u00a7\u00012\u00020\u0001:\u0006\u00a7\u0001\u00a8\u0001\u00a9\u0001B\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010]\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u000200H\u0002J\u0010\u0010a\u001a\u00020_2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020_2\u0006\u0010b\u001a\u00020cH\u0002J0\u0010e\u001a\u00020_2\u0006\u0010b\u001a\u00020c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010f\u001a\u00020\u00192\u0006\u0010g\u001a\u00020\u00192\u0006\u0010h\u001a\u00020\u0019H\u0002J(\u0010i\u001a\u00020_2\u0006\u0010b\u001a\u00020c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010f\u001a\u00020\u00192\u0006\u0010g\u001a\u00020\u0019H\u0002J0\u0010j\u001a\u00020_2\u0006\u0010b\u001a\u00020c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010f\u001a\u00020\u00192\u0006\u0010g\u001a\u00020\u00192\u0006\u0010h\u001a\u00020\u0019H\u0002J\u0010\u0010k\u001a\u00020_2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010l\u001a\u00020_2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010m\u001a\u00020_2\u0006\u0010b\u001a\u00020cH\u0002J(\u0010n\u001a\u00020_2\u0006\u0010b\u001a\u00020c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010f\u001a\u00020\u00192\u0006\u0010g\u001a\u00020\u0019H\u0002J\u0010\u0010o\u001a\u00020_2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010p\u001a\u00020_J\b\u0010q\u001a\u00020_H\u0002J\u0018\u0010r\u001a\u00020_2\u0006\u0010s\u001a\u00020\u00192\u0006\u0010t\u001a\u00020\u0019H\u0002J\u0018\u0010u\u001a\u00020_2\u0006\u0010s\u001a\u00020\u00192\u0006\u0010t\u001a\u00020\u0019H\u0002J\b\u0010v\u001a\u00020_H\u0002J\u0010\u0010w\u001a\u00020_2\u0006\u0010b\u001a\u00020cH\u0014J\u0010\u0010x\u001a\u0002002\u0006\u0010y\u001a\u00020zH\u0016J\u0006\u0010{\u001a\u00020_J\u0006\u0010|\u001a\u00020_J!\u0010}\u001a\u00020_2\b\u0010~\u001a\u0004\u0018\u00010>2\u0006\u0010\u007f\u001a\u00020\b2\u0007\u0010\u0080\u0001\u001a\u00020\bJ\u0010\u0010\u0081\u0001\u001a\u0002002\u0007\u0010\u0082\u0001\u001a\u000200J\u0010\u0010\u0083\u0001\u001a\u00020_2\u0007\u0010\u0084\u0001\u001a\u00020\u0019J\u0010\u0010\u0085\u0001\u001a\u00020_2\u0007\u0010\u0086\u0001\u001a\u00020\u0011J\u0012\u0010\u0087\u0001\u001a\u00020_2\t\u0010\u0088\u0001\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0089\u0001\u001a\u00020_2\u0007\u0010\u008a\u0001\u001a\u00020\bJ\u0010\u0010\u008b\u0001\u001a\u00020_2\u0007\u0010\u008c\u0001\u001a\u00020\u0019J\u000f\u0010\u008d\u0001\u001a\u00020_2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0012\u0010\u008e\u0001\u001a\u00020_2\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010EJ+\u0010\u0090\u0001\u001a\u00020_2\u0007\u0010\u0091\u0001\u001a\u00020\u00192\u0007\u0010\u0092\u0001\u001a\u00020\u00192\u0007\u0010\u0093\u0001\u001a\u00020\u00192\u0007\u0010\u0094\u0001\u001a\u00020\u0019J\u0010\u0010\u0095\u0001\u001a\u00020_2\u0007\u0010\u0096\u0001\u001a\u000200J\u0010\u0010\u0097\u0001\u001a\u00020_2\u0007\u0010\u0098\u0001\u001a\u000200J\u000f\u0010\u0099\u0001\u001a\u00020_2\u0006\u0010&\u001a\u00020%J\u0010\u0010\u009a\u0001\u001a\u00020_2\u0007\u0010\u009b\u0001\u001a\u00020PJ\u0019\u0010\u009c\u0001\u001a\u00020_2\u0007\u0010\u009d\u0001\u001a\u00020\b2\u0007\u0010\u009e\u0001\u001a\u00020\bJ\u0019\u0010\u009f\u0001\u001a\u00020_2\u0007\u0010\u00a0\u0001\u001a\u00020\b2\u0007\u0010\u00a1\u0001\u001a\u00020\bJ\u0010\u0010\u00a2\u0001\u001a\u0002002\u0007\u0010\u00a3\u0001\u001a\u000200J\u0010\u0010\u00a4\u0001\u001a\u00020_2\u0007\u0010\u00a5\u0001\u001a\u00020\u0019J\t\u0010\u00a6\u0001\u001a\u00020_H\u0003R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u0010\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R(\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u001e\u001a\u0004\u0018\u00010)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u0002002\u0006\u0010\u0010\u001a\u000200@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00103R\u000e\u00105\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010A\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010BR\u000e\u0010C\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010Q\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010BR\u000e\u0010R\u001a\u00020SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u0004\u0018\u00010UX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\\\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00aa\u0001"}, d2={"Lcom/canhub/cropper/CropOverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "aspectRatioX", "", "getAspectRatioX", "()I", "setAspectRatioX", "(I)V", "aspectRatioY", "getAspectRatioY", "setAspectRatioY", "<set-?>", "Lcom/canhub/cropper/CropImageView$CropCornerShape;", "cornerShape", "getCornerShape", "()Lcom/canhub/cropper/CropImageView$CropCornerShape;", "cropLabelText", "", "cropLabelTextColor", "cropLabelTextSize", "", "Lcom/canhub/cropper/CropImageView$CropShape;", "cropShape", "getCropShape", "()Lcom/canhub/cropper/CropImageView$CropShape;", "rect", "Landroid/graphics/RectF;", "cropWindowRect", "getCropWindowRect", "()Landroid/graphics/RectF;", "setCropWindowRect", "(Landroid/graphics/RectF;)V", "Lcom/canhub/cropper/CropImageView$Guidelines;", "guidelines", "getGuidelines", "()Lcom/canhub/cropper/CropImageView$Guidelines;", "Landroid/graphics/Rect;", "initialCropWindowRect", "getInitialCropWindowRect", "()Landroid/graphics/Rect;", "setInitialCropWindowRect", "(Landroid/graphics/Rect;)V", "initializedCropWindow", "", "isCropLabelEnabled", "isFixAspectRatio", "()Z", "isNonStraightAngleRotated", "mAspectRatioX", "mAspectRatioY", "mBackgroundPaint", "Landroid/graphics/Paint;", "mBorderCornerLength", "mBorderCornerOffset", "mBorderCornerPaint", "mBorderPaint", "mBoundsPoints", "", "mCalcBounds", "mCenterMoveEnabled", "mCircleCornerFillColor", "Ljava/lang/Integer;", "mCropCornerRadius", "mCropWindowChangeListener", "Lcom/canhub/cropper/CropOverlayView$CropWindowChangeListener;", "mCropWindowHandler", "Lcom/canhub/cropper/CropWindowHandler;", "mDrawRect", "mGuidelinePaint", "mInitialCropWindowPaddingRatio", "mInitialCropWindowRect", "mMoveHandler", "Lcom/canhub/cropper/CropWindowMoveHandler;", "mMultiTouchEnabled", "mOptions", "Lcom/canhub/cropper/CropImageOptions;", "mOriginalLayerType", "mPath", "Landroid/graphics/Path;", "mScaleDetector", "Landroid/view/ScaleGestureDetector;", "mSnapRadius", "mTargetAspectRatio", "mTouchRadius", "mViewHeight", "mViewWidth", "maxVerticalGestureExclusion", "textLabelPaint", "calculateBounds", "callOnCropWindowChanged", "", "inProgress", "drawBackground", "canvas", "Landroid/graphics/Canvas;", "drawBorders", "drawCircleShape", "cornerOffset", "cornerExtension", "radius", "drawCornerBasedOnShape", "drawCornerShape", "drawCorners", "drawCropLabelText", "drawGuidelines", "drawLineShape", "fixCropWindowRectByRules", "fixCurrentCropWindowRect", "initCropWindow", "onActionDown", "x", "y", "onActionMove", "onActionUp", "onDraw", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "resetCropOverlayView", "resetCropWindowRect", "setBounds", "boundsPoints", "viewWidth", "viewHeight", "setCenterMoveEnabled", "centerMoveEnabled", "setCropCornerRadius", "cornerRadius", "setCropCornerShape", "cropCornerShape", "setCropLabelText", "textLabel", "setCropLabelTextColor", "textColor", "setCropLabelTextSize", "textSize", "setCropShape", "setCropWindowChangeListener", "listener", "setCropWindowLimits", "maxWidth", "maxHeight", "scaleFactorWidth", "scaleFactorHeight", "setCropperTextLabelVisibility", "isEnabled", "setFixedAspectRatio", "fixAspectRatio", "setGuidelines", "setInitialAttributeValues", "options", "setMaxCropResultSize", "maxCropResultWidth", "maxCropResultHeight", "setMinCropResultSize", "minCropResultWidth", "minCropResultHeight", "setMultiTouchEnabled", "multiTouchEnabled", "setSnapRadius", "snapRadius", "setSystemGestureExclusionRects", "Companion", "CropWindowChangeListener", "ScaleListener", "cropper_release"})
public final class CropOverlayView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float mCropCornerRadius;
    @Nullable
    private Integer mCircleCornerFillColor;
    @Nullable
    private CropImageOptions mOptions;
    @Nullable
    private ScaleGestureDetector mScaleDetector;
    private boolean mMultiTouchEnabled;
    private boolean mCenterMoveEnabled;
    @NotNull
    private final CropWindowHandler mCropWindowHandler;
    @Nullable
    private CropWindowChangeListener mCropWindowChangeListener;
    @NotNull
    private final RectF mDrawRect;
    @Nullable
    private Paint mBorderPaint;
    @Nullable
    private Paint mBorderCornerPaint;
    @Nullable
    private Paint mGuidelinePaint;
    @Nullable
    private Paint mBackgroundPaint;
    @Nullable
    private Paint textLabelPaint;
    @NotNull
    private final Path mPath;
    @NotNull
    private final float[] mBoundsPoints;
    @NotNull
    private final RectF mCalcBounds;
    private int mViewWidth;
    private int mViewHeight;
    private float mBorderCornerOffset;
    private float mBorderCornerLength;
    private float mInitialCropWindowPaddingRatio;
    private float mTouchRadius;
    private float mSnapRadius;
    @Nullable
    private CropWindowMoveHandler mMoveHandler;
    private boolean isFixAspectRatio;
    private int mAspectRatioX;
    private int mAspectRatioY;
    private float mTargetAspectRatio;
    @Nullable
    private CropImageView.Guidelines guidelines;
    @Nullable
    private CropImageView.CropShape cropShape;
    @Nullable
    private CropImageView.CropCornerShape cornerShape;
    private boolean isCropLabelEnabled;
    @NotNull
    private String cropLabelText;
    private float cropLabelTextSize;
    private int cropLabelTextColor;
    @NotNull
    private final Rect mInitialCropWindowRect;
    private boolean initializedCropWindow;
    @Nullable
    private Integer mOriginalLayerType;
    private final float maxVerticalGestureExclusion;

    @JvmOverloads
    public CropOverlayView(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mCenterMoveEnabled = true;
        this.mCropWindowHandler = new CropWindowHandler();
        this.mDrawRect = new RectF();
        this.mPath = new Path();
        this.mBoundsPoints = new float[8];
        this.mCalcBounds = new RectF();
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        this.cropLabelText = "";
        this.cropLabelTextSize = 20.0f;
        this.cropLabelTextColor = -1;
        this.mInitialCropWindowRect = new Rect();
        this.maxVerticalGestureExclusion = TypedValue.applyDimension((int)1, (float)200.0f, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public /* synthetic */ CropOverlayView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    public final boolean isFixAspectRatio() {
        return this.isFixAspectRatio;
    }

    @Nullable
    public final CropImageView.Guidelines getGuidelines() {
        return this.guidelines;
    }

    @Nullable
    public final CropImageView.CropShape getCropShape() {
        return this.cropShape;
    }

    @Nullable
    public final CropImageView.CropCornerShape getCornerShape() {
        return this.cornerShape;
    }

    public final void setCropWindowChangeListener(@Nullable CropWindowChangeListener listener) {
        this.mCropWindowChangeListener = listener;
    }

    @NotNull
    public final RectF getCropWindowRect() {
        return this.mCropWindowHandler.getRect();
    }

    public final void setCropWindowRect(@NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.mCropWindowHandler.setRect(rect);
    }

    public final void fixCurrentCropWindowRect() {
        RectF rect = this.getCropWindowRect();
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    public final void setBounds(@Nullable float[] boundsPoints, int viewWidth, int viewHeight) {
        if (boundsPoints == null || !Arrays.equals(this.mBoundsPoints, boundsPoints)) {
            if (boundsPoints == null) {
                Arrays.fill(this.mBoundsPoints, 0.0f);
            } else {
                System.arraycopy(boundsPoints, 0, this.mBoundsPoints, 0, boundsPoints.length);
            }
            this.mViewWidth = viewWidth;
            this.mViewHeight = viewHeight;
            RectF cropRect = this.mCropWindowHandler.getRect();
            if (cropRect.width() == 0.0f || cropRect.height() == 0.0f) {
                this.initCropWindow();
            }
        }
    }

    public final void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.setCropWindowRect(BitmapUtils.INSTANCE.getEMPTY_RECT_F());
            this.initCropWindow();
            this.invalidate();
        }
    }

    public final void setCropShape(@NotNull CropImageView.CropShape cropShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)cropShape), (String)"cropShape");
        if (this.cropShape != cropShape) {
            this.cropShape = cropShape;
            if (!CommonVersionCheck.INSTANCE.isAtLeastJ18()) {
                if (this.cropShape == CropImageView.CropShape.OVAL) {
                    Integer n = this.mOriginalLayerType = Integer.valueOf(this.getLayerType());
                    int n2 = 1;
                    if (n == null || n != n2) {
                        this.setLayerType(1, null);
                    } else {
                        this.mOriginalLayerType = null;
                    }
                } else if (this.mOriginalLayerType != null) {
                    Integer n = this.mOriginalLayerType;
                    Intrinsics.checkNotNull((Object)n);
                    this.setLayerType(n, null);
                    this.mOriginalLayerType = null;
                }
            }
            this.invalidate();
        }
    }

    public final void setCropCornerShape(@NotNull CropImageView.CropCornerShape cropCornerShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)cropCornerShape), (String)"cropCornerShape");
        if (this.cornerShape != cropCornerShape) {
            this.cornerShape = cropCornerShape;
            this.invalidate();
        }
    }

    public final void setCropperTextLabelVisibility(boolean isEnabled) {
        this.isCropLabelEnabled = isEnabled;
        this.invalidate();
    }

    public final void setCropLabelText(@Nullable String textLabel) {
        block0: {
            String string2 = textLabel;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.cropLabelText = it;
        }
    }

    public final void setCropLabelTextSize(float textSize) {
        this.cropLabelTextSize = textSize;
        this.invalidate();
    }

    public final void setCropLabelTextColor(int textColor) {
        this.cropLabelTextColor = textColor;
        this.invalidate();
    }

    public final void setGuidelines(@NotNull CropImageView.Guidelines guidelines) {
        Intrinsics.checkNotNullParameter((Object)((Object)guidelines), (String)"guidelines");
        if (this.guidelines != guidelines) {
            this.guidelines = guidelines;
            if (this.initializedCropWindow) {
                this.invalidate();
            }
        }
    }

    public final void setFixedAspectRatio(boolean fixAspectRatio) {
        if (this.isFixAspectRatio != fixAspectRatio) {
            this.isFixAspectRatio = fixAspectRatio;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public final int getAspectRatioX() {
        return this.mAspectRatioX;
    }

    public final void setAspectRatioX(int aspectRatioX) {
        if (!(aspectRatioX > 0)) {
            boolean bl = false;
            String string2 = "Cannot set aspect ratio value to a number less than or equal to 0.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.mAspectRatioX != aspectRatioX) {
            this.mAspectRatioX = aspectRatioX;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public final int getAspectRatioY() {
        return this.mAspectRatioY;
    }

    public final void setAspectRatioY(int aspectRatioY) {
        if (!(aspectRatioY > 0)) {
            boolean bl = false;
            String string2 = "Cannot set aspect ratio value to a number less than or equal to 0.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.mAspectRatioY != aspectRatioY) {
            this.mAspectRatioY = aspectRatioY;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public final void setSnapRadius(float snapRadius) {
        this.mSnapRadius = snapRadius;
    }

    public final void setCropCornerRadius(float cornerRadius) {
        this.mCropCornerRadius = cornerRadius;
    }

    public final boolean setMultiTouchEnabled(boolean multiTouchEnabled) {
        if (this.mMultiTouchEnabled != multiTouchEnabled) {
            this.mMultiTouchEnabled = multiTouchEnabled;
            if (this.mMultiTouchEnabled && this.mScaleDetector == null) {
                this.mScaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
            }
            return true;
        }
        return false;
    }

    public final boolean setCenterMoveEnabled(boolean centerMoveEnabled) {
        if (this.mCenterMoveEnabled != centerMoveEnabled) {
            this.mCenterMoveEnabled = centerMoveEnabled;
            return true;
        }
        return false;
    }

    public final void setMinCropResultSize(int minCropResultWidth, int minCropResultHeight) {
        this.mCropWindowHandler.setMinCropResultSize(minCropResultWidth, minCropResultHeight);
    }

    public final void setMaxCropResultSize(int maxCropResultWidth, int maxCropResultHeight) {
        this.mCropWindowHandler.setMaxCropResultSize(maxCropResultWidth, maxCropResultHeight);
    }

    public final void setCropWindowLimits(float maxWidth, float maxHeight, float scaleFactorWidth, float scaleFactorHeight) {
        this.mCropWindowHandler.setCropWindowLimits(maxWidth, maxHeight, scaleFactorWidth, scaleFactorHeight);
    }

    @Nullable
    public final Rect getInitialCropWindowRect() {
        return this.mInitialCropWindowRect;
    }

    public final void setInitialCropWindowRect(@Nullable Rect rect) {
        Rect rect2 = rect;
        if (rect2 == null) {
            rect2 = BitmapUtils.INSTANCE.getEMPTY_RECT();
        }
        this.mInitialCropWindowRect.set(rect2);
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
            this.callOnCropWindowChanged(false);
        }
    }

    public final void resetCropWindowRect() {
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
            this.callOnCropWindowChanged(false);
        }
    }

    public final void setInitialAttributeValues(@NotNull CropImageOptions options2) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.mOptions = options2;
        this.mCropWindowHandler.setInitialAttributeValues(options2);
        this.setCropLabelTextColor(options2.cropperLabelTextColor);
        this.setCropLabelTextSize(options2.cropperLabelTextSize);
        this.setCropLabelText(options2.cropperLabelText);
        this.setCropperTextLabelVisibility(options2.showCropLabel);
        this.setCropCornerRadius(options2.cropCornerRadius);
        this.setCropCornerShape(options2.cornerShape);
        this.setCropShape(options2.cropShape);
        this.setSnapRadius(options2.snapRadius);
        this.setGuidelines(options2.guidelines);
        this.setFixedAspectRatio(options2.fixAspectRatio);
        this.setAspectRatioX(options2.aspectRatioX);
        this.setAspectRatioY(options2.aspectRatioY);
        this.setMultiTouchEnabled(options2.multiTouchEnabled);
        this.setCenterMoveEnabled(options2.centerMoveEnabled);
        this.mTouchRadius = options2.touchRadius;
        this.mInitialCropWindowPaddingRatio = options2.initialCropWindowPaddingRatio;
        this.mBorderPaint = CropOverlayView.Companion.getNewPaintOrNull(options2.borderLineThickness, options2.borderLineColor);
        this.mBorderCornerOffset = options2.borderCornerOffset;
        this.mBorderCornerLength = options2.borderCornerLength;
        this.mCircleCornerFillColor = options2.circleCornerFillColorHexValue;
        this.mBorderCornerPaint = CropOverlayView.Companion.getNewPaintOrNull(options2.borderCornerThickness, options2.borderCornerColor);
        this.mGuidelinePaint = CropOverlayView.Companion.getNewPaintOrNull(options2.guidelinesThickness, options2.guidelinesColor);
        this.mBackgroundPaint = CropOverlayView.Companion.getNewPaint(options2.backgroundColor);
        this.textLabelPaint = CropOverlayView.Companion.getTextPaint(options2);
    }

    private final void initCropWindow() {
        float leftLimit = Math.max(BitmapUtils.INSTANCE.getRectLeft(this.mBoundsPoints), 0.0f);
        float topLimit = Math.max(BitmapUtils.INSTANCE.getRectTop(this.mBoundsPoints), 0.0f);
        float rightLimit = Math.min(BitmapUtils.INSTANCE.getRectRight(this.mBoundsPoints), (float)this.getWidth());
        float bottomLimit = Math.min(BitmapUtils.INSTANCE.getRectBottom(this.mBoundsPoints), (float)this.getHeight());
        if (rightLimit <= leftLimit || bottomLimit <= topLimit) {
            return;
        }
        RectF rect = new RectF();
        this.initializedCropWindow = true;
        float horizontalPadding = this.mInitialCropWindowPaddingRatio * (rightLimit - leftLimit);
        float verticalPadding = this.mInitialCropWindowPaddingRatio * (bottomLimit - topLimit);
        if (this.mInitialCropWindowRect.width() > 0 && this.mInitialCropWindowRect.height() > 0) {
            rect.left = leftLimit + (float)this.mInitialCropWindowRect.left / this.mCropWindowHandler.getScaleFactorWidth();
            rect.top = topLimit + (float)this.mInitialCropWindowRect.top / this.mCropWindowHandler.getScaleFactorHeight();
            rect.right = rect.left + (float)this.mInitialCropWindowRect.width() / this.mCropWindowHandler.getScaleFactorWidth();
            rect.bottom = rect.top + (float)this.mInitialCropWindowRect.height() / this.mCropWindowHandler.getScaleFactorHeight();
            rect.left = Math.max(leftLimit, rect.left);
            rect.top = Math.max(topLimit, rect.top);
            rect.right = Math.min(rightLimit, rect.right);
            rect.bottom = Math.min(bottomLimit, rect.bottom);
        } else if (this.isFixAspectRatio && rightLimit > leftLimit && bottomLimit > topLimit) {
            float bitmapAspectRatio = (rightLimit - leftLimit) / (bottomLimit - topLimit);
            if (bitmapAspectRatio > this.mTargetAspectRatio) {
                rect.top = topLimit + verticalPadding;
                rect.bottom = bottomLimit - verticalPadding;
                float centerX = (float)this.getWidth() / 2.0f;
                this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
                float cropWidth = Math.max(this.mCropWindowHandler.getMinCropWidth(), rect.height() * this.mTargetAspectRatio);
                float halfCropWidth = cropWidth / 2.0f;
                rect.left = centerX - halfCropWidth;
                rect.right = centerX + halfCropWidth;
            } else {
                rect.left = leftLimit + horizontalPadding;
                rect.right = rightLimit - horizontalPadding;
                float centerY = (float)this.getHeight() / 2.0f;
                float cropHeight = Math.max(this.mCropWindowHandler.getMinCropHeight(), rect.width() / this.mTargetAspectRatio);
                float halfCropHeight = cropHeight / 2.0f;
                rect.top = centerY - halfCropHeight;
                rect.bottom = centerY + halfCropHeight;
            }
        } else {
            rect.left = leftLimit + horizontalPadding;
            rect.top = topLimit + verticalPadding;
            rect.right = rightLimit - horizontalPadding;
            rect.bottom = bottomLimit - verticalPadding;
        }
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    private final void fixCropWindowRectByRules(RectF rect) {
        float adj;
        if (rect.width() < this.mCropWindowHandler.getMinCropWidth()) {
            adj = (this.mCropWindowHandler.getMinCropWidth() - rect.width()) / (float)2;
            rect.left -= adj;
            rect.right += adj;
        }
        if (rect.height() < this.mCropWindowHandler.getMinCropHeight()) {
            adj = (this.mCropWindowHandler.getMinCropHeight() - rect.height()) / (float)2;
            rect.top -= adj;
            rect.bottom += adj;
        }
        if (rect.width() > this.mCropWindowHandler.getMaxCropWidth()) {
            adj = (rect.width() - this.mCropWindowHandler.getMaxCropWidth()) / (float)2;
            rect.left += adj;
            rect.right -= adj;
        }
        if (rect.height() > this.mCropWindowHandler.getMaxCropHeight()) {
            adj = (rect.height() - this.mCropWindowHandler.getMaxCropHeight()) / (float)2;
            rect.top += adj;
            rect.bottom -= adj;
        }
        this.calculateBounds(rect);
        if (this.mCalcBounds.width() > 0.0f && this.mCalcBounds.height() > 0.0f) {
            float leftLimit = Math.max(this.mCalcBounds.left, 0.0f);
            float topLimit = Math.max(this.mCalcBounds.top, 0.0f);
            float rightLimit = Math.min(this.mCalcBounds.right, (float)this.getWidth());
            float bottomLimit = Math.min(this.mCalcBounds.bottom, (float)this.getHeight());
            if (rect.left < leftLimit) {
                rect.left = leftLimit;
            }
            if (rect.top < topLimit) {
                rect.top = topLimit;
            }
            if (rect.right > rightLimit) {
                rect.right = rightLimit;
            }
            if (rect.bottom > bottomLimit) {
                rect.bottom = bottomLimit;
            }
        }
        if (this.isFixAspectRatio && (double)Math.abs(rect.width() - rect.height() * this.mTargetAspectRatio) > 0.1) {
            if (rect.width() > rect.height() * this.mTargetAspectRatio) {
                adj = Math.abs(rect.height() * this.mTargetAspectRatio - rect.width()) / (float)2;
                rect.left += adj;
                rect.right -= adj;
            } else {
                adj = Math.abs(rect.width() / this.mTargetAspectRatio - rect.height()) / (float)2;
                rect.top += adj;
                rect.bottom -= adj;
            }
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawBackground(canvas);
        if (this.mCropWindowHandler.showGuidelines()) {
            if (this.guidelines == CropImageView.Guidelines.ON) {
                this.drawGuidelines(canvas);
            } else if (this.guidelines == CropImageView.Guidelines.ON_TOUCH && this.mMoveHandler != null) {
                this.drawGuidelines(canvas);
            }
        }
        CropImageOptions cropImageOptions = this.mOptions;
        CropImageOptions cropImageOptions2 = this.mOptions;
        this.mBorderCornerPaint = CropOverlayView.Companion.getNewPaintOrNull(cropImageOptions != null ? cropImageOptions.borderCornerThickness : 0.0f, cropImageOptions2 != null ? cropImageOptions2.borderCornerColor : -1);
        this.drawCropLabelText(canvas);
        this.drawBorders(canvas);
        this.drawCorners(canvas);
        if (Build.VERSION.SDK_INT >= 29) {
            this.setSystemGestureExclusionRects();
        }
    }

    @RequiresApi(value=29)
    private final void setSystemGestureExclusionRects() {
        Object object;
        Object object2;
        Object object3;
        RectF cropWindowRect = this.mCropWindowHandler.getRect();
        List list = this.getSystemGestureExclusionRects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"systemGestureExclusionRects");
        List list2 = list;
        int n = 0;
        if (n <= CollectionsKt.getLastIndex((List)list2)) {
            object3 = list2.get(n);
        } else {
            int it = n;
            boolean bl = false;
            object3 = new Rect();
        }
        Rect rectTop = (Rect)object3;
        List list3 = this.getSystemGestureExclusionRects();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"systemGestureExclusionRects");
        List list4 = list3;
        int n2 = 1;
        if (n2 <= CollectionsKt.getLastIndex((List)list4)) {
            object2 = list4.get(n2);
        } else {
            int it = n2;
            boolean bl = false;
            object2 = new Rect();
        }
        Rect rectMiddle = (Rect)object2;
        Object[] objectArray = this.getSystemGestureExclusionRects();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"systemGestureExclusionRects");
        Object[] objectArray2 = objectArray;
        int n3 = 2;
        if (n3 <= CollectionsKt.getLastIndex((List)objectArray2)) {
            object = objectArray2.get(n3);
        } else {
            int it = n3;
            boolean bl = false;
            object = new Rect();
        }
        Rect rectBottom = (Rect)object;
        rectTop.left = (int)(cropWindowRect.left - this.mTouchRadius);
        rectTop.right = (int)(cropWindowRect.right + this.mTouchRadius);
        rectTop.top = (int)(cropWindowRect.top - this.mTouchRadius);
        rectTop.bottom = (int)((float)rectTop.top + this.maxVerticalGestureExclusion * 0.3f);
        rectMiddle.left = rectTop.left;
        rectMiddle.right = rectTop.right;
        rectMiddle.top = (int)((cropWindowRect.top + cropWindowRect.bottom) / 2.0f - this.maxVerticalGestureExclusion * 0.2f);
        rectMiddle.bottom = (int)((float)rectMiddle.top + this.maxVerticalGestureExclusion * 0.4f);
        rectBottom.left = rectTop.left;
        rectBottom.right = rectTop.right;
        rectBottom.bottom = (int)(cropWindowRect.bottom + this.mTouchRadius);
        rectBottom.top = (int)((float)rectBottom.bottom - this.maxVerticalGestureExclusion * 0.3f);
        objectArray2 = new Rect[]{rectTop, rectMiddle, rectBottom};
        this.setSystemGestureExclusionRects(CollectionsKt.listOf((Object[])objectArray2));
    }

    private final void drawCropLabelText(Canvas canvas) {
        if (this.isCropLabelEnabled) {
            RectF rect = this.mCropWindowHandler.getRect();
            float xCoordinate = (rect.left + rect.right) / (float)2;
            float yCoordinate = rect.top - (float)50;
            Paint paint = this.textLabelPaint;
            if (paint != null) {
                Paint paint2;
                Paint $this$drawCropLabelText_u24lambda_u2d6 = paint2 = paint;
                boolean bl = false;
                $this$drawCropLabelText_u24lambda_u2d6.setTextSize(this.cropLabelTextSize);
                $this$drawCropLabelText_u24lambda_u2d6.setColor(this.cropLabelTextColor);
            }
            Paint paint3 = this.textLabelPaint;
            Intrinsics.checkNotNull((Object)paint3);
            canvas.drawText(this.cropLabelText, xCoordinate, yCoordinate, paint3);
            canvas.save();
        }
    }

    private final void drawBackground(Canvas canvas) {
        RectF rect = this.mCropWindowHandler.getRect();
        float left = Math.max(BitmapUtils.INSTANCE.getRectLeft(this.mBoundsPoints), 0.0f);
        float top = Math.max(BitmapUtils.INSTANCE.getRectTop(this.mBoundsPoints), 0.0f);
        float right = Math.min(BitmapUtils.INSTANCE.getRectRight(this.mBoundsPoints), (float)this.getWidth());
        float bottom = Math.min(BitmapUtils.INSTANCE.getRectBottom(this.mBoundsPoints), (float)this.getHeight());
        CropImageView.CropShape cropShape = this.cropShape;
        switch (cropShape == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cropShape.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                if (!this.isNonStraightAngleRotated() || !CommonVersionCheck.INSTANCE.isAtLeastJ18()) {
                    float f = rect.top;
                    Paint paint = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint);
                    canvas.drawRect(left, top, right, f, paint);
                    float f2 = rect.bottom;
                    Paint paint2 = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint2);
                    canvas.drawRect(left, f2, right, bottom, paint2);
                    float f3 = rect.top;
                    float f4 = rect.left;
                    float f5 = rect.bottom;
                    Paint paint3 = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint3);
                    canvas.drawRect(left, f3, f4, f5, paint3);
                    float f6 = rect.right;
                    float f7 = rect.top;
                    float f8 = rect.bottom;
                    Paint paint4 = this.mBackgroundPaint;
                    Intrinsics.checkNotNull((Object)paint4);
                    canvas.drawRect(f6, f7, right, f8, paint4);
                    break;
                }
                this.mPath.reset();
                this.mPath.moveTo(this.mBoundsPoints[0], this.mBoundsPoints[1]);
                this.mPath.lineTo(this.mBoundsPoints[2], this.mBoundsPoints[3]);
                this.mPath.lineTo(this.mBoundsPoints[4], this.mBoundsPoints[5]);
                this.mPath.lineTo(this.mBoundsPoints[6], this.mBoundsPoints[7]);
                this.mPath.close();
                canvas.save();
                if (CommonVersionCheck.INSTANCE.isAtLeastO26()) {
                    canvas.clipOutPath(this.mPath);
                } else {
                    canvas.clipPath(this.mPath, Region.Op.INTERSECT);
                }
                canvas.clipRect(rect, Region.Op.XOR);
                Paint paint = this.mBackgroundPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawRect(left, top, right, bottom, paint);
                canvas.restore();
                break;
            }
            case 4: {
                this.mPath.reset();
                if (CommonVersionCheck.INSTANCE.isAtLeastJ18()) {
                    this.mDrawRect.set(rect.left, rect.top, rect.right, rect.bottom);
                } else {
                    this.mDrawRect.set(rect.left + (float)2, rect.top + (float)2, rect.right - (float)2, rect.bottom - (float)2);
                }
                this.mPath.addOval(this.mDrawRect, Path.Direction.CW);
                canvas.save();
                if (CommonVersionCheck.INSTANCE.isAtLeastO26()) {
                    canvas.clipOutPath(this.mPath);
                } else {
                    canvas.clipPath(this.mPath, Region.Op.XOR);
                }
                Paint paint = this.mBackgroundPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawRect(left, top, right, bottom, paint);
                canvas.restore();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized crop shape");
            }
        }
    }

    private final void drawGuidelines(Canvas canvas) {
        if (this.mGuidelinePaint != null) {
            float f;
            if (this.mBorderPaint != null) {
                Paint paint = this.mBorderPaint;
                Intrinsics.checkNotNull((Object)paint);
                f = paint.getStrokeWidth();
            } else {
                f = 0.0f;
            }
            float sw = f;
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(sw, sw);
            float oneThirdCropWidth = rect.width() / (float)3;
            float oneThirdCropHeight = rect.height() / (float)3;
            float x1 = 0.0f;
            float x2 = 0.0f;
            float y1 = 0.0f;
            float y2 = 0.0f;
            CropImageView.CropShape cropShape = this.cropShape;
            switch (cropShape == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cropShape.ordinal()]) {
                case 4: {
                    float w = rect.width() / (float)2 - sw;
                    float h = rect.height() / (float)2 - sw;
                    x1 = rect.left + oneThirdCropWidth;
                    x2 = rect.right - oneThirdCropWidth;
                    float yv = (float)((double)h * Math.sin(Math.acos((w - oneThirdCropWidth) / w)));
                    float f2 = rect.top + h - yv;
                    float f3 = rect.bottom - h + yv;
                    Paint paint = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint);
                    canvas.drawLine(x1, f2, x1, f3, paint);
                    float f4 = rect.top + h - yv;
                    float f5 = rect.bottom - h + yv;
                    Paint paint2 = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint2);
                    canvas.drawLine(x2, f4, x2, f5, paint2);
                    y1 = rect.top + oneThirdCropHeight;
                    y2 = rect.bottom - oneThirdCropHeight;
                    float xv = (float)((double)w * Math.cos(Math.asin((h - oneThirdCropHeight) / h)));
                    float f6 = rect.left + w - xv;
                    float f7 = rect.right - w + xv;
                    Paint paint3 = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint3);
                    canvas.drawLine(f6, y1, f7, y1, paint3);
                    float f8 = rect.left + w - xv;
                    float f9 = rect.right - w + xv;
                    Paint paint4 = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint4);
                    canvas.drawLine(f8, y2, f9, y2, paint4);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    x1 = rect.left + oneThirdCropWidth;
                    x2 = rect.right - oneThirdCropWidth;
                    float f10 = rect.top;
                    float f11 = rect.bottom;
                    Paint paint = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint);
                    canvas.drawLine(x1, f10, x1, f11, paint);
                    float f12 = rect.top;
                    float f13 = rect.bottom;
                    Paint paint5 = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint5);
                    canvas.drawLine(x2, f12, x2, f13, paint5);
                    y1 = rect.top + oneThirdCropHeight;
                    y2 = rect.bottom - oneThirdCropHeight;
                    float f14 = rect.left;
                    float f15 = rect.right;
                    Paint paint6 = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint6);
                    canvas.drawLine(f14, y1, f15, y1, paint6);
                    float f16 = rect.left;
                    float f17 = rect.right;
                    Paint paint7 = this.mGuidelinePaint;
                    Intrinsics.checkNotNull((Object)paint7);
                    canvas.drawLine(f16, y2, f17, y2, paint7);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized crop shape");
                }
            }
        }
    }

    private final void drawBorders(Canvas canvas) {
        if (this.mBorderPaint != null) {
            Paint paint = this.mBorderPaint;
            Intrinsics.checkNotNull((Object)paint);
            float w = paint.getStrokeWidth();
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(w / (float)2, w / (float)2);
            CropImageView.CropShape cropShape = this.cropShape;
            switch (cropShape == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cropShape.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    Paint paint2 = this.mBorderPaint;
                    Intrinsics.checkNotNull((Object)paint2);
                    canvas.drawRect(rect, paint2);
                    break;
                }
                case 4: {
                    Paint paint3 = this.mBorderPaint;
                    Intrinsics.checkNotNull((Object)paint3);
                    canvas.drawOval(rect, paint3);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized crop shape");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void drawCorners(Canvas canvas) {
        if (this.mBorderCornerPaint != null) {
            float f;
            float f2;
            if (this.mBorderPaint != null) {
                Paint paint = this.mBorderPaint;
                Intrinsics.checkNotNull((Object)paint);
                f2 = paint.getStrokeWidth();
            } else {
                f2 = 0.0f;
            }
            float lineWidth = f2;
            Paint paint = this.mBorderCornerPaint;
            Intrinsics.checkNotNull((Object)paint);
            float cornerWidth = paint.getStrokeWidth();
            float cornerOffset = (cornerWidth - lineWidth) / (float)2;
            float cornerExtension = cornerWidth / (float)2 + cornerOffset;
            CropImageView.CropShape cropShape = this.cropShape;
            switch (cropShape == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cropShape.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    f = cornerWidth / (float)2 + this.mBorderCornerOffset;
                    break;
                }
                case 4: {
                    f = cornerWidth / (float)2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized crop shape");
                }
            }
            float w = f;
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(w, w);
            this.drawCornerBasedOnShape(canvas, rect, cornerOffset, cornerExtension);
            if (this.cornerShape == CropImageView.CropCornerShape.OVAL) {
                Paint paint2;
                CropOverlayView cropOverlayView = this;
                Integer n = this.mCircleCornerFillColor;
                if (n != null) {
                    void it;
                    int n2 = ((Number)n).intValue();
                    CropOverlayView cropOverlayView2 = cropOverlayView;
                    boolean bl = false;
                    paint2 = CropOverlayView.Companion.getNewPaintWithFill((int)it);
                    cropOverlayView = cropOverlayView2;
                } else {
                    paint2 = null;
                }
                cropOverlayView.mBorderCornerPaint = paint2;
                this.drawCornerBasedOnShape(canvas, rect, cornerOffset, cornerExtension);
            }
        }
    }

    private final void drawCornerBasedOnShape(Canvas canvas, RectF rect, float cornerOffset, float cornerExtension) {
        CropImageView.CropShape cropShape = this.cropShape;
        switch (cropShape == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cropShape.ordinal()]) {
            case 1: {
                this.drawCornerShape(canvas, rect, cornerOffset, cornerExtension, this.mCropCornerRadius);
                break;
            }
            case 4: {
                this.drawLineShape(canvas, rect, cornerOffset, cornerExtension);
                break;
            }
            case 2: {
                float f = rect.centerX() - this.mBorderCornerLength;
                float f2 = rect.top - cornerOffset;
                float f3 = rect.centerX() + this.mBorderCornerLength;
                float f4 = rect.top - cornerOffset;
                Paint paint = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawLine(f, f2, f3, f4, paint);
                float f5 = rect.centerX() - this.mBorderCornerLength;
                float f6 = rect.bottom + cornerOffset;
                float f7 = rect.centerX() + this.mBorderCornerLength;
                float f8 = rect.bottom + cornerOffset;
                Paint paint2 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint2);
                canvas.drawLine(f5, f6, f7, f8, paint2);
                break;
            }
            case 3: {
                float f = rect.left - cornerOffset;
                float f9 = rect.centerY() - this.mBorderCornerLength;
                float f10 = rect.left - cornerOffset;
                float f11 = rect.centerY() + this.mBorderCornerLength;
                Paint paint = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint);
                canvas.drawLine(f, f9, f10, f11, paint);
                float f12 = rect.right + cornerOffset;
                float f13 = rect.centerY() - this.mBorderCornerLength;
                float f14 = rect.right + cornerOffset;
                float f15 = rect.centerY() + this.mBorderCornerLength;
                Paint paint3 = this.mBorderCornerPaint;
                Intrinsics.checkNotNull((Object)paint3);
                canvas.drawLine(f12, f13, f14, f15, paint3);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized crop shape");
            }
        }
    }

    private final void drawLineShape(Canvas canvas, RectF rect, float cornerOffset, float cornerExtension) {
        float f = rect.left - cornerOffset;
        float f2 = rect.top - cornerExtension;
        float f3 = rect.left - cornerOffset;
        float f4 = rect.top + this.mBorderCornerLength;
        Paint paint = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint);
        canvas.drawLine(f, f2, f3, f4, paint);
        float f5 = rect.left - cornerExtension;
        float f6 = rect.top - cornerOffset;
        float f7 = rect.left + this.mBorderCornerLength;
        float f8 = rect.top - cornerOffset;
        Paint paint2 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawLine(f5, f6, f7, f8, paint2);
        float f9 = rect.right + cornerOffset;
        float f10 = rect.top - cornerExtension;
        float f11 = rect.right + cornerOffset;
        float f12 = rect.top + this.mBorderCornerLength;
        Paint paint3 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint3);
        canvas.drawLine(f9, f10, f11, f12, paint3);
        float f13 = rect.right + cornerExtension;
        float f14 = rect.top - cornerOffset;
        float f15 = rect.right - this.mBorderCornerLength;
        float f16 = rect.top - cornerOffset;
        Paint paint4 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint4);
        canvas.drawLine(f13, f14, f15, f16, paint4);
        float f17 = rect.left - cornerOffset;
        float f18 = rect.bottom + cornerExtension;
        float f19 = rect.left - cornerOffset;
        float f20 = rect.bottom - this.mBorderCornerLength;
        Paint paint5 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint5);
        canvas.drawLine(f17, f18, f19, f20, paint5);
        float f21 = rect.left - cornerExtension;
        float f22 = rect.bottom + cornerOffset;
        float f23 = rect.left + this.mBorderCornerLength;
        float f24 = rect.bottom + cornerOffset;
        Paint paint6 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint6);
        canvas.drawLine(f21, f22, f23, f24, paint6);
        float f25 = rect.right + cornerOffset;
        float f26 = rect.bottom + cornerExtension;
        float f27 = rect.right + cornerOffset;
        float f28 = rect.bottom - this.mBorderCornerLength;
        Paint paint7 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint7);
        canvas.drawLine(f25, f26, f27, f28, paint7);
        float f29 = rect.right + cornerExtension;
        float f30 = rect.bottom + cornerOffset;
        float f31 = rect.right - this.mBorderCornerLength;
        float f32 = rect.bottom + cornerOffset;
        Paint paint8 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint8);
        canvas.drawLine(f29, f30, f31, f32, paint8);
    }

    private final void drawCornerShape(Canvas canvas, RectF rect, float cornerOffset, float cornerExtension, float radius) {
        CropImageView.CropCornerShape cropCornerShape = this.cornerShape;
        switch (cropCornerShape == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cropCornerShape.ordinal()]) {
            case 1: {
                this.drawCircleShape(canvas, rect, cornerOffset, cornerExtension, radius);
                break;
            }
            case 2: {
                this.drawLineShape(canvas, rect, cornerOffset, cornerExtension);
                break;
            }
            case -1: {
            }
        }
    }

    private final void drawCircleShape(Canvas canvas, RectF rect, float cornerOffset, float cornerExtension, float radius) {
        float f = rect.left - cornerExtension;
        float f2 = rect.top - cornerExtension;
        Paint paint = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint);
        canvas.drawCircle(f, f2, radius, paint);
        float f3 = rect.right + cornerExtension;
        float f4 = rect.top - cornerExtension;
        Paint paint2 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f3, f4, radius, paint2);
        float f5 = rect.left - cornerExtension;
        float f6 = rect.bottom + cornerExtension;
        Paint paint3 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint3);
        canvas.drawCircle(f5, f6, radius, paint3);
        float f7 = rect.right + cornerExtension;
        float f8 = rect.bottom + cornerExtension;
        Paint paint4 = this.mBorderCornerPaint;
        Intrinsics.checkNotNull((Object)paint4);
        canvas.drawCircle(f7, f8, radius, paint4);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isEnabled()) {
            if (this.mMultiTouchEnabled) {
                ScaleGestureDetector scaleGestureDetector = this.mScaleDetector;
                if (scaleGestureDetector != null) {
                    scaleGestureDetector.onTouchEvent(event);
                }
            }
            switch (event.getAction()) {
                case 0: {
                    this.onActionDown(event.getX(), event.getY());
                    bl = true;
                    break;
                }
                case 1: 
                case 3: {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    this.onActionUp();
                    bl = true;
                    break;
                }
                case 2: {
                    this.onActionMove(event.getX(), event.getY());
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void onActionDown(float x, float y) {
        CropImageView.CropShape cropShape = this.cropShape;
        Intrinsics.checkNotNull((Object)((Object)cropShape));
        this.mMoveHandler = this.mCropWindowHandler.getMoveHandler(x, y, this.mTouchRadius, cropShape, this.mCenterMoveEnabled);
        if (this.mMoveHandler != null) {
            this.invalidate();
        }
    }

    private final void onActionUp() {
        if (this.mMoveHandler != null) {
            this.mMoveHandler = null;
            this.callOnCropWindowChanged(false);
            this.invalidate();
        }
    }

    private final void onActionMove(float x, float y) {
        if (this.mMoveHandler != null) {
            float snapRadius = this.mSnapRadius;
            RectF rect = this.mCropWindowHandler.getRect();
            if (this.calculateBounds(rect)) {
                snapRadius = 0.0f;
            }
            CropWindowMoveHandler cropWindowMoveHandler = this.mMoveHandler;
            Intrinsics.checkNotNull((Object)cropWindowMoveHandler);
            cropWindowMoveHandler.move(rect, x, y, this.mCalcBounds, this.mViewWidth, this.mViewHeight, snapRadius, this.isFixAspectRatio, this.mTargetAspectRatio);
            this.mCropWindowHandler.setRect(rect);
            this.callOnCropWindowChanged(true);
            this.invalidate();
        }
    }

    private final boolean calculateBounds(RectF rect) {
        boolean bl;
        float left = BitmapUtils.INSTANCE.getRectLeft(this.mBoundsPoints);
        float top = BitmapUtils.INSTANCE.getRectTop(this.mBoundsPoints);
        float right = BitmapUtils.INSTANCE.getRectRight(this.mBoundsPoints);
        float bottom = BitmapUtils.INSTANCE.getRectBottom(this.mBoundsPoints);
        if (!this.isNonStraightAngleRotated()) {
            this.mCalcBounds.set(left, top, right, bottom);
            bl = false;
        } else {
            float x0 = this.mBoundsPoints[0];
            float y0 = this.mBoundsPoints[1];
            float x2 = this.mBoundsPoints[4];
            float y2 = this.mBoundsPoints[5];
            float x3 = this.mBoundsPoints[6];
            float y3 = this.mBoundsPoints[7];
            if (this.mBoundsPoints[7] < this.mBoundsPoints[1]) {
                if (this.mBoundsPoints[1] < this.mBoundsPoints[3]) {
                    x0 = this.mBoundsPoints[6];
                    y0 = this.mBoundsPoints[7];
                    x2 = this.mBoundsPoints[2];
                    y2 = this.mBoundsPoints[3];
                    x3 = this.mBoundsPoints[4];
                    y3 = this.mBoundsPoints[5];
                } else {
                    x0 = this.mBoundsPoints[4];
                    y0 = this.mBoundsPoints[5];
                    x2 = this.mBoundsPoints[0];
                    y2 = this.mBoundsPoints[1];
                    x3 = this.mBoundsPoints[2];
                    y3 = this.mBoundsPoints[3];
                }
            } else if (this.mBoundsPoints[1] > this.mBoundsPoints[3]) {
                x0 = this.mBoundsPoints[2];
                y0 = this.mBoundsPoints[3];
                x2 = this.mBoundsPoints[6];
                y2 = this.mBoundsPoints[7];
                x3 = this.mBoundsPoints[0];
                y3 = this.mBoundsPoints[1];
            }
            float a0 = (y3 - y0) / (x3 - x0);
            float a1 = -1.0f / a0;
            float b0 = y0 - a0 * x0;
            float b1 = y0 - a1 * x0;
            float b2 = y2 - a0 * x2;
            float b3 = y2 - a1 * x2;
            float c0 = (rect.centerY() - rect.top) / (rect.centerX() - rect.left);
            float c1 = -c0;
            float d0 = rect.top - c0 * rect.left;
            float d1 = rect.top - c1 * rect.right;
            left = Math.max(left, (d0 - b0) / (a0 - c0) < rect.right ? (d0 - b0) / (a0 - c0) : left);
            left = Math.max(left, (d0 - b1) / (a1 - c0) < rect.right ? (d0 - b1) / (a1 - c0) : left);
            left = Math.max(left, (d1 - b3) / (a1 - c1) < rect.right ? (d1 - b3) / (a1 - c1) : left);
            right = Math.min(right, (d1 - b1) / (a1 - c1) > rect.left ? (d1 - b1) / (a1 - c1) : right);
            right = Math.min(right, (d1 - b2) / (a0 - c1) > rect.left ? (d1 - b2) / (a0 - c1) : right);
            right = Math.min(right, (d0 - b2) / (a0 - c0) > rect.left ? (d0 - b2) / (a0 - c0) : right);
            top = Math.max(top, Math.max(a0 * left + b0, a1 * right + b1));
            bottom = Math.min(bottom, Math.min(a1 * left + b3, a0 * right + b2));
            this.mCalcBounds.left = left;
            this.mCalcBounds.top = top;
            this.mCalcBounds.right = right;
            this.mCalcBounds.bottom = bottom;
            bl = true;
        }
        return bl;
    }

    private final boolean isNonStraightAngleRotated() {
        return !(this.mBoundsPoints[0] == this.mBoundsPoints[6]) && !(this.mBoundsPoints[1] == this.mBoundsPoints[7]);
    }

    private final void callOnCropWindowChanged(boolean inProgress) {
        try {
            CropWindowChangeListener cropWindowChangeListener = this.mCropWindowChangeListener;
            if (cropWindowChangeListener != null) {
                cropWindowChangeListener.onCropWindowChanged(inProgress);
            }
        }
        catch (Exception e) {
            Log.e((String)"AIC", (String)"Exception in crop window changed", (Throwable)e);
        }
    }

    @JvmOverloads
    public CropOverlayView(@Nullable Context context) {
        this(context, null, 2, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/canhub/cropper/CropOverlayView$Companion;", "", "()V", "getNewPaint", "Landroid/graphics/Paint;", "color", "", "getNewPaintOrNull", "thickness", "", "getNewPaintWithFill", "getTextPaint", "options", "Lcom/canhub/cropper/CropImageOptions;", "cropper_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Paint getTextPaint(CropImageOptions options2) {
            Paint paint;
            Paint $this$getTextPaint_u24lambda_u2d0 = paint = new Paint();
            boolean bl = false;
            $this$getTextPaint_u24lambda_u2d0.setStrokeWidth(1.0f);
            $this$getTextPaint_u24lambda_u2d0.setTextSize(options2.cropperLabelTextSize);
            $this$getTextPaint_u24lambda_u2d0.setStyle(Paint.Style.FILL);
            $this$getTextPaint_u24lambda_u2d0.setTextAlign(Paint.Align.CENTER);
            $this$getTextPaint_u24lambda_u2d0.setColor(options2.cropperLabelTextColor);
            return paint;
        }

        private final Paint getNewPaint(int color) {
            Paint paint;
            Paint $this$getNewPaint_u24lambda_u2d1 = paint = new Paint();
            boolean bl = false;
            $this$getNewPaint_u24lambda_u2d1.setColor(color);
            return paint;
        }

        /*
         * WARNING - void declaration
         */
        private final Paint getNewPaintOrNull(float thickness, int color) {
            Paint paint;
            if (thickness > 0.0f) {
                void var3_3;
                Paint borderPaint = new Paint();
                borderPaint.setColor(color);
                borderPaint.setStrokeWidth(thickness);
                borderPaint.setStyle(Paint.Style.STROKE);
                borderPaint.setAntiAlias(true);
                paint = var3_3;
            } else {
                paint = null;
            }
            return paint;
        }

        private final Paint getNewPaintWithFill(int color) {
            Paint borderPaint = new Paint();
            borderPaint.setColor(color);
            borderPaint.setStyle(Paint.Style.FILL);
            borderPaint.setAntiAlias(true);
            return borderPaint;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropOverlayView$CropWindowChangeListener;", "", "onCropWindowChanged", "", "inProgress", "", "cropper_release"})
    public static interface CropWindowChangeListener {
        public void onCropWindowChanged(boolean var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0007"}, d2={"Lcom/canhub/cropper/CropOverlayView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/canhub/cropper/CropOverlayView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "cropper_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        @TargetApi(value=11)
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            RectF rect = CropOverlayView.this.mCropWindowHandler.getRect();
            float x = detector.getFocusX();
            float y = detector.getFocusY();
            float dY = detector.getCurrentSpanY() / (float)2;
            float dX = detector.getCurrentSpanX() / (float)2;
            float newTop = y - dY;
            float newLeft = x - dX;
            float newRight = x + dX;
            float newBottom = y + dY;
            if (newLeft < newRight && newTop <= newBottom && newLeft >= 0.0f && newRight <= CropOverlayView.this.mCropWindowHandler.getMaxCropWidth() && newTop >= 0.0f && newBottom <= CropOverlayView.this.mCropWindowHandler.getMaxCropHeight()) {
                rect.set(newLeft, newTop, newRight, newBottom);
                CropOverlayView.this.mCropWindowHandler.setRect(rect);
                CropOverlayView.this.invalidate();
            }
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CropImageView.CropShape.values().length];
            nArray[CropImageView.CropShape.RECTANGLE.ordinal()] = 1;
            nArray[CropImageView.CropShape.RECTANGLE_VERTICAL_ONLY.ordinal()] = 2;
            nArray[CropImageView.CropShape.RECTANGLE_HORIZONTAL_ONLY.ordinal()] = 3;
            nArray[CropImageView.CropShape.OVAL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CropImageView.CropCornerShape.values().length];
            nArray[CropImageView.CropCornerShape.OVAL.ordinal()] = 1;
            nArray[CropImageView.CropCornerShape.RECTANGLE.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

