/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.canhub.cropper.CropException;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.common.CommonVersionCheck;
import com.canhub.cropper.utils.GetFilePathFromUriKt;
import java.io.File;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J$\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/canhub/cropper/CropImage;", "", "()V", "CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE", "", "CROP_IMAGE_ACTIVITY_REQUEST_CODE", "CROP_IMAGE_ACTIVITY_RESULT_ERROR_CODE", "CROP_IMAGE_EXTRA_BUNDLE", "", "CROP_IMAGE_EXTRA_OPTIONS", "CROP_IMAGE_EXTRA_RESULT", "CROP_IMAGE_EXTRA_SOURCE", "PICK_IMAGE_CHOOSER_REQUEST_CODE", "PICK_IMAGE_PERMISSIONS_REQUEST_CODE", "getCaptureImageOutputUriContent", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "getCaptureImageOutputUriFilePath", "uniqueName", "", "getPickImageResultUriContent", "data", "Landroid/content/Intent;", "getPickImageResultUriFilePath", "toOvalBitmap", "Landroid/graphics/Bitmap;", "bitmap", "ActivityResult", "CancelledResult", "cropper_release"})
public final class CropImage {
    @NotNull
    public static final CropImage INSTANCE = new CropImage();
    @NotNull
    public static final String CROP_IMAGE_EXTRA_SOURCE = "CROP_IMAGE_EXTRA_SOURCE";
    @NotNull
    public static final String CROP_IMAGE_EXTRA_OPTIONS = "CROP_IMAGE_EXTRA_OPTIONS";
    @NotNull
    public static final String CROP_IMAGE_EXTRA_BUNDLE = "CROP_IMAGE_EXTRA_BUNDLE";
    @NotNull
    public static final String CROP_IMAGE_EXTRA_RESULT = "CROP_IMAGE_EXTRA_RESULT";
    public static final int PICK_IMAGE_CHOOSER_REQUEST_CODE = 200;
    public static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 201;
    public static final int CAMERA_CAPTURE_PERMISSIONS_REQUEST_CODE = 2011;
    public static final int CROP_IMAGE_ACTIVITY_REQUEST_CODE = 203;
    public static final int CROP_IMAGE_ACTIVITY_RESULT_ERROR_CODE = 204;

    private CropImage() {
    }

    @NotNull
    public final Bitmap toOvalBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        canvas.drawOval(rect, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        bitmap.recycle();
        Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
        return output;
    }

    @NotNull
    public final Uri getCaptureImageOutputUriContent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Uri outputFileUri = null;
        File getImage = null;
        if (CommonVersionCheck.INSTANCE.isAtLeastQ29()) {
            Uri uri;
            getImage = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            try {
                String string = context.getPackageName() + ".cropper.fileprovider";
                File file = getImage;
                Intrinsics.checkNotNull((Object)file);
                Uri uri2 = FileProvider.getUriForFile((Context)context, (String)string, (File)new File(file.getPath(), "pickImageResult.jpeg"));
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"{\n                FilePr\u2026          )\n            }");
                uri = uri2;
            }
            catch (Exception e) {
                File file = getImage;
                Intrinsics.checkNotNull((Object)file);
                Uri uri3 = Uri.fromFile((File)new File(file.getPath(), "pickImageResult.jpeg"));
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"{\n                Uri.fr\u2026ult.jpeg\"))\n            }");
                uri = uri3;
            }
            outputFileUri = uri;
        } else {
            File file = getImage = context.getExternalCacheDir();
            Intrinsics.checkNotNull((Object)file);
            Uri uri = Uri.fromFile((File)new File(file.getPath(), "pickImageResult.jpeg"));
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(File(getImage!!\u2026 \"pickImageResult.jpeg\"))");
            outputFileUri = uri;
        }
        return outputFileUri;
    }

    @NotNull
    public final String getCaptureImageOutputUriFilePath(@NotNull Context context, boolean uniqueName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return GetFilePathFromUriKt.getFilePathFromUri(context, this.getCaptureImageOutputUriContent(context), uniqueName);
    }

    public static /* synthetic */ String getCaptureImageOutputUriFilePath$default(CropImage cropImage, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cropImage.getCaptureImageOutputUriFilePath(context, bl);
    }

    @JvmStatic
    @NotNull
    public static final Uri getPickImageResultUriContent(@NotNull Context context, @Nullable Intent data) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isCamera = true;
        Intent intent = data;
        Object object = uri = intent != null ? intent.getData() : null;
        if (uri != null) {
            String action = data.getAction();
            isCamera = action != null && Intrinsics.areEqual((Object)action, (Object)"android.media.action.IMAGE_CAPTURE");
        }
        return isCamera || uri == null ? INSTANCE.getCaptureImageOutputUriContent(context) : uri;
    }

    @JvmStatic
    @NotNull
    public static final String getPickImageResultUriFilePath(@NotNull Context context, @Nullable Intent data, boolean uniqueName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return GetFilePathFromUriKt.getFilePathFromUri(context, CropImage.getPickImageResultUriContent(context, data), uniqueName);
    }

    public static /* synthetic */ String getPickImageResultUriFilePath$default(Context context, Intent intent, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return CropImage.getPickImageResultUriFilePath(context, intent, bl);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aBY\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011B\u000f\b\u0014\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000eH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/canhub/cropper/CropImage$ActivityResult;", "Lcom/canhub/cropper/CropImageView$CropResult;", "Landroid/os/Parcelable;", "originalUri", "Landroid/net/Uri;", "uriContent", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cropPoints", "", "cropRect", "Landroid/graphics/Rect;", "rotation", "", "wholeImageRect", "sampleSize", "(Landroid/net/Uri;Landroid/net/Uri;Ljava/lang/Exception;[FLandroid/graphics/Rect;ILandroid/graphics/Rect;I)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "describeContents", "writeToParcel", "", "dest", "flags", "Companion", "cropper_release"})
    public static class ActivityResult
    extends CropImageView.CropResult
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public static final Parcelable.Creator<ActivityResult> CREATOR = (Parcelable.Creator)new Parcelable.Creator<ActivityResult>(){

            @NotNull
            public ActivityResult createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new ActivityResult(in);
            }

            @NotNull
            public ActivityResult[] newArray(int size) {
                return new ActivityResult[size];
            }
        };

        public ActivityResult(@Nullable Uri originalUri, @Nullable Uri uriContent, @Nullable Exception error, @Nullable float[] cropPoints, @Nullable Rect cropRect, int rotation, @Nullable Rect wholeImageRect, int sampleSize) {
            Intrinsics.checkNotNull((Object)cropPoints);
            super(null, originalUri, null, uriContent, error, cropPoints, cropRect, wholeImageRect, rotation, sampleSize);
        }

        protected ActivityResult(@NotNull Parcel in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Uri uri = (Uri)in.readParcelable(Uri.class.getClassLoader());
            Uri uri2 = (Uri)in.readParcelable(Uri.class.getClassLoader());
            Exception exception = (Exception)in.readSerializable();
            float[] fArray = in.createFloatArray();
            Intrinsics.checkNotNull((Object)fArray);
            super(null, uri, null, uri2, exception, fArray, (Rect)in.readParcelable(Rect.class.getClassLoader()), (Rect)in.readParcelable(Rect.class.getClassLoader()), in.readInt(), in.readInt());
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable((Parcelable)this.getOriginalUri(), flags);
            dest.writeParcelable((Parcelable)this.getUriContent(), flags);
            dest.writeSerializable((Serializable)this.getError());
            dest.writeFloatArray(this.getCropPoints());
            dest.writeParcelable((Parcelable)this.getCropRect(), flags);
            dest.writeParcelable((Parcelable)this.getWholeImageRect(), flags);
            dest.writeInt(this.getRotation());
            dest.writeInt(this.getSampleSize());
        }

        public int describeContents() {
            return 0;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/canhub/cropper/CropImage$ActivityResult$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/canhub/cropper/CropImage$ActivityResult;", "cropper_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/canhub/cropper/CropImage$CancelledResult;", "Lcom/canhub/cropper/CropImageView$CropResult;", "()V", "cropper_release"})
    public static final class CancelledResult
    extends CropImageView.CropResult {
        @NotNull
        public static final CancelledResult INSTANCE = new CancelledResult();

        private CancelledResult() {
            super(null, null, null, null, new CropException.Cancellation(), new float[0], null, null, 0, 0);
        }
    }
}

