/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.ImageView;
import com.canhub.cropper.CropOverlayView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u0016\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/canhub/cropper/CropImageAnimation;", "Landroid/view/animation/Animation;", "Landroid/view/animation/Animation$AnimationListener;", "imageView", "Landroid/widget/ImageView;", "cropOverlayView", "Lcom/canhub/cropper/CropOverlayView;", "(Landroid/widget/ImageView;Lcom/canhub/cropper/CropOverlayView;)V", "endBoundPoints", "", "endCropWindowRect", "Landroid/graphics/RectF;", "endImageMatrix", "startBoundPoints", "startCropWindowRect", "startImageMatrix", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "onAnimationEnd", "animation", "onAnimationRepeat", "onAnimationStart", "setEndState", "boundPoints", "imageMatrix", "Landroid/graphics/Matrix;", "setStartState", "cropper_release"})
public final class CropImageAnimation
extends Animation
implements Animation.AnimationListener {
    @NotNull
    private final ImageView imageView;
    @NotNull
    private final CropOverlayView cropOverlayView;
    @NotNull
    private final float[] startBoundPoints;
    @NotNull
    private final float[] endBoundPoints;
    @NotNull
    private final RectF startCropWindowRect;
    @NotNull
    private final RectF endCropWindowRect;
    @NotNull
    private final float[] startImageMatrix;
    @NotNull
    private final float[] endImageMatrix;

    public CropImageAnimation(@NotNull ImageView imageView, @NotNull CropOverlayView cropOverlayView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)((Object)cropOverlayView), (String)"cropOverlayView");
        this.imageView = imageView;
        this.cropOverlayView = cropOverlayView;
        this.startBoundPoints = new float[8];
        this.endBoundPoints = new float[8];
        this.startCropWindowRect = new RectF();
        this.endCropWindowRect = new RectF();
        this.startImageMatrix = new float[9];
        this.endImageMatrix = new float[9];
        this.setDuration(300L);
        this.setFillAfter(true);
        this.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
        this.setAnimationListener(this);
    }

    public final void setStartState(@NotNull float[] boundPoints, @NotNull Matrix imageMatrix) {
        Intrinsics.checkNotNullParameter((Object)boundPoints, (String)"boundPoints");
        Intrinsics.checkNotNullParameter((Object)imageMatrix, (String)"imageMatrix");
        this.reset();
        System.arraycopy(boundPoints, 0, this.startBoundPoints, 0, 8);
        this.startCropWindowRect.set(this.cropOverlayView.getCropWindowRect());
        imageMatrix.getValues(this.startImageMatrix);
    }

    public final void setEndState(@NotNull float[] boundPoints, @NotNull Matrix imageMatrix) {
        Intrinsics.checkNotNullParameter((Object)boundPoints, (String)"boundPoints");
        Intrinsics.checkNotNullParameter((Object)imageMatrix, (String)"imageMatrix");
        System.arraycopy(boundPoints, 0, this.endBoundPoints, 0, 8);
        this.endCropWindowRect.set(this.cropOverlayView.getCropWindowRect());
        imageMatrix.getValues(this.endImageMatrix);
    }

    protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        RectF rectF = new RectF();
        int n = 0;
        int n2 = 0;
        RectF $this$applyTransformation_u24lambda_u2d0 = rectF;
        boolean bl = false;
        $this$applyTransformation_u24lambda_u2d0.left = this.startCropWindowRect.left + (this.endCropWindowRect.left - this.startCropWindowRect.left) * interpolatedTime;
        $this$applyTransformation_u24lambda_u2d0.top = this.startCropWindowRect.top + (this.endCropWindowRect.top - this.startCropWindowRect.top) * interpolatedTime;
        $this$applyTransformation_u24lambda_u2d0.right = this.startCropWindowRect.right + (this.endCropWindowRect.right - this.startCropWindowRect.right) * interpolatedTime;
        $this$applyTransformation_u24lambda_u2d0.bottom = this.startCropWindowRect.bottom + (this.endCropWindowRect.bottom - this.startCropWindowRect.bottom) * interpolatedTime;
        RectF animRect = rectF;
        float[] animPoints = new float[8];
        n = 0;
        n2 = animPoints.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                animPoints[i] = this.startBoundPoints[i] + (this.endBoundPoints[i] - this.startBoundPoints[i]) * interpolatedTime;
            } while (n <= n2);
        }
        CropOverlayView cropOverlayView = this.cropOverlayView;
        n2 = 0;
        int n3 = 0;
        CropOverlayView $this$applyTransformation_u24lambda_u2d1 = cropOverlayView;
        boolean bl2 = false;
        $this$applyTransformation_u24lambda_u2d1.setCropWindowRect(animRect);
        $this$applyTransformation_u24lambda_u2d1.setBounds(animPoints, this.imageView.getWidth(), this.imageView.getHeight());
        $this$applyTransformation_u24lambda_u2d1.invalidate();
        float[] animMatrix = new float[9];
        n2 = 0;
        n3 = animMatrix.length + -1;
        if (n2 <= n3) {
            do {
                int i = n2++;
                animMatrix[i] = this.startImageMatrix[i] + (this.endImageMatrix[i] - this.startImageMatrix[i]) * interpolatedTime;
            } while (n2 <= n3);
        }
        ImageView imageView = this.imageView;
        n3 = 0;
        boolean bl3 = false;
        ImageView $this$applyTransformation_u24lambda_u2d2 = imageView;
        boolean bl4 = false;
        $this$applyTransformation_u24lambda_u2d2.getImageMatrix().setValues(animMatrix);
        $this$applyTransformation_u24lambda_u2d2.invalidate();
    }

    public void onAnimationStart(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }

    public void onAnimationEnd(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.imageView.clearAnimation();
    }

    public void onAnimationRepeat(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
    }
}

