/*
 * Decompiled with CFR 0.152.
 */
package com.canhub.cropper;

import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import com.canhub.cropper.CropImage;
import com.canhub.cropper.CropImageOptions;
import com.canhub.cropper.CropImageView;
import com.canhub.cropper.PickImageContract;
import com.canhub.cropper.R;
import com.canhub.cropper.common.CommonVersionCheck;
import com.canhub.cropper.databinding.CropImageActivityBinding;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\r\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\u0012\u0010$\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J\u0012\u00101\u001a\u00020\u001a2\b\u00102\u001a\u0004\u0018\u00010\bH\u0014J+\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\"2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u00108\u001a\u000209H\u0016\u00a2\u0006\u0002\u0010:J(\u0010;\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\b2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` H\u0016J\b\u0010<\u001a\u00020\u001aH\u0016J\b\u0010=\u001a\u00020\u001aH\u0016J\u0010\u0010>\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020\"H\u0016J\u0010\u0010@\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010A\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\b2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010B\u001a\u00020\u001aH\u0016J \u0010C\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)2\u0006\u0010D\u001a\u00020\"2\u0006\u0010E\u001a\u00020\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/canhub/cropper/CropImageActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/canhub/cropper/CropImageView$OnSetImageUriCompleteListener;", "Lcom/canhub/cropper/CropImageView$OnCropImageCompleteListener;", "()V", "binding", "Lcom/canhub/cropper/databinding/CropImageActivityBinding;", "cropImageUri", "Landroid/net/Uri;", "getCropImageUri", "()Landroid/net/Uri;", "setCropImageUri", "(Landroid/net/Uri;)V", "cropImageView", "Lcom/canhub/cropper/CropImageView;", "options", "Lcom/canhub/cropper/CropImageOptions;", "getOptions", "()Lcom/canhub/cropper/CropImageOptions;", "setOptions", "(Lcom/canhub/cropper/CropImageOptions;)V", "pickImage", "Landroidx/activity/result/ActivityResultLauncher;", "", "kotlin.jvm.PlatformType", "cropImage", "", "getResultIntent", "Landroid/content/Intent;", "uri", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sampleSize", "", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onCropImageComplete", "view", "result", "Lcom/canhub/cropper/CropImageView$CropResult;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPickImageResult", "resultUri", "onRequestPermissionsResult", "requestCode", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onSetImageUriComplete", "onStart", "onStop", "rotateImage", "degrees", "setCropImageView", "setResult", "setResultCancel", "updateMenuItemIconColor", "itemId", "color", "cropper_release"})
public class CropImageActivity
extends AppCompatActivity
implements CropImageView.OnSetImageUriCompleteListener,
CropImageView.OnCropImageCompleteListener {
    @Nullable
    private Uri cropImageUri;
    public CropImageOptions options;
    @Nullable
    private CropImageView cropImageView;
    private CropImageActivityBinding binding;
    @NotNull
    private final ActivityResultLauncher<Boolean> pickImage;

    public CropImageActivity() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult(new PickImageContract(), arg_0 -> CropImageActivity.pickImage$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(PickImageContract()) { onPickImageResult(it) }");
        this.pickImage = activityResultLauncher;
    }

    @Nullable
    public final Uri getCropImageUri() {
        return this.cropImageUri;
    }

    public final void setCropImageUri(@Nullable Uri uri) {
        this.cropImageUri = uri;
    }

    @NotNull
    public final CropImageOptions getOptions() {
        CropImageOptions cropImageOptions = this.options;
        if (cropImageOptions != null) {
            return cropImageOptions;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        throw null;
    }

    public final void setOptions(@NotNull CropImageOptions cropImageOptions) {
        Intrinsics.checkNotNullParameter((Object)cropImageOptions, (String)"<set-?>");
        this.options = cropImageOptions;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        String[] it;
        boolean bl;
        boolean bl2;
        super.onCreate(savedInstanceState);
        Object object = CropImageActivityBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inflate(layoutInflater)");
        this.binding = object;
        object = this.binding;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            throw null;
        }
        this.setContentView((View)((CropImageActivityBinding)object).getRoot());
        Object object2 = this.binding;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            throw null;
        }
        object = ((CropImageActivityBinding)object2).cropImageView;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.cropImageView");
        this.setCropImageView((CropImageView)object);
        Bundle bundle = this.getIntent().getBundleExtra("CROP_IMAGE_EXTRA_BUNDLE");
        object2 = bundle;
        this.cropImageUri = object2 == null ? null : (Uri)object2.getParcelable("CROP_IMAGE_EXTRA_SOURCE");
        String[] stringArray = bundle;
        object2 = stringArray == null ? null : (CropImageOptions)stringArray.getParcelable("CROP_IMAGE_EXTRA_OPTIONS");
        this.setOptions((CropImageOptions)(object2 == null ? new CropImageOptions() : object2));
        if (savedInstanceState == null) {
            if (this.cropImageUri == null || Intrinsics.areEqual((Object)this.cropImageUri, (Object)Uri.EMPTY)) {
                if (CropImage.INSTANCE.isExplicitCameraPermissionRequired((Context)this)) {
                    object2 = new String[]{"android.permission.CAMERA"};
                    this.requestPermissions((String[])object2, 2011);
                } else {
                    this.pickImage.launch((Object)true);
                }
            } else {
                boolean bl3;
                object2 = this.cropImageUri;
                if (object2 == null) {
                    bl3 = false;
                } else {
                    stringArray = object2;
                    bl2 = false;
                    bl = false;
                    it = stringArray;
                    boolean bl4 = false;
                    bl3 = CropImage.isReadExternalStoragePermissionsRequired((Context)this, (Uri)it);
                }
                if (bl3 && CommonVersionCheck.INSTANCE.isAtLeastM23()) {
                    object2 = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
                    this.requestPermissions((String[])object2, 201);
                } else {
                    object2 = this.cropImageView;
                    if (object2 != null) {
                        ((CropImageView)object2).setImageUriAsync(this.cropImageUri);
                    }
                }
            }
        }
        if ((object2 = this.getSupportActionBar()) != null) {
            stringArray = object2;
            bl2 = false;
            bl = false;
            it = stringArray;
            boolean bl5 = false;
            CharSequence charSequence = this.getOptions().activityTitle;
            boolean bl6 = false;
            this.setTitle(charSequence.length() > 0 ? this.getOptions().activityTitle : (CharSequence)this.getResources().getString(R.string.crop_image_activity_title));
            it.setDisplayHomeAsUpEnabled(true);
        }
    }

    public void onStart() {
        super.onStart();
        CropImageView cropImageView = this.cropImageView;
        if (cropImageView != null) {
            cropImageView.setOnSetImageUriCompleteListener(this);
        }
        cropImageView = this.cropImageView;
        if (cropImageView != null) {
            cropImageView.setOnCropImageCompleteListener(this);
        }
    }

    public void onStop() {
        super.onStop();
        CropImageView cropImageView = this.cropImageView;
        if (cropImageView != null) {
            cropImageView.setOnSetImageUriCompleteListener(null);
        }
        cropImageView = this.cropImageView;
        if (cropImageView != null) {
            cropImageView.setOnCropImageCompleteListener(null);
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.crop_image_menu, menu2);
        if (!this.getOptions().allowRotation) {
            menu2.removeItem(R.id.ic_rotate_left_24);
            menu2.removeItem(R.id.ic_rotate_right_24);
        } else if (this.getOptions().allowCounterRotation) {
            menu2.findItem(R.id.ic_rotate_left_24).setVisible(true);
        }
        if (!this.getOptions().allowFlipping) {
            menu2.removeItem(R.id.ic_flip_24);
        }
        if (this.getOptions().cropMenuCropButtonTitle != null) {
            menu2.findItem(R.id.crop_image_menu_crop).setTitle(this.getOptions().cropMenuCropButtonTitle);
        }
        Drawable cropIcon = null;
        try {
            if (this.getOptions().cropMenuCropButtonIcon != 0) {
                cropIcon = ContextCompat.getDrawable((Context)((Context)this), (int)this.getOptions().cropMenuCropButtonIcon);
                menu2.findItem(R.id.crop_image_menu_crop).setIcon(cropIcon);
            }
        }
        catch (Exception e) {
            Log.w((String)"AIC", (String)"Failed to read menu crop drawable", (Throwable)e);
        }
        if (this.getOptions().activityMenuIconColor != 0) {
            this.updateMenuItemIconColor(menu2, R.id.ic_rotate_left_24, this.getOptions().activityMenuIconColor);
            this.updateMenuItemIconColor(menu2, R.id.ic_rotate_right_24, this.getOptions().activityMenuIconColor);
            this.updateMenuItemIconColor(menu2, R.id.ic_flip_24, this.getOptions().activityMenuIconColor);
            if (cropIcon != null) {
                this.updateMenuItemIconColor(menu2, R.id.crop_image_menu_crop, this.getOptions().activityMenuIconColor);
            }
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = item.getItemId();
        if (n == R.id.crop_image_menu_crop) {
            this.cropImage();
        } else if (n == R.id.ic_rotate_left_24) {
            this.rotateImage(-this.getOptions().rotationDegrees);
        } else if (n == R.id.ic_rotate_right_24) {
            this.rotateImage(this.getOptions().rotationDegrees);
        } else if (n == R.id.ic_flip_24_horizontally) {
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.flipImageHorizontally();
            }
        } else if (n == R.id.ic_flip_24_vertically) {
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.flipImageVertically();
            }
        } else if (n == 16908332) {
            this.setResultCancel();
        } else {
            return super.onOptionsItemSelected(item);
        }
        return true;
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResultCancel();
    }

    protected void onPickImageResult(@Nullable Uri resultUri) {
        if (resultUri == null) {
            this.setResultCancel();
        }
        if (resultUri != null) {
            boolean bl;
            this.cropImageUri = resultUri;
            Object object = this.cropImageUri;
            if (object == null) {
                bl = false;
            } else {
                Uri uri = object;
                boolean bl2 = false;
                boolean bl3 = false;
                Uri it = uri;
                boolean bl4 = false;
                bl = CropImage.isReadExternalStoragePermissionsRequired((Context)this, it);
            }
            if (bl && CommonVersionCheck.INSTANCE.isAtLeastM23()) {
                object = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};
                this.requestPermissions((String[])object, 201);
            } else {
                object = this.cropImageView;
                if (object != null) {
                    object.setImageUriAsync(this.cropImageUri);
                }
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 201: {
                if (this.cropImageUri != null) {
                    Object object = grantResults;
                    boolean bl = false;
                    int[] nArray = object;
                    boolean bl2 = false;
                    if (!(nArray.length == 0) && grantResults[0] == 0) {
                        object = this.cropImageView;
                        if (object == null) break;
                        ((CropImageView)object).setImageUriAsync(this.cropImageUri);
                        break;
                    }
                }
                Toast.makeText((Context)((Context)this), (int)R.string.crop_image_activity_no_permissions, (int)1).show();
                this.setResultCancel();
                break;
            }
            case 2011: {
                this.pickImage.launch((Object)true);
                break;
            }
            default: {
                super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }

    @Override
    public void onSetImageUriComplete(@NotNull CropImageView view, @NotNull Uri uri, @Nullable Exception error) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (error == null) {
            CropImageView cropImageView;
            if (this.getOptions().initialCropWindowRectangle != null && (cropImageView = this.cropImageView) != null) {
                cropImageView.setCropRect(this.getOptions().initialCropWindowRectangle);
            }
            if (this.getOptions().initialRotation > -1 && (cropImageView = this.cropImageView) != null) {
                cropImageView.setRotatedDegrees(this.getOptions().initialRotation);
            }
        } else {
            this.setResult(null, error, 1);
        }
    }

    @Override
    public void onCropImageComplete(@NotNull CropImageView view, @NotNull CropImageView.CropResult result) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.setResult(result.getUriContent(), result.getError(), result.getSampleSize());
    }

    public void cropImage() {
        if (this.getOptions().noOutputImage) {
            this.setResult(null, null, 1);
        } else {
            CropImageView cropImageView = this.cropImageView;
            if (cropImageView != null) {
                cropImageView.croppedImageAsync(this.getOptions().outputCompressFormat, this.getOptions().outputCompressQuality, this.getOptions().outputRequestWidth, this.getOptions().outputRequestHeight, this.getOptions().outputRequestSizeOptions);
            }
        }
    }

    public void setCropImageView(@NotNull CropImageView cropImageView) {
        Intrinsics.checkNotNullParameter((Object)cropImageView, (String)"cropImageView");
        this.cropImageView = cropImageView;
    }

    public void rotateImage(int degrees) {
        CropImageView cropImageView = this.cropImageView;
        if (cropImageView != null) {
            cropImageView.rotateImage(degrees);
        }
    }

    public void setResult(@Nullable Uri uri, @Nullable Exception error, int sampleSize) {
        int n;
        CropImageActivity cropImageActivity = this;
        Exception exception = error;
        if (exception == null) {
            n = -1;
        } else {
            int n2;
            Exception exception2 = exception;
            boolean bl = false;
            boolean bl2 = false;
            Exception exception3 = exception2;
            CropImageActivity cropImageActivity2 = cropImageActivity;
            boolean bl3 = false;
            int n3 = 204;
            cropImageActivity = cropImageActivity2;
            n = n2 = n3;
        }
        cropImageActivity.setResult(n, this.getResultIntent(uri, error, sampleSize));
        this.finish();
    }

    public void setResultCancel() {
        this.setResult(0);
        this.finish();
    }

    @NotNull
    public Intent getResultIntent(@Nullable Uri uri, @Nullable Exception error, int sampleSize) {
        int n;
        CropImageView cropImageView = this.cropImageView;
        Uri uri2 = cropImageView == null ? null : cropImageView.getImageUri();
        cropImageView = this.cropImageView;
        float[] fArray = cropImageView == null ? null : cropImageView.getCropPoints();
        cropImageView = this.cropImageView;
        Rect rect = cropImageView == null ? null : cropImageView.getCropRect();
        cropImageView = this.cropImageView;
        int n2 = cropImageView == null ? 0 : (n = cropImageView.getRotatedDegrees());
        cropImageView = this.cropImageView;
        CropImage.ActivityResult result = new CropImage.ActivityResult(uri2, uri, error, fArray, rect, n2, cropImageView == null ? null : cropImageView.getWholeImageRect(), sampleSize);
        Intent intent = new Intent();
        intent.putExtras(this.getIntent());
        intent.putExtra("CROP_IMAGE_EXTRA_RESULT", (Parcelable)result);
        return intent;
    }

    public void updateMenuItemIconColor(@NotNull Menu menu2, int itemId, int color) {
        Drawable menuItemIcon;
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        MenuItem menuItem = menu2.findItem(itemId);
        if (menuItem != null && (menuItemIcon = menuItem.getIcon()) != null) {
            try {
                Drawable drawable = menuItemIcon;
                boolean bl = false;
                boolean bl2 = false;
                Drawable $this$updateMenuItemIconColor_u24lambda_u2d5 = drawable;
                boolean bl3 = false;
                $this$updateMenuItemIconColor_u24lambda_u2d5.mutate();
                $this$updateMenuItemIconColor_u24lambda_u2d5.setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)color, (BlendModeCompat)BlendModeCompat.SRC_ATOP));
                menuItem.setIcon(menuItemIcon);
            }
            catch (Exception e) {
                Log.w((String)"AIC", (String)"Failed to update menu item color", (Throwable)e);
            }
        }
    }

    private static final void pickImage$lambda-0(CropImageActivity this$0, Uri it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onPickImageResult(it);
    }
}

