/*
 * Decompiled with CFR 0.152.
 */
package io.calidog.certstream;

import io.calidog.certstream.CertStreamClient;
import io.calidog.certstream.CertStreamClientImpl;
import io.calidog.certstream.CertStreamCloseHandler;
import io.calidog.certstream.CertStreamErrorHandler;
import io.calidog.certstream.CertStreamOpenHandler;
import io.calidog.certstream.CertStreamStringMessageHandler;
import java.net.URISyntaxException;
import org.java_websocket.handshake.ServerHandshake;

public class CertStreamClientImplFactory {
    private final CertStreamOpenHandler openHandler;
    private final CertStreamCloseHandler closeHandler;
    private final CertStreamErrorHandler errorHandler;

    public CertStreamClientImplFactory(CertStreamOpenHandler openHandler, CertStreamCloseHandler closeHandler, CertStreamErrorHandler errorHandler) {
        this.closeHandler = closeHandler;
        this.errorHandler = errorHandler;
        this.openHandler = openHandler;
    }

    public CertStreamClientImpl make(CertStreamStringMessageHandler messageHandler) {
        return new CertStreamClientImpl(this.createClient(messageHandler));
    }

    public CertStreamClientImpl make(CertStreamStringMessageHandler messageHandler, String serverURI) {
        CertStreamClientImpl certStreamClient = null;
        try {
            certStreamClient = new CertStreamClientImpl(this.createClient(messageHandler), serverURI);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return certStreamClient;
    }

    public CertStreamClient createClient(final CertStreamStringMessageHandler messageHandler) {
        return new CertStreamClient(){

            @Override
            public void onOpen(ServerHandshake serverHandshake) {
                CertStreamClientImplFactory.this.openHandler.onOpen(serverHandshake);
            }

            @Override
            public void onMessage(String s) {
                messageHandler.onMessage(s);
            }

            @Override
            public void onClose(int i, String s, boolean b) {
                CertStreamClientImplFactory.this.closeHandler.onClose(i, s, b);
            }

            @Override
            public void onError(Exception e) {
                CertStreamClientImplFactory.this.errorHandler.onError(e);
            }
        };
    }
}

