/*
 * Decompiled with CFR 0.152.
 */
package io.calidog.certstream;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.calidog.certstream.BoringParts;
import io.calidog.certstream.CertStreamMessage;
import io.calidog.certstream.CertStreamMessageHandler;
import io.calidog.certstream.CertStreamMessagePOJO;
import java.security.cert.CertificateException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertStream {
    private static final Logger logger = LoggerFactory.getLogger(CertStream.class);

    public static void onMessageString(Consumer<String> handler) {
        new Thread(() -> {
            BoringParts theBoringParts = new BoringParts(handler::accept);
            CertStream.runThread(theBoringParts);
        }).start();
    }

    public static void onMessageStringAlternativeServer(Consumer<String> handler, String serverURI) {
        new Thread(() -> {
            BoringParts theBoringParts = new BoringParts(handler::accept, 0L, serverURI);
            CertStream.runThread(theBoringParts);
        }).start();
    }

    public static void onMessage(CertStreamMessageHandler handler) {
        CertStream.onMessageString(string -> {
            CertStreamMessage fullMsg;
            CertStreamMessagePOJO msg;
            try {
                msg = (CertStreamMessagePOJO)new Gson().fromJson(string, CertStreamMessagePOJO.class);
                if (msg.messageType.equalsIgnoreCase("heartbeat")) {
                    return;
                }
            }
            catch (JsonSyntaxException e) {
                System.out.println(e.getMessage());
                logger.warn("onMessage had an exception parsing some json", (Throwable)e);
                return;
            }
            try {
                fullMsg = CertStreamMessage.fromPOJO(msg);
            }
            catch (CertificateException e) {
                logger.warn("Encountered a CertificateException", (Throwable)e);
                return;
            }
            handler.onMessage(fullMsg);
        });
    }

    public static void onMessageAlternativeServer(CertStreamMessageHandler handler, String serverURI) {
        CertStream.onMessageStringAlternativeServer(string -> {
            CertStreamMessage fullMsg;
            CertStreamMessagePOJO msg;
            try {
                msg = (CertStreamMessagePOJO)new Gson().fromJson(string, CertStreamMessagePOJO.class);
                if (msg.messageType.equalsIgnoreCase("heartbeat")) {
                    return;
                }
            }
            catch (JsonSyntaxException e) {
                System.out.println(e.getMessage());
                logger.warn("onMessageAlternativeServer had an exception parsing some json", (Throwable)e);
                return;
            }
            try {
                fullMsg = CertStreamMessage.fromPOJO(msg);
            }
            catch (CertificateException e) {
                logger.warn("Encountered a CertificateException", (Throwable)e);
                return;
            }
            handler.onMessage(fullMsg);
        }, serverURI);
    }

    public static void runThread(BoringParts theBoringParts) {
        while (theBoringParts.isNotClosed()) {
            Thread.yield();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!Thread.interrupted()) continue;
            break;
        }
    }
}

