/*
 * Decompiled with CFR 0.152.
 */
package com.caesar.musicspectrumbarlibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.caesar.musicspectrumbarlibrary.R;
import com.caesar.musicspectrumbarlibrary.SpectrumData;
import java.util.ArrayList;

public class MusicSpectrumBar
extends View {
    private float mLastXIntercept = 0.0f;
    private float mLastYIntercept = 0.0f;
    private int viewAllWidth;
    private int viewAllHigh;
    private Paint paint;
    private ArrayList<SpectrumData> myCData;
    private int[] highD = new int[]{1, 3, 5, 4, 6, 2, 7, 5, 6, 3, 2, 1, 2, 1, 2, 6, 5, 4, 2, 7, 5, 2, 3, 1, 2, 1, 3, 2, 1};
    private String[] ColorStr = new String[]{"#0050dc", "#0650dc", "#0b51dd", "#1151dd", "#1951de", "#2052de", "#2852df", "#3153df", "#3a53e0", "#4454e0", "#4e54e1", "#5855e2", "#6255e2", "#6d56e3", "#7756e3", "#8257e4", "#8c58e5", "#9758e5", "#a159e6", "#ab59e7", "#b45ae7", "#be5ae8", "#c65be8", "#ce5be9", "#d65ce9", "#dd5cea", "#e45cea", "#e95deb", "#ee5deb"};
    private OnSeekChangeListener listener;
    private int currentT = -1;
    private int roundAngle;
    private int poseType;
    private float gapMultiple;
    private int unSelectColor;
    private int colorGradient;
    private float SpectMultiple;

    public MusicSpectrumBar(Context context) {
        this(context, null);
    }

    public MusicSpectrumBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MusicSpectrumBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.MusicSpectrumBar);
        this.roundAngle = array.getInt(R.styleable.MusicSpectrumBar_roundAngle, 5);
        this.poseType = array.getInt(R.styleable.MusicSpectrumBar_poseType, 0);
        this.gapMultiple = array.getFloat(R.styleable.MusicSpectrumBar_gapMultiple, 2.0f);
        this.unSelectColor = array.getColor(R.styleable.MusicSpectrumBar_unSelectColor, -1);
        this.colorGradient = array.getInt(R.styleable.MusicSpectrumBar_colorGradient, 0);
        this.SpectMultiple = array.getFloat(R.styleable.MusicSpectrumBar_SpectMultiple, 0.5f);
        array.recycle();
        this.clearItems();
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.myCData.isEmpty()) {
            return;
        }
        if (this.paint == null) {
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
        }
        for (int i = 0; i < this.highD.length; ++i) {
            if (i <= this.currentT) {
                if (this.currentT > 0) {
                    if (this.colorGradient == 0) {
                        int selectCol = i * this.highD.length / this.currentT;
                        if (selectCol < 0) {
                            selectCol = 0;
                        } else if (selectCol > this.highD.length - 1) {
                            selectCol = this.highD.length - 1;
                        }
                        this.paint.setColor(Color.parseColor((String)this.ColorStr[selectCol]));
                    } else {
                        this.paint.setColor(Color.parseColor((String)this.ColorStr[i]));
                    }
                } else {
                    this.paint.setColor(Color.parseColor((String)this.ColorStr[0]));
                }
            } else {
                this.paint.setColor(this.unSelectColor);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                canvas.drawRoundRect(this.myCData.get(i).getLeft(), this.myCData.get(i).getTop(), this.myCData.get(i).getRight(), this.myCData.get(i).getBottom(), (float)this.roundAngle, (float)this.roundAngle, this.paint);
                continue;
            }
            canvas.drawRect(this.myCData.get(i).getLeft(), this.myCData.get(i).getTop(), this.myCData.get(i).getRight(), this.myCData.get(i).getBottom(), this.paint);
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                float refan;
                this.performClick();
                if (this.listener != null) {
                    this.listener.onStartTrackingTouch();
                    refan = event.getX();
                    if (refan < 0.0f) {
                        refan = 0.0f;
                    } else if (refan > (float)this.viewAllWidth) {
                        refan = this.viewAllWidth;
                    }
                    this.listener.onProgressChanged((int)(refan / (float)this.viewAllWidth * 100.0f), true);
                }
            }
            case 2: {
                float refan;
                this.currentT = (int)(event.getX() / (float)this.viewAllWidth * (float)this.highD.length);
                if (this.currentT > this.highD.length) {
                    this.currentT = this.highD.length;
                }
                this.invalidate();
                if (this.listener != null) {
                    refan = event.getX();
                    if (refan < 0.0f) {
                        refan = 0.0f;
                    } else if (refan > (float)this.viewAllWidth) {
                        refan = this.viewAllWidth;
                    }
                    this.listener.onProgressChanged((int)(refan / (float)this.viewAllWidth * 100.0f), true);
                }
                return true;
            }
            case 1: {
                if (this.listener == null) break;
                float refan = event.getX();
                if (refan < 0.0f) {
                    refan = 0.0f;
                } else if (refan > (float)this.viewAllWidth) {
                    refan = this.viewAllWidth;
                }
                this.listener.onStopTrackingTouch((int)(refan / (float)this.viewAllWidth * 100.0f));
            }
        }
        return super.onTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float deltaX = x - this.mLastXIntercept;
                float deltaY = y - this.mLastYIntercept;
                if (Math.abs(deltaX) < 1.0f && Math.abs(deltaY) > 10.0f * Math.abs(deltaX)) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    break;
                }
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 1: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                break;
            }
        }
        this.mLastXIntercept = x;
        this.mLastYIntercept = y;
        return super.dispatchTouchEvent(event);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.viewAllWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.viewAllHigh = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setItems();
    }

    private void setItems() {
        float lineWidth = (float)this.viewAllWidth / ((float)(this.highD.length - 1) * (1.0f + this.gapMultiple) + 1.0f);
        float lineMinHigh = (float)this.viewAllHigh / (float)this.getMaxIntArr();
        float SpectMinHigh = (float)this.viewAllHigh * (1.0f - this.SpectMultiple) / (float)(this.getMaxIntArr() - 1);
        if (this.myCData.isEmpty()) {
            for (int i = 0; i < this.highD.length; ++i) {
                float lineStartW = (float)i * (1.0f + this.gapMultiple) * lineWidth;
                float lineStartH = 0.0f;
                if (this.poseType == 0) {
                    lineStartH = ((float)this.viewAllHigh - (float)this.highD[i] * lineMinHigh) / 2.0f;
                    this.myCData.add(new SpectrumData(lineStartW, lineStartW + lineWidth, lineStartH, lineStartH + (float)this.highD[i] * lineMinHigh, this.ColorStr[i]));
                    continue;
                }
                if (this.poseType == 1) {
                    lineStartH = (float)this.viewAllHigh - (float)this.highD[i] * lineMinHigh;
                    this.myCData.add(new SpectrumData(lineStartW, lineStartW + lineWidth, lineStartH, lineStartH + (float)this.highD[i] * lineMinHigh, this.ColorStr[i]));
                    continue;
                }
                if (this.poseType == 2) {
                    this.myCData.add(new SpectrumData(lineStartW, lineStartW + lineWidth, lineStartH, lineStartH + (float)this.highD[i] * lineMinHigh, this.ColorStr[i]));
                    continue;
                }
                this.myCData.add(new SpectrumData(lineStartW, lineStartW + lineWidth, SpectMinHigh * (float)(this.highD[i] - 1), SpectMinHigh * (float)(this.highD[i] - 1) + (float)this.viewAllHigh * this.SpectMultiple, this.ColorStr[i]));
            }
        }
    }

    private int getMaxIntArr() {
        int maxSin = 0;
        for (int item : this.highD) {
            if (item <= maxSin) continue;
            maxSin = item;
        }
        return maxSin;
    }

    private void clearItems() {
        if (this.myCData == null) {
            this.myCData = new ArrayList();
        }
        this.myCData.clear();
    }

    public void setDatas(int[] highDArr, String[] colorArr) {
        this.highD = highDArr;
        this.ColorStr = colorArr;
    }

    public void setCurrent(int current) {
        this.currentT = this.highD.length * current / 100;
        this.invalidate();
        if (this.listener != null) {
            this.listener.onProgressChanged(current, false);
        }
    }

    public void setOnSeekBarChangeListener(OnSeekChangeListener listener) {
        this.listener = listener;
    }

    public static interface OnSeekChangeListener {
        public void onProgressChanged(int var1, boolean var2);

        public void onStartTrackingTouch();

        public void onStopTrackingTouch(int var1);
    }
}

